/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import org.bruno.elytraEssentials.helpers.FoliaHelper;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bukkit.Bukkit;

public class TpsHandler {
    private final FoliaHelper foliaHelper;
    private final MessagesHelper messagesHelper;
    private static final int LOW_TPS_SECONDS_THRESHOLD = 10;
    private static final double LOW_TPS_THRESHOLD = 18.0;
    private static final double HEALTHY_TPS_THRESHOLD = 19.5;
    private boolean isLagProtectionActive = false;
    private CancellableTask task;
    private int consecutiveLowTpsSeconds = 0;

    public TpsHandler(FoliaHelper foliaHelper, MessagesHelper messagesHelper) {
        this.foliaHelper = foliaHelper;
        this.messagesHelper = messagesHelper;
    }

    public void start() {
        if (this.task != null) {
            return;
        }
        this.task = this.foliaHelper.runTaskTimerGlobal(this::runTpsCheck, 1200L, 20L);
    }

    public void cancel() {
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
    }

    private void runTpsCheck() {
        double currentTps = Bukkit.getServer().getTPS()[0];
        if (currentTps < 18.0) {
            ++this.consecutiveLowTpsSeconds;
            if (this.consecutiveLowTpsSeconds >= 10 && !this.isLagProtectionActive) {
                this.isLagProtectionActive = true;
                this.messagesHelper.sendConsoleMessage("Server TPS is low (" + String.format("%.1f", currentTps) + "). Disabling elytra effects.");
            }
        } else {
            this.consecutiveLowTpsSeconds = 0;
            if (this.isLagProtectionActive && currentTps >= 19.5) {
                this.isLagProtectionActive = false;
                this.messagesHelper.sendConsoleMessage("Server TPS has recovered (" + String.format("%.1f", currentTps) + "). Re-enabling elytra effects.");
            }
        }
    }

    public boolean isLagProtectionActive() {
        return this.isLagProtectionActive;
    }

    public double getTps() {
        return Bukkit.getServer().getTPS()[0];
    }
}

