/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.PluginInfoHandler;
import org.bruno.elytraEssentials.helpers.FoliaHelper;

public class UpdaterHandler {
    private final Logger logger;
    private final FoliaHelper foliaHelper;
    private final ConfigHandler configHandler;
    private final PluginInfoHandler pluginInfoHandler;

    public UpdaterHandler(Logger logger, FoliaHelper foliaHelper, ConfigHandler configHandler, PluginInfoHandler pluginInfoHandler) {
        this.logger = logger;
        this.foliaHelper = foliaHelper;
        this.configHandler = configHandler;
        this.pluginInfoHandler = pluginInfoHandler;
    }

    public void performCheck() {
        if (!this.configHandler.getIsCheckForUpdatesEnabled()) {
            return;
        }
        this.foliaHelper.runAsyncTask(() -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=126002").openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String latestVersion = reader.readLine();
                this.foliaHelper.runTaskOnMainThread(() -> {
                    this.pluginInfoHandler.setUpdateInfo(latestVersion);
                    if (this.pluginInfoHandler.isUpdateAvailable()) {
                        this.logger.warning("A new version (" + this.pluginInfoHandler.getLatestVersion() + ") is available!");
                    }
                });
            }
            catch (IOException exception) {
                this.logger.warning("Cannot check for updates: " + exception.getMessage());
            }
        });
    }
}

