/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.utils.ElytraUpgrade;
import org.bruno.elytraEssentials.utils.UpgradeType;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class UpgradeHandler {
    private final ElytraEssentials plugin;
    private final Logger logger;
    private FileConfiguration fileConfiguration;
    private final HashMap<UpgradeType, ElytraUpgrade> upgradeValues = new HashMap();

    public UpgradeHandler(ElytraEssentials plugin, FileConfiguration fileConfiguration, Logger logger) {
        this.plugin = plugin;
        this.fileConfiguration = fileConfiguration;
        this.logger = logger;
        this.loadUpgrades();
    }

    public void reload(FileConfiguration newFileConfiguration) {
        this.fileConfiguration = newFileConfiguration;
        this.loadUpgrades();
    }

    public void loadUpgrades() {
        ConfigurationSection section = this.fileConfiguration.getConfigurationSection("upgrades");
        if (section == null) {
            this.logger.warning("No section 'upgrades' found in upgrades.yml.");
            return;
        }
        for (UpgradeType type : UpgradeType.values()) {
            ConfigurationSection upgrade = section.getConfigurationSection(type.name().toLowerCase());
            if (upgrade == null) continue;
            String description = upgrade.getString("description", type.getDescription());
            int maxLevel = upgrade.getInt("max-level", type.getMaxLevel());
            double bonus = upgrade.getDouble("bonus-per-level", type.getValuePerLevel());
            double baseCost = upgrade.getDouble("base-cost", 1000.0);
            double costMultiplier = upgrade.getDouble("cost-multiplier", 1.8);
            this.upgradeValues.put(type, new ElytraUpgrade(maxLevel, bonus, description, baseCost, costMultiplier));
        }
    }

    public Map<UpgradeType, ElytraUpgrade> getUpgradeValues() {
        return this.upgradeValues;
    }

    public double getBonusSpeed(ItemStack elytra) {
        return this.getUpgradeBonus(elytra, UpgradeType.MAX_VELOCITY);
    }

    public double getFlightEfficiencyChance(ItemStack elytra) {
        return this.getUpgradeBonus(elytra, UpgradeType.FLIGHT_EFFICIENCY);
    }

    public double getBonusBoostPower(ItemStack elytra) {
        return this.getUpgradeBonus(elytra, UpgradeType.BOOST_POWER);
    }

    public int getBonusArmorDurability(ItemStack elytra) {
        return (int)this.getUpgradeBonus(elytra, UpgradeType.ARMOR_DURABILITY);
    }

    public double getKineticResistanceChance(ItemStack elytra) {
        return this.getUpgradeBonus(elytra, UpgradeType.KINETIC_RESISTANCE);
    }

    public double getBonusArmor(ItemStack elytra) {
        return this.getUpgradeBonus(elytra, UpgradeType.ARMOR_PROTECTION);
    }

    public double getBonusToughness(ItemStack elytra) {
        return this.getUpgradeBonus(elytra, UpgradeType.ARMOR_TOUGHNESS);
    }

    private int getUpgradeLevel(ItemStack elytra, UpgradeType type) {
        if (elytra == null || !elytra.hasItemMeta()) {
            return 0;
        }
        ItemMeta meta = elytra.getItemMeta();
        if (meta == null) {
            return 0;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        NamespacedKey key = new NamespacedKey((Plugin)this.plugin, type.getKey());
        return (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)0);
    }

    private double getUpgradeBonus(ItemStack elytra, UpgradeType type) {
        int level = this.getUpgradeLevel(elytra, type);
        if (level <= 0) {
            return 0.0;
        }
        ElytraUpgrade data = this.upgradeValues.get((Object)type);
        if (data == null) {
            data = new ElytraUpgrade(type.getMaxLevel(), type.getValuePerLevel(), type.getDescription(), 1000.0, 1.8);
        }
        level = Math.min(level, data.getMaxLevel());
        double bonus = (double)level * data.getBonusPerLevel();
        switch (type) {
            case FLIGHT_EFFICIENCY: 
            case KINETIC_RESISTANCE: 
            case BOOST_POWER: {
                bonus = Math.min(bonus, 100.0);
                break;
            }
            case MAX_VELOCITY: {
                bonus = Math.min(bonus, 200.0);
                break;
            }
            case ARMOR_DURABILITY: {
                bonus = Math.min(bonus, 500.0);
                break;
            }
            case ARMOR_PROTECTION: 
            case ARMOR_TOUGHNESS: {
                bonus = Math.min(bonus, 20.0);
                break;
            }
        }
        return bonus;
    }
}

