/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.utils.ServerVersion;
import org.bruno.elytraEssentials.utils.UpgradeType;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ArmoredElytraHelper {
    private final ElytraEssentials plugin;
    private final NamespacedKey armoredElytraKey;
    private final NamespacedKey materialKey;
    private final NamespacedKey previewItemKey;
    private final NamespacedKey durabilityKey;
    private final NamespacedKey maxDurabilityKey;
    private final Logger logger;

    public ArmoredElytraHelper(ElytraEssentials plugin, Logger logger) {
        this.plugin = plugin;
        this.armoredElytraKey = new NamespacedKey((Plugin)plugin, "armored-elytra");
        this.materialKey = new NamespacedKey((Plugin)plugin, "armor-material");
        this.previewItemKey = new NamespacedKey((Plugin)plugin, "preview_item");
        this.durabilityKey = new NamespacedKey((Plugin)plugin, "armor-durability");
        this.maxDurabilityKey = new NamespacedKey((Plugin)plugin, "max-armor-durability");
        this.logger = logger;
    }

    public ItemStack createArmoredElytra(ItemStack elytra, ItemStack chestplate, Player player) {
        int maxArmorDurability;
        ItemStack armoredElytra = new ItemStack(Material.ELYTRA);
        ItemMeta meta = armoredElytra.getItemMeta();
        ItemMeta chestplateMeta = chestplate.getItemMeta();
        if (meta == null || chestplateMeta == null) {
            return armoredElytra;
        }
        ItemMeta itemMeta = elytra.getItemMeta();
        if (itemMeta instanceof Damageable) {
            Damageable sourceDamage = (Damageable)itemMeta;
            if (meta instanceof Damageable) {
                Damageable targetDamage = (Damageable)meta;
                targetDamage.setDamage(sourceDamage.getDamage());
            }
        }
        Material armorType = chestplate.getType();
        int currentArmorDurability = maxArmorDurability = armorType.getMaxDurability();
        ItemMeta itemMeta2 = chestplate.getItemMeta();
        if (itemMeta2 instanceof Damageable) {
            Damageable sourceArmorDamage = (Damageable)itemMeta2;
            currentArmorDurability = maxArmorDurability - sourceArmorDamage.getDamage();
        }
        int armorPoints = this.getArmorPoints(armorType);
        int armorToughness = this.getArmorToughness(armorType);
        meta.setDisplayName("\u00a7b\u00a7lArmored Elytra");
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77A fusion of flight and protection.");
        lore.add("");
        lore.add("\u00a76Armor Plating:");
        lore.add(this.getDurabilityBarString(currentArmorDurability, maxArmorDurability));
        lore.add("");
        lore.add(ColorHelper.parse("&#0067FFArmor Stats:"));
        lore.add(ColorHelper.parse(String.format(" \u00a7f\u25aa \u00a77Armor: &#B0D0FF+%d", armorPoints)));
        if (armorToughness > 0) {
            lore.add(ColorHelper.parse(String.format(" &f\u25aa &7Armor Toughness: &#B0D0FF+%d", armorToughness)));
        }
        HashMap<Enchantment, Integer> displayEnchants = new HashMap<Enchantment, Integer>(chestplate.getEnchantments());
        elytra.getEnchantments().forEach((enchant, level) -> displayEnchants.merge((Enchantment)enchant, (Integer)level, Integer::max));
        if (!displayEnchants.isEmpty()) {
            lore.add("");
            lore.add("\u00a7dEnchantments:");
        }
        for (Map.Entry entry : displayEnchants.entrySet()) {
            lore.add(String.format(" \u00a7f\u25aa \u00a77%s %d", this.getCapitalizedName(((Enchantment)entry.getKey()).getKey().getKey()), entry.getValue()));
        }
        meta.setLore(lore);
        elytra.getEnchantments().forEach((enchant, level) -> {
            String normalizedKey = this.getStandardEnchantmentKey((Enchantment)enchant);
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "elytra_enchant_" + normalizedKey);
            meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, level);
        });
        chestplate.getEnchantments().forEach((enchant, level) -> {
            String normalizedKey = this.getStandardEnchantmentKey((Enchantment)enchant);
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "chestplate_enchant_" + normalizedKey);
            meta.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, level);
        });
        displayEnchants.forEach((enchant, level) -> meta.addEnchant(enchant, level.intValue(), true));
        meta.addEnchant(Enchantment.LURE, 1, true);
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        meta.getPersistentDataContainer().set(this.armoredElytraKey, PersistentDataType.BYTE, (Object)1);
        meta.getPersistentDataContainer().set(this.durabilityKey, PersistentDataType.INTEGER, (Object)currentArmorDurability);
        meta.getPersistentDataContainer().set(this.maxDurabilityKey, PersistentDataType.INTEGER, (Object)maxArmorDurability);
        meta.getPersistentDataContainer().set(this.materialKey, PersistentDataType.STRING, (Object)chestplate.getType().name());
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "forged-by"), PersistentDataType.STRING, (Object)player.getName());
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "damage-absorbed"), PersistentDataType.FLOAT, (Object)Float.valueOf(0.0f));
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "plating-shattered"), PersistentDataType.INTEGER, (Object)0);
        meta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "preview_item"), PersistentDataType.BYTE, (Object)1);
        armoredElytra.setItemMeta(meta);
        return armoredElytra;
    }

    public ItemStack reassembleChestplate(ItemStack armoredElytra) {
        ItemMeta sourceMeta = armoredElytra.getItemMeta();
        if (sourceMeta == null) {
            return null;
        }
        PersistentDataContainer container = sourceMeta.getPersistentDataContainer();
        String materialName = (String)container.get(this.materialKey, PersistentDataType.STRING);
        Material armorType = materialName != null ? Material.matchMaterial((String)materialName) : Material.DIAMOND_CHESTPLATE;
        ItemStack chestplate = new ItemStack(armorType);
        ItemMeta chestMeta = chestplate.getItemMeta();
        if (chestMeta != null) {
            if (chestMeta instanceof Damageable) {
                Damageable targetDamage = (Damageable)chestMeta;
                int max = (Integer)container.getOrDefault(this.maxDurabilityKey, PersistentDataType.INTEGER, (Object)1);
                int current = (Integer)container.getOrDefault(this.durabilityKey, PersistentDataType.INTEGER, (Object)0);
                targetDamage.setDamage(max - current);
            }
            for (Enchantment enchantment : Enchantment.values()) {
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "chestplate_enchant_" + enchantment.getKey().getKey());
                if (!container.has(key, PersistentDataType.INTEGER)) continue;
                int level = (Integer)container.get(key, PersistentDataType.INTEGER);
                chestMeta.addEnchant(enchantment, level, true);
            }
            chestMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "preview_item"), PersistentDataType.BYTE, (Object)1);
            chestplate.setItemMeta(chestMeta);
        }
        return chestplate;
    }

    public ItemStack reassembleElytra(ItemStack armoredElytra) {
        ItemMeta sourceMeta = armoredElytra.getItemMeta();
        if (sourceMeta == null) {
            return null;
        }
        PersistentDataContainer container = sourceMeta.getPersistentDataContainer();
        ItemStack plainElytra = new ItemStack(Material.ELYTRA);
        ItemMeta elytraMeta = plainElytra.getItemMeta();
        if (elytraMeta instanceof Damageable) {
            Damageable targetDamage = (Damageable)elytraMeta;
            if (sourceMeta instanceof Damageable) {
                Damageable sourceDamage = (Damageable)sourceMeta;
                targetDamage.setDamage(sourceDamage.getDamage());
            }
        }
        if (elytraMeta != null) {
            for (Enchantment enchantment : Enchantment.values()) {
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "elytra_enchant_" + enchantment.getKey().getKey());
                if (!container.has(key, PersistentDataType.INTEGER)) continue;
                int level = (Integer)container.get(key, PersistentDataType.INTEGER);
                elytraMeta.addEnchant(enchantment, level, true);
            }
            elytraMeta.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "preview_item"), PersistentDataType.BYTE, (Object)1);
            this.removeCustomNbt(elytraMeta.getPersistentDataContainer());
            plainElytra.setItemMeta(elytraMeta);
        }
        return plainElytra;
    }

    public void addPreviewTag(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().set(this.previewItemKey, PersistentDataType.BYTE, (Object)1);
            item.setItemMeta(meta);
        }
    }

    public boolean isPreviewItem(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(this.previewItemKey, PersistentDataType.BYTE);
    }

    public ItemStack createCleanCopy(ItemStack item) {
        if (item == null) {
            return null;
        }
        ItemStack copy = item.clone();
        ItemMeta meta = copy.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().remove(this.previewItemKey);
            copy.setItemMeta(meta);
        }
        return copy;
    }

    public boolean isChestplate(ItemStack item) {
        if (item == null) {
            return false;
        }
        return item.getType().name().endsWith("_CHESTPLATE");
    }

    public boolean isArmoredElytra(ItemStack item) {
        if (item == null || item.getType() != Material.ELYTRA) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        return meta.getPersistentDataContainer().has(this.armoredElytraKey, PersistentDataType.BYTE);
    }

    public boolean isPlainElytra(ItemStack item) {
        return item != null && item.getType() == Material.ELYTRA && !this.isArmoredElytra(item);
    }

    public AttributeInstance getArmorAttribute(Player player) {
        Attribute attribute = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.armor"));
        if (attribute == null) {
            Attribute armorAttribute = Attribute.valueOf((String)"ARMOR");
            AttributeInstance attributeInstance = player.getAttribute(armorAttribute);
            if (attributeInstance == null) {
                this.logger.warning("Player does not have 'armor' attribute instance. Report this to the plugin author!");
                return null;
            }
            return attributeInstance;
        }
        return player.getAttribute(attribute);
    }

    public AttributeInstance getToughnessAttribute(Player player) {
        Attribute attribute = (Attribute)Registry.ATTRIBUTE.get(NamespacedKey.minecraft((String)"generic.armor_toughness"));
        if (attribute == null) {
            Attribute armorToughnessAttribute = Attribute.valueOf((String)"ARMOR_TOUGHNESS");
            AttributeInstance attributeInstance = player.getAttribute(armorToughnessAttribute);
            if (attributeInstance == null) {
                this.logger.warning("Player does not have 'armor_toughness' attribute instance. Report this to the plugin author!");
                return null;
            }
            return attributeInstance;
        }
        return player.getAttribute(attribute);
    }

    public void setArmorModifier(Player player, NamespacedKey key, double armorPoints) {
        AttributeInstance armorAttr = this.getArmorAttribute(player);
        if (armorAttr == null) {
            return;
        }
        AttributeModifier modifier = this.createModifier(key, armorPoints, "armor_modifier", AttributeModifier.Operation.ADD_NUMBER);
        if (modifier == null) {
            return;
        }
        boolean alreadyExists = false;
        try {
            Method getKeyMethod = AttributeModifier.class.getMethod("getKey", new Class[0]);
            Object result = getKeyMethod.invoke((Object)modifier, new Object[0]);
            if (result instanceof NamespacedKey) {
                NamespacedKey modKey = (NamespacedKey)result;
                alreadyExists = armorAttr.getModifiers().stream().anyMatch(existing -> {
                    try {
                        Method existingGetKey = AttributeModifier.class.getMethod("getKey", new Class[0]);
                        Object existingKeyObj = existingGetKey.invoke(existing, new Object[0]);
                        return existingKeyObj instanceof NamespacedKey && existingKeyObj.equals(modKey);
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ignored) {
            UUID legacyKey = this.toUUID(key);
            alreadyExists = armorAttr.getModifiers().stream().anyMatch(existing -> existing.getUniqueId().equals(legacyKey));
        }
        if (!alreadyExists) {
            armorAttr.addModifier(modifier);
        }
    }

    public void setToughnessModifier(Player player, NamespacedKey key, double toughnessPoints) {
        AttributeInstance toughnessAttr = this.getToughnessAttribute(player);
        if (toughnessAttr == null) {
            return;
        }
        AttributeModifier modifier = this.createModifier(key, toughnessPoints, "toughness_modifier", AttributeModifier.Operation.ADD_NUMBER);
        if (modifier == null) {
            return;
        }
        boolean alreadyExists = false;
        try {
            Method getKeyMethod = AttributeModifier.class.getMethod("getKey", new Class[0]);
            Object result = getKeyMethod.invoke((Object)modifier, new Object[0]);
            if (result instanceof NamespacedKey) {
                NamespacedKey modKey = (NamespacedKey)result;
                alreadyExists = toughnessAttr.getModifiers().stream().anyMatch(existing -> {
                    try {
                        Method existingGetKey = AttributeModifier.class.getMethod("getKey", new Class[0]);
                        Object existingKey = existingGetKey.invoke(existing, new Object[0]);
                        return existingKey instanceof NamespacedKey && ((NamespacedKey)existingKey).equals((Object)modKey);
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
            }
        }
        catch (Exception e) {
            UUID legacyUUID = this.toUUID(key);
            alreadyExists = toughnessAttr.getModifiers().stream().anyMatch(mod -> mod.getUniqueId().equals(legacyUUID));
        }
        if (!alreadyExists) {
            toughnessAttr.addModifier(modifier);
        }
    }

    public void removeArmorModifier(Player player, NamespacedKey key) {
        AttributeInstance armorAttr = this.getArmorAttribute(player);
        if (armorAttr == null) {
            return;
        }
        for (AttributeModifier modifier : armorAttr.getModifiers()) {
            try {
                NamespacedKey modKey;
                Method getKeyMethod = AttributeModifier.class.getMethod("getKey", new Class[0]);
                Object result = getKeyMethod.invoke((Object)modifier, new Object[0]);
                if (!(result instanceof NamespacedKey) || !(modKey = (NamespacedKey)result).equals((Object)key)) continue;
                armorAttr.removeModifier(modifier);
                return;
            }
            catch (Exception e) {
                UUID legacyUUID = this.toUUID(key);
                if (!modifier.getUniqueId().equals(legacyUUID)) continue;
                armorAttr.removeModifier(modifier);
                return;
            }
        }
    }

    public void removeToughnessModifier(Player player, NamespacedKey key) {
        AttributeInstance toughnessAttr = this.getToughnessAttribute(player);
        if (toughnessAttr == null) {
            return;
        }
        for (AttributeModifier modifier : toughnessAttr.getModifiers()) {
            try {
                NamespacedKey modKey;
                Method getKeyMethod = AttributeModifier.class.getMethod("getKey", new Class[0]);
                Object result = getKeyMethod.invoke((Object)modifier, new Object[0]);
                if (!(result instanceof NamespacedKey) || !(modKey = (NamespacedKey)result).equals((Object)key)) continue;
                toughnessAttr.removeModifier(modifier);
                return;
            }
            catch (Exception e) {
                UUID legacyUUID = this.toUUID(key);
                if (!modifier.getUniqueId().equals(legacyUUID)) continue;
                toughnessAttr.removeModifier(modifier);
                return;
            }
        }
    }

    public String getDurabilityBarString(int current, int max) {
        double percentage;
        double d = percentage = max > 0 ? (double)current / (double)max : 0.0;
        String barColor = percentage == 1.0 ? "\u00a7a" : (percentage > 0.5 ? "\u00a7e" : (percentage > 0.2 ? "\u00a7c" : "\u00a74"));
        int totalSegments = 28;
        int filledSegments = (int)((double)totalSegments * percentage);
        StringBuilder bar = new StringBuilder();
        bar.append(barColor);
        for (int i = 0; i < totalSegments; ++i) {
            if (i < filledSegments) {
                bar.append("\u2586");
                continue;
            }
            bar.append("\u00a7f\u2586");
        }
        double displayPercentage = percentage * 100.0;
        bar.append(String.format(" %s\u00a7l%.2f%%", barColor, displayPercentage));
        return bar.toString();
    }

    private AttributeModifier createModifier(NamespacedKey key, double amount, String name, AttributeModifier.Operation op) {
        UUID uuid = this.toUUID(key);
        try {
            Class<?> slotGroupClass = Class.forName("org.bukkit.inventory.EquipmentSlotGroup");
            Object chestSlotGroup = slotGroupClass.getField("CHEST").get(null);
            return (AttributeModifier)AttributeModifier.class.getConstructor(NamespacedKey.class, Double.TYPE, AttributeModifier.Operation.class, slotGroupClass).newInstance(key, amount, op, chestSlotGroup);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            try {
                return (AttributeModifier)AttributeModifier.class.getConstructor(UUID.class, String.class, Double.TYPE, AttributeModifier.Operation.class).newInstance(uuid, name, amount, op);
            }
            catch (Exception ex) {
                this.logger.severe("Failed to create AttributeModifier: " + ex.getMessage() + "Report this to the plugin author!");
                return null;
            }
        }
        catch (Exception e) {
            this.logger.severe("Failed to create AttributeModifier: " + e.getMessage() + "Report this to the plugin author!");
            return null;
        }
    }

    private UUID toUUID(NamespacedKey key) {
        String combined = key.getNamespace() + ":" + key.getKey();
        return UUID.nameUUIDFromBytes(combined.getBytes(StandardCharsets.UTF_8));
    }

    private int getArmorPoints(Material armorType) {
        return switch (armorType) {
            case Material.LEATHER_CHESTPLATE -> 3;
            case Material.CHAINMAIL_CHESTPLATE, Material.GOLDEN_CHESTPLATE -> 5;
            case Material.IRON_CHESTPLATE -> 6;
            case Material.DIAMOND_CHESTPLATE, Material.NETHERITE_CHESTPLATE -> 8;
            default -> 0;
        };
    }

    private int getArmorToughness(Material armorType) {
        return switch (armorType) {
            case Material.DIAMOND_CHESTPLATE -> 2;
            case Material.NETHERITE_CHESTPLATE -> 3;
            default -> 0;
        };
    }

    private String getCapitalizedName(String name) {
        String[] words = name.toLowerCase().replace("_", " ").split(" ");
        StringBuilder capitalized = new StringBuilder();
        for (String word : words) {
            capitalized.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return capitalized.toString().trim();
    }

    private String getStandardEnchantmentKey(Enchantment enchant) {
        String key = enchant.getKey().getKey();
        if (ServerVersion.getCurrent().equals((Object)ServerVersion.V_1_18) || ServerVersion.getCurrent().equals((Object)ServerVersion.V_1_19) || ServerVersion.getCurrent().equals((Object)ServerVersion.V_1_20)) {
            return switch (key) {
                case "protection" -> "protection_environmental";
                case "fire_protection" -> "protection_fire";
                case "blast_protection" -> "protection_explosions";
                case "projectile_protection" -> "protection_projectile";
                default -> key;
            };
        }
        return key;
    }

    private void removeCustomNbt(PersistentDataContainer container) {
        for (UpgradeType type : UpgradeType.values()) {
            container.remove(new NamespacedKey((Plugin)this.plugin, type.getKey()));
        }
        container.remove(this.armoredElytraKey);
        container.remove(this.materialKey);
        container.remove(this.durabilityKey);
        container.remove(this.maxDurabilityKey);
        container.remove(new NamespacedKey((Plugin)this.plugin, "forged-by"));
        container.remove(new NamespacedKey((Plugin)this.plugin, "damage-absorbed"));
        container.remove(new NamespacedKey((Plugin)this.plugin, "plating-shattered"));
    }
}

