/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.helpers;

import java.io.File;
import java.util.logging.Logger;
import org.bruno.elytraEssentials.ElytraEssentials;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public final class FileHelper {
    private final ElytraEssentials plugin;
    private final Logger logger;
    private FileConfiguration messagesConfig;
    private FileConfiguration shopConfig;
    private FileConfiguration achievementsConfig;
    private FileConfiguration upgradesConfig;

    public FileHelper(ElytraEssentials plugin, Logger logger) {
        this.plugin = plugin;
        this.logger = logger;
        this.initialize();
    }

    public void initialize() {
        this.logger.info("Loading custom configuration files...");
        this.messagesConfig = this.setupCustomFile("messages.yml");
        this.shopConfig = this.setupCustomFile("shop.yml");
        this.achievementsConfig = this.setupCustomFile("achievements.yml");
        this.upgradesConfig = this.setupCustomFile("upgrades.yml");
        this.logger.info("All custom configuration files loaded successfully.");
    }

    public void reloadAll() {
        this.logger.info("Reloading custom configuration files...");
        this.messagesConfig = this.setupCustomFile("messages.yml");
        this.shopConfig = this.setupCustomFile("shop.yml");
        this.achievementsConfig = this.setupCustomFile("achievements.yml");
        this.upgradesConfig = this.setupCustomFile("upgrades.yml");
        this.logger.info("All custom files have been reloaded.");
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public FileConfiguration getShopConfig() {
        return this.shopConfig;
    }

    public FileConfiguration getAchievementsConfig() {
        return this.achievementsConfig;
    }

    public FileConfiguration getUpgradesConfig() {
        return this.upgradesConfig;
    }

    private FileConfiguration setupCustomFile(String fileName) {
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            this.logger.info("File not found: " + fileName + ". Creating from defaults.");
            this.plugin.saveResource(fileName, false);
        }
        return YamlConfiguration.loadConfiguration((File)file);
    }
}

