/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.helpers;

import org.bruno.elytraEssentials.ElytraEssentials;
import org.bruno.elytraEssentials.utils.CancellableTask;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public final class FoliaHelper {
    private final ElytraEssentials plugin;
    private final boolean isFolia;

    public FoliaHelper(ElytraEssentials plugin) {
        this.plugin = plugin;
        boolean folia = false;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            folia = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.isFolia = folia;
    }

    public boolean isFolia() {
        return this.isFolia;
    }

    public CancellableTask runTask(Entity entity, Runnable task) {
        if (this.isFolia) {
            return new CancellableTask(entity.getScheduler().run((Plugin)this.plugin, scheduledTask -> task.run(), null));
        }
        return new CancellableTask(this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, task));
    }

    public CancellableTask runTaskTimerForEntity(Entity entity, Runnable task, long delay, long period) {
        if (this.isFolia) {
            long foliaDelay = Math.max(1L, delay);
            return new CancellableTask(entity.getScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> task.run(), null, foliaDelay, period));
        }
        return new CancellableTask(this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, task, delay, period));
    }

    public CancellableTask runTaskLater(Entity entity, Runnable task, long delay) {
        if (this.isFolia) {
            long foliaDelay = Math.max(1L, delay);
            return new CancellableTask(entity.getScheduler().runDelayed((Plugin)this.plugin, scheduledTask -> task.run(), null, foliaDelay));
        }
        return new CancellableTask(this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, task, delay));
    }

    public CancellableTask runTaskTimerGlobal(Runnable task, long delay, long period) {
        if (this.isFolia) {
            long foliaDelay = Math.max(1L, delay);
            return new CancellableTask(this.plugin.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)this.plugin, scheduledTask -> task.run(), foliaDelay, period));
        }
        return new CancellableTask(this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, task, delay, period));
    }

    public CancellableTask runAsyncTask(Runnable task) {
        if (this.isFolia) {
            return new CancellableTask(Bukkit.getAsyncScheduler().runNow((Plugin)this.plugin, scheduledTask -> task.run()));
        }
        return new CancellableTask(this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, task));
    }

    public void runTaskOnMainThread(Runnable task) {
        if (this.isFolia) {
            this.plugin.getServer().getGlobalRegionScheduler().run((Plugin)this.plugin, scheduledTask -> task.run());
        } else {
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, task);
        }
    }
}

