/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.helpers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bruno.elytraEssentials.utils.StatType;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public final class GuiHelper {
    private static final Pattern URL_PATTERN = Pattern.compile("\"url\"\\s*:\\s*\"([^\"]+)\"");

    private GuiHelper() {
    }

    public static ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createPlayerHead(Player player, String name, String ... lore) {
        ItemStack playerHead = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta skullMeta = (SkullMeta)playerHead.getItemMeta();
        if (skullMeta != null) {
            skullMeta.setOwningPlayer((OfflinePlayer)player);
            skullMeta.setDisplayName(name);
            skullMeta.setLore(Arrays.asList(lore));
            playerHead.setItemMeta((ItemMeta)skullMeta);
        }
        return playerHead;
    }

    public static ItemStack createPreviousPageButton(boolean isActive) {
        if (isActive) {
            try {
                return GuiHelper.createCustomHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmQ2OWUwNmU1ZGFkZmQ4NGU1ZjNkMWMyMTA2M2YyNTUzYjJmYTk0NWVlMWQ0ZDcxNTJmZGM1NDI1YmMxMmE5In19fQ==", "\u00a7aPrevious Page", "\u00a77Click to go to the previous page.");
            }
            catch (Throwable e) {
                return GuiHelper.createGuiItem(Material.RED_STAINED_GLASS_PANE, "\u00a7aPrevious Page", "\u00a77Click to go to the previous page.");
            }
        }
        try {
            return GuiHelper.createCustomHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWRiNTMyYjVjY2VkNDZiNGI1MzVlY2UxNmVjZWQ3YmJjNWNhYzU1NTk0ZDYxZThiOGY4ZWFjNDI5OWM5ZmMifX19", "\u00a7aPrevious Page", "\u00a77Click to go to the previous page.");
        }
        catch (Throwable e) {
            return GuiHelper.createGuiItem(Material.RED_STAINED_GLASS_PANE, "\u00a7aPrevious Page", "\u00a77Click to go to the previous page.");
        }
    }

    public static ItemStack createNextPageButton(boolean isActive) {
        if (isActive) {
            try {
                return GuiHelper.createCustomHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTliZjMyOTJlMTI2YTEwNWI1NGViYTcxM2FhMWIxNTJkNTQxYTFkODkzODgyOWM1NjM2NGQxNzhlZDIyYmYifX19", "\u00a7aNext Page", "\u00a77Click to go to the next page.");
            }
            catch (Throwable e) {
                return GuiHelper.createGuiItem(Material.GREEN_STAINED_GLASS_PANE, "\u00a7aNext Page", "\u00a77Click to go to the next page.");
            }
        }
        try {
            return GuiHelper.createCustomHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWRiNTMyYjVjY2VkNDZiNGI1MzVlY2UxNmVjZWQ3YmJjNWNhYzU1NTk0ZDYxZThiOGY4ZWFjNDI5OWM5ZmMifX19", "\u00a7cNext Page", "\u00a77You are on the last page.");
        }
        catch (Throwable e) {
            return GuiHelper.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, "\u00a7cNext Page", "\u00a77You are on the last page.");
        }
    }

    public static ItemStack createAcceptButton(String action, List<String> lore) {
        try {
            return GuiHelper.createCustomHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDMxMmNhNDYzMmRlZjVmZmFmMmViMGQ5ZDdjYzdiNTVhNTBjNGUzOTIwZDkwMzcyYWFiMTQwNzgxZjVkZmJjNCJ9fX0=", "\u00a7aConfirm " + action, lore.toArray(new String[0]));
        }
        catch (Throwable e) {
            return GuiHelper.createGuiItem(Material.GREEN_STAINED_GLASS_PANE, "\u00a7aConfirm " + action, lore.toArray(new String[0]));
        }
    }

    public static ItemStack createCancelButton() {
        try {
            return GuiHelper.createCustomHead("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmViNTg4YjIxYTZmOThhZDFmZjRlMDg1YzU1MmRjYjA1MGVmYzljYWI0MjdmNDYwNDhmMThmYzgwMzQ3NWY3In19fQ==", "\u00a7cCancel", "\u00a77Click here to cancel the operation.");
        }
        catch (Throwable e) {
            return GuiHelper.createGuiItem(Material.RED_STAINED_GLASS_PANE, "\u00a7cCancel", "\u00a77Click here to cancel the operation.");
        }
    }

    public static ItemStack createPageInfoItem(int currentPage, int totalPages) {
        return GuiHelper.createGuiItem(Material.COMPASS, String.format("\u00a7ePage %d / %d", currentPage, totalPages), new String[0]);
    }

    public static ItemStack createCloseButton() {
        return GuiHelper.createGuiItem(Material.BARRIER, "\u00a7cClose", "\u00a77Click to close the menu.");
    }

    public static ItemStack createFilterButton(StatType currentFilter, List<StatType> filterCycle) {
        String filterName = currentFilter == StatType.UNKNOWN ? "All" : GuiHelper.getCapitalizedName(currentFilter.name());
        ArrayList<Object> lore = new ArrayList<Object>();
        lore.add("\u00a77Click to cycle through categories.");
        lore.add("");
        for (StatType type : filterCycle) {
            String name;
            String string = name = type == StatType.UNKNOWN ? "All" : GuiHelper.getCapitalizedName(type.name());
            if (type == currentFilter) {
                lore.add("\u00a7a\u00bb " + name + " \u00a7a\u00ab");
                continue;
            }
            lore.add("\u00a77" + name);
        }
        return GuiHelper.createGuiItem(Material.HOPPER, "\u00a7eFilter: \u00a7b" + filterName, lore.toArray(new String[0]));
    }

    public static Inventory getTopInventory(InventoryEvent event) {
        try {
            InventoryView view = event.getView();
            Method getTopInventory = view.getClass().getMethod("getTopInventory", new Class[0]);
            getTopInventory.setAccessible(true);
            return (Inventory)getTopInventory.invoke((Object)view, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getCapitalizedName(String name) {
        String[] words = name.toLowerCase().replace("_", " ").split(" ");
        StringBuilder capitalized = new StringBuilder();
        for (String word : words) {
            capitalized.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return capitalized.toString().trim();
    }

    private static ItemStack createCustomHead(String base64, String name, String ... lore) {
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (meta == null) {
            return head;
        }
        try {
            PlayerProfile profile = Bukkit.createPlayerProfile((UUID)UUID.randomUUID());
            PlayerTextures textures = profile.getTextures();
            byte[] decoded = Base64.getDecoder().decode(base64);
            String decodedString = new String(decoded, StandardCharsets.UTF_8);
            Matcher matcher = URL_PATTERN.matcher(decodedString);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Could not find URL in decoded texture data.");
            }
            String urlString = matcher.group(1);
            textures.setSkin(new URL(urlString));
            profile.setTextures(textures);
            meta.setOwnerProfile(profile);
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            head.setItemMeta((ItemMeta)meta);
        }
        catch (Exception e) {
            return GuiHelper.createGuiItem(Material.BARRIER, name, lore);
        }
        catch (Throwable e) {
            throw e;
        }
        return head;
    }
}

