/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.helpers;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bruno.elytraEssentials.helpers.ColorHelper;
import org.bruno.elytraEssentials.utils.ServerVersion;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MessagesHelper {
    private final ServerVersion serverVersion;
    private String pluginPrefix;
    private boolean debugEnabled = false;

    public MessagesHelper(ServerVersion serverVersion) {
        this.serverVersion = serverVersion;
    }

    public void sendUpdateNotification(Player player, String latestVersion) {
        String downloadUrl = "https://www.spigotmc.org/resources/126002/";
        String text = this.pluginPrefix + "\u00a77A new version is available (\u00a7av" + latestVersion + "\u00a77)! ";
        TextComponent message = new TextComponent(TextComponent.fromLegacyText((String)ColorHelper.parse(text)));
        TextComponent linkComponent = new TextComponent("\u00a7e\u00a7l[Click Here to Download]");
        linkComponent.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, downloadUrl));
        TextComponent[] hoverText = new TextComponent[]{new TextComponent(TextComponent.fromLegacyText((String)"\u00a7bClick to open the plugin page\n\u00a7bin your web browser."))};
        linkComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text((BaseComponent[])hoverText)}));
        message.addExtra((BaseComponent)linkComponent);
        player.spigot().sendMessage((BaseComponent)message);
    }

    public void sendActionBarMessage(Player player, String message) {
        String coloredMessage = ColorHelper.parse(message);
        if (this.serverVersion == ServerVersion.V_1_21) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacy((String)coloredMessage));
        } else {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)coloredMessage));
        }
    }

    public void sendTitleMessage(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        String coloredTitle = title != null ? ColorHelper.parse(title) : "";
        String coloredSubtitle = subtitle != null ? ColorHelper.parse(subtitle) : "";
        player.sendTitle(coloredTitle, coloredSubtitle, fadeIn, stay, fadeOut);
    }

    public void sendConsoleMessage(String message) {
        String formattedMessage = ColorHelper.parse(this.pluginPrefix + "&r" + message);
        Bukkit.getConsoleSender().sendMessage(formattedMessage);
    }

    public void sendPlayerMessage(Player player, String message) {
        String formattedMessage = ColorHelper.parse(this.pluginPrefix + "&r" + message);
        player.sendMessage(formattedMessage);
    }

    public void sendCommandSenderMessage(CommandSender sender, String message) {
        String formattedMessage = ColorHelper.parse(this.pluginPrefix + "&r" + message);
        sender.sendMessage(formattedMessage);
    }

    public void sendDebugMessage(String message) {
        if (this.debugEnabled) {
            String formattedMessage = ColorHelper.parse(this.pluginPrefix + "&r[&6Debug&r] - " + message);
            Bukkit.getConsoleSender().sendMessage(formattedMessage);
        }
    }

    public void setDebugMode(boolean enabled) {
        this.debugEnabled = enabled;
    }

    public void setPrefix(String prefix) {
        this.pluginPrefix = ColorHelper.parse(prefix);
    }
}

