/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.listeners;

import java.util.Random;
import org.bruno.elytraEssentials.handlers.ArmoredElytraHandler;
import org.bruno.elytraEssentials.handlers.FlightHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.handlers.UpgradeHandler;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;

public class DamageListener
implements Listener {
    private final FlightHandler flightHandler;
    private final StatsHandler statsHandler;
    private final ArmoredElytraHandler armoredElytraHandler;
    private final UpgradeHandler upgradeHandler;
    private final Random random = new Random();

    public DamageListener(FlightHandler flightHandler, StatsHandler statsHandler, ArmoredElytraHandler armoredElytraHandler, UpgradeHandler upgradeHandler) {
        this.flightHandler = flightHandler;
        this.statsHandler = statsHandler;
        this.armoredElytraHandler = armoredElytraHandler;
        this.upgradeHandler = upgradeHandler;
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getCause() == EntityDamageEvent.DamageCause.FLY_INTO_WALL) {
            if (this.flightHandler.isKineticProtectionEnabled()) {
                event.setCancelled(true);
                this.statsHandler.getStats(player).incrementPluginSaves();
                return;
            }
            ItemStack chestplate = player.getInventory().getChestplate();
            double resistanceChance = this.upgradeHandler.getKineticResistanceChance(chestplate);
            if (resistanceChance > 0.0 && this.random.nextDouble() * 100.0 < resistanceChance) {
                event.setCancelled(true);
                this.statsHandler.getStats(player).incrementPluginSaves();
                return;
            }
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && this.flightHandler.isProtectedFromFallDamage(player.getUniqueId())) {
            this.flightHandler.removeFallProtection(player.getUniqueId());
            event.setCancelled(true);
            this.statsHandler.getStats(player).incrementPluginSaves();
            return;
        }
        this.armoredElytraHandler.handleDamage(event);
    }
}

