/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.listeners;

import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.PluginInfoHandler;
import org.bruno.elytraEssentials.helpers.MessagesHelper;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class ElytraUpdaterListener
implements Listener {
    private final MessagesHelper messagesHelper;
    private final ConfigHandler configHandler;
    private final PluginInfoHandler pluginInfoHandler;

    public ElytraUpdaterListener(MessagesHelper messagesHelper, ConfigHandler configHandler, PluginInfoHandler pluginInfoHandler) {
        this.messagesHelper = messagesHelper;
        this.configHandler = configHandler;
        this.pluginInfoHandler = pluginInfoHandler;
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        boolean isCheckForUpdatesEnabled = this.configHandler.getIsCheckForUpdatesEnabled();
        if (!isCheckForUpdatesEnabled) {
            return;
        }
        Player player = event.getPlayer();
        if (PermissionsHelper.hasUpdateNotifyPermission(player) && this.pluginInfoHandler.isUpdateAvailable()) {
            this.messagesHelper.sendUpdateNotification(player, this.pluginInfoHandler.getLatestVersion());
        }
    }
}

