/*
 * Decompiled with CFR 0.152.
 */
package org.bruno.elytraEssentials.placeholders;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bruno.elytraEssentials.handlers.ConfigHandler;
import org.bruno.elytraEssentials.handlers.FlightHandler;
import org.bruno.elytraEssentials.handlers.PluginInfoHandler;
import org.bruno.elytraEssentials.handlers.StatsHandler;
import org.bruno.elytraEssentials.helpers.PermissionsHelper;
import org.bruno.elytraEssentials.helpers.TimeHelper;
import org.bruno.elytraEssentials.utils.PlayerStats;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ElytraEssentialsPlaceholders
extends PlaceholderExpansion {
    private final FlightHandler flightHandler;
    private final StatsHandler statsHandler;
    private final ConfigHandler configHandler;
    private final PluginInfoHandler pluginInfoHandler;

    public ElytraEssentialsPlaceholders(FlightHandler flightHandler, StatsHandler statsHandler, ConfigHandler configHandler, PluginInfoHandler pluginInfoHandler) {
        this.flightHandler = flightHandler;
        this.statsHandler = statsHandler;
        this.configHandler = configHandler;
        this.pluginInfoHandler = pluginInfoHandler;
    }

    @NotNull
    public String getIdentifier() {
        return "elytraessentials";
    }

    @NotNull
    public String getAuthor() {
        return "CodingMaestro";
    }

    @NotNull
    public String getVersion() {
        return this.pluginInfoHandler.getCurrentVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        if (identifier.equalsIgnoreCase("flight_time") || identifier.equalsIgnoreCase("flight_time_formatted")) {
            if (!this.configHandler.getIsTimeLimitEnabled()) {
                return "Disabled";
            }
            if (PermissionsHelper.playerBypassTimeLimit(player)) {
                return "Unlimited";
            }
            int flightTimeLeft = this.flightHandler.getCurrentFlightTime(player.getUniqueId());
            return identifier.equalsIgnoreCase("flight_time_formatted") ? TimeHelper.formatFlightTime(flightTimeLeft) : String.valueOf(flightTimeLeft);
        }
        PlayerStats stats = this.statsHandler.getStats(player);
        if (stats == null) {
            return "";
        }
        switch (identifier.toLowerCase()) {
            case "total_distance_km": {
                return String.format("%.1f km", stats.getTotalDistance() / 1000.0);
            }
            case "total_distance_blocks": {
                return String.format("%.0f blocks", stats.getTotalDistance());
            }
            case "total_flight_time": {
                return TimeHelper.formatFlightTime((int)stats.getTotalTimeSeconds());
            }
            case "longest_flight": {
                return String.format("%.0f blocks", stats.getLongestFlight());
            }
            case "average_speed": {
                if (stats.getTotalTimeSeconds() > 0L) {
                    double avgSpeedKmh = stats.getTotalDistance() / (double)stats.getTotalTimeSeconds() * 3.6;
                    return String.format("%.1f km/h", avgSpeedKmh);
                }
                return "0.0 km/h";
            }
        }
        return null;
    }
}

