/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.advancement.CobblemonCriteria;
import com.cobblemon.mod.common.advancement.criterion.CountableContext;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.events.pokemon.HatchEggEvent;
import com.cobblemon.mod.common.api.net.PacketHandler;
import com.cobblemon.mod.common.api.reactive.Observable;
import com.cobblemon.mod.common.api.storage.player.GeneralPlayerData;
import com.cobblemon.mod.common.api.storage.player.InstancedPlayerData;
import com.cobblemon.mod.common.api.storage.player.PlayerAdvancementData;
import com.cobblemon.mod.common.api.storage.player.PlayerInstancedDataStoreTypes;
import com.cobblemon.mod.common.net.PacketRegisterInfo;
import com.mojang.logging.LogUtils;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import ludichat.cobbreeding.Config;
import ludichat.cobbreeding.PokemonEgg;
import ludichat.cobbreeding.components.CobbreedingComponents;
import ludichat.cobbreeding.network.ToggleBreedingPacket;
import ludichat.cobbreeding.network.ToggleBreedingPacketPacketHandler;
import ludichat.cobbreeding.network.ToggleNeuterPacket;
import ludichat.cobbreeding.network.ToggleNeuterPacketHandler;
import ludichat.cobbreeding.network.ToggledNeuterPacket;
import ludichat.cobbreeding.network.ToggledNeuterPacketHandler;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\r\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\u0003J\r\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\u0003J\u0015\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000fR\u0014\u0010\u0011\u001a\u00020\r8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000fR \u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR<\u0010 \u001a*\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001cj\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d`\u001f8\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\"\u0010#\u001a\u00020\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001d\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R\u001d\u00100\u001a\b\u0012\u0004\u0012\u00020/0)8\u0006\u00a2\u0006\f\n\u0004\b0\u0010,\u001a\u0004\b1\u0010.R\u001d\u00103\u001a\b\u0012\u0004\u0012\u0002020)8\u0006\u00a2\u0006\f\n\u0004\b3\u0010,\u001a\u0004\b4\u0010.R\"\u00106\u001a\u0002058\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010;\u00a8\u0006<"}, d2={"Lludichat/cobbreeding/Cobbreeding;", "", "<init>", "()V", "", "init", "registerEggs", "loadConfig", "saveConfig", "Lcom/cobblemon/mod/common/api/events/pokemon/HatchEggEvent;", "event", "onHatch", "(Lcom/cobblemon/mod/common/api/events/pokemon/HatchEggEvent;)V", "", "MOD_ID", "Ljava/lang/String;", "VERSION", "CONFIG_PATH", "ENCRYPTION_KEY_PATH", "Ldev/architectury/registry/registries/DeferredRegister;", "Lnet/minecraft/world/item/Item;", "ITEMS", "Ldev/architectury/registry/registries/DeferredRegister;", "getITEMS$common", "()Ldev/architectury/registry/registries/DeferredRegister;", "Lorg/slf4j/Logger;", "LOGGER", "Lorg/slf4j/Logger;", "Ljava/util/HashMap;", "Ldev/architectury/registry/registries/RegistrySupplier;", "Lludichat/cobbreeding/PokemonEgg;", "Lkotlin/collections/HashMap;", "EGG_ITEMS", "Ljava/util/HashMap;", "", "SHINY_ERROR_FLAG", "Z", "getSHINY_ERROR_FLAG", "()Z", "setSHINY_ERROR_FLAG", "(Z)V", "Lcom/cobblemon/mod/common/net/PacketRegisterInfo;", "Lludichat/cobbreeding/network/ToggleBreedingPacket;", "BREEDING_PACKET_INFO", "Lcom/cobblemon/mod/common/net/PacketRegisterInfo;", "getBREEDING_PACKET_INFO", "()Lcom/cobblemon/mod/common/net/PacketRegisterInfo;", "Lludichat/cobbreeding/network/ToggleNeuterPacket;", "NEUTER_PACKET_INFO", "getNEUTER_PACKET_INFO", "Lludichat/cobbreeding/network/ToggledNeuterPacket;", "NEUTERED_PACKET_INFO", "getNEUTERED_PACKET_INFO", "Lludichat/cobbreeding/Config;", "config", "Lludichat/cobbreeding/Config;", "getConfig", "()Lludichat/cobbreeding/Config;", "setConfig", "(Lludichat/cobbreeding/Config;)V", "common"})
public final class Cobbreeding {
    @NotNull
    public static final Cobbreeding INSTANCE = new Cobbreeding();
    @NotNull
    public static final String MOD_ID = "cobbreeding";
    @NotNull
    public static final String VERSION = "2.0.0";
    @NotNull
    private static final String CONFIG_PATH = "config/cobbreeding/main.json";
    @NotNull
    public static final String ENCRYPTION_KEY_PATH = "config/cobbreeding/encryption";
    @NotNull
    private static final DeferredRegister<Item> ITEMS;
    @JvmField
    @NotNull
    public static final Logger LOGGER;
    @JvmField
    @NotNull
    public static final HashMap<String, RegistrySupplier<PokemonEgg>> EGG_ITEMS;
    private static boolean SHINY_ERROR_FLAG;
    @NotNull
    private static final PacketRegisterInfo<ToggleBreedingPacket> BREEDING_PACKET_INFO;
    @NotNull
    private static final PacketRegisterInfo<ToggleNeuterPacket> NEUTER_PACKET_INFO;
    @NotNull
    private static final PacketRegisterInfo<ToggledNeuterPacket> NEUTERED_PACKET_INFO;
    public static Config config;

    private Cobbreeding() {
    }

    @NotNull
    public final DeferredRegister<Item> getITEMS$common() {
        return ITEMS;
    }

    public final boolean getSHINY_ERROR_FLAG() {
        return SHINY_ERROR_FLAG;
    }

    public final void setSHINY_ERROR_FLAG(boolean bl) {
        SHINY_ERROR_FLAG = bl;
    }

    @NotNull
    public final PacketRegisterInfo<ToggleBreedingPacket> getBREEDING_PACKET_INFO() {
        return BREEDING_PACKET_INFO;
    }

    @NotNull
    public final PacketRegisterInfo<ToggleNeuterPacket> getNEUTER_PACKET_INFO() {
        return NEUTER_PACKET_INFO;
    }

    @NotNull
    public final PacketRegisterInfo<ToggledNeuterPacket> getNEUTERED_PACKET_INFO() {
        return NEUTERED_PACKET_INFO;
    }

    @NotNull
    public final Config getConfig() {
        Config config = Cobbreeding.config;
        if (config != null) {
            return config;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"config");
        return null;
    }

    public final void setConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        Cobbreeding.config = config;
    }

    public final void init() {
        LOGGER.info("Registering items");
        this.registerEggs();
        ITEMS.register();
        LOGGER.info("Registering data components");
        CobbreedingComponents.INSTANCE.getCOMPONENT_TYPES$common().register();
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)((PreparableReloadListener)((ResourceManagerReloadListener)Cobbreeding::init$lambda$0)), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"cobbreeding-data"));
        Observable.DefaultImpls.subscribe$default((Observable)((Observable)CobblemonEvents.HATCH_EGG_POST), null, Cobbreeding::init$lambda$1, (int)1, null);
    }

    private final void registerEggs() {
        String[] stringArray = new String[]{"bug", "dark", "dragon", "electric", "fairy", "fighting", "fire", "flying", "ghost", "grass", "ground", "ice", "normal", "poison", "psychic", "rock", "steel", "water"};
        List types = CollectionsKt.listOf((Object[])stringArray);
        ((Map)EGG_ITEMS).put("pokemon_egg", ITEMS.register("pokemon_egg", Cobbreeding::registerEggs$lambda$2));
        ((Map)EGG_ITEMS).put("manaphy_egg", ITEMS.register("manaphy_egg", Cobbreeding::registerEggs$lambda$3));
        for (String type : types) {
            ((Map)EGG_ITEMS).put(type + "_pokemon_egg", ITEMS.register(type + "_pokemon_egg", Cobbreeding::registerEggs$lambda$4));
            for (String type2 : types) {
                if (Intrinsics.areEqual((Object)type, (Object)type2)) continue;
                ((Map)EGG_ITEMS).put(type + "_" + type2 + "_pokemon_egg", ITEMS.register(type + "_" + type2 + "_pokemon_egg", Cobbreeding::registerEggs$lambda$5));
            }
        }
    }

    public final void loadConfig() {
        File configFile = new File(CONFIG_PATH);
        configFile.getParentFile().mkdirs();
        if (configFile.exists()) {
            try {
                FileReader fileReader = new FileReader(configFile);
                this.setConfig((Config)Config.Companion.getGSON().fromJson((Reader)fileReader, Config.class));
                fileReader.close();
            }
            catch (Exception e) {
                LOGGER.error("Config error: " + e.getMessage());
                LOGGER.warn("Config has been reset.");
                this.setConfig(new Config(0, 0, 0, 0.0f, null, false, false, false, false, false, false, false, false, false, null, 0, 0, false, 262143, null));
            }
        } else {
            this.setConfig(new Config(0, 0, 0, 0.0f, null, false, false, false, false, false, false, false, false, false, null, 0, 0, false, 262143, null));
        }
        this.saveConfig();
    }

    public final void saveConfig() {
        try {
            File configFile = new File(CONFIG_PATH);
            FileWriter fileWriter = new FileWriter(configFile);
            Config.Companion.getGSON().toJson((Object)this.getConfig(), (Appendable)fileWriter);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save the config! Please consult the following stack trace:");
            exception.printStackTrace();
        }
    }

    public final void onHatch(@NotNull HatchEggEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GeneralPlayerData playerData = Cobblemon.INSTANCE.getPlayerDataManager().getGenericData(event.getPlayer());
        PlayerAdvancementData advancementData = playerData.getAdvancementData();
        advancementData.updateTotalEggsHatched();
        CobblemonCriteria.INSTANCE.getEGG_HATCH().trigger(event.getPlayer(), (Object)new CountableContext(advancementData.getTotalEggsHatched()));
        if (Intrinsics.areEqual((Object)event.getEgg().getShiny(), (Object)true)) {
            advancementData.updateTotalShinyCaptureCount();
            CobblemonCriteria.INSTANCE.getCATCH_SHINY_POKEMON().trigger(event.getPlayer(), (Object)new CountableContext(advancementData.getTotalShinyCaptureCount()));
        }
        CobblemonCriteria.INSTANCE.getCOLLECT_ASPECT().trigger(event.getPlayer(), (Object)advancementData.getAspectsCollected());
        Cobblemon.INSTANCE.getPlayerDataManager().saveSingle((InstancedPlayerData)playerData, PlayerInstancedDataStoreTypes.INSTANCE.getGENERAL());
    }

    private static final void init$lambda$0(ResourceManager it) {
        LOGGER.info("Loading configuration");
        INSTANCE.loadConfig();
    }

    private static final Unit init$lambda$1(HatchEggEvent.Post it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.onHatch((HatchEggEvent)it);
        return Unit.INSTANCE;
    }

    private static final PokemonEgg registerEggs$lambda$2() {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        return new PokemonEgg(properties);
    }

    private static final PokemonEgg registerEggs$lambda$3() {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        return new PokemonEgg(properties);
    }

    private static final PokemonEgg registerEggs$lambda$4() {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        return new PokemonEgg(properties);
    }

    private static final PokemonEgg registerEggs$lambda$5() {
        Item.Properties properties = new Item.Properties().stacksTo(1);
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"stacksTo(...)");
        return new PokemonEgg(properties);
    }

    static {
        DeferredRegister deferredRegister = DeferredRegister.create((String)MOD_ID, (ResourceKey)Registries.ITEM);
        Intrinsics.checkNotNullExpressionValue((Object)deferredRegister, (String)"create(...)");
        ITEMS = deferredRegister;
        Logger logger = LogUtils.getLogger();
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        HashMap hashMap = HashMap.newHashMap(326);
        Intrinsics.checkNotNullExpressionValue(hashMap, (String)"newHashMap(...)");
        EGG_ITEMS = hashMap;
        ResourceLocation resourceLocation = ToggleBreedingPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"<get-ID>(...)");
        BREEDING_PACKET_INFO = new PacketRegisterInfo(resourceLocation, (Function1)new Function1<RegistryFriendlyByteBuf, ToggleBreedingPacket>((Object)ToggleBreedingPacket.Companion){

            public final ToggleBreedingPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ToggleBreedingPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)ToggleBreedingPacketPacketHandler.INSTANCE, null, 8, null);
        ResourceLocation resourceLocation2 = ToggleNeuterPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"<get-ID>(...)");
        NEUTER_PACKET_INFO = new PacketRegisterInfo(resourceLocation2, (Function1)new Function1<RegistryFriendlyByteBuf, ToggleNeuterPacket>((Object)ToggleNeuterPacket.Companion){

            public final ToggleNeuterPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ToggleNeuterPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)ToggleNeuterPacketHandler.INSTANCE, null, 8, null);
        ResourceLocation resourceLocation3 = ToggledNeuterPacket.Companion.getID();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation3, (String)"<get-ID>(...)");
        NEUTERED_PACKET_INFO = new PacketRegisterInfo(resourceLocation3, (Function1)new Function1<RegistryFriendlyByteBuf, ToggledNeuterPacket>((Object)ToggledNeuterPacket.Companion){

            public final ToggledNeuterPacket invoke(RegistryFriendlyByteBuf p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((ToggledNeuterPacket.Companion)this.receiver).decode(p0);
            }
        }, (PacketHandler)ToggledNeuterPacketHandler.INSTANCE, null, 8, null);
    }
}

