/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.mixin;

import com.cobblemon.mod.common.block.PastureBlock;
import java.io.File;
import java.nio.file.Path;
import java.util.UUID;
import ludichat.cobbreeding.CustomProperties;
import ludichat.cobbreeding.PastureBreedingData;
import ludichat.cobbreeding.PastureInventory;
import ludichat.cobbreeding.utils.CobbreedingFile;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5218;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PastureBlock.class})
public abstract class PastureBlockMixin
extends class_2248 {
    @Unique
    private static final class_2746 HAS_EGG = CustomProperties.HAS_EGG;
    @Unique
    private static final class_2746 BREEDING_ACTIVATED = CustomProperties.BREEDING_ACTIVATED;

    public PastureBlockMixin(class_4970.class_2251 settings) {
        super(settings);
    }

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void init(class_4970.class_2251 properties, CallbackInfo ci) {
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)HAS_EGG, (Comparable)Boolean.valueOf(false)));
        this.method_9590((class_2680)this.method_9564().method_11657((class_2769)BREEDING_ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Inject(at={@At(value="TAIL")}, method={"createBlockStateDefinition"})
    private void appendProperties(class_2689.class_2690<class_2248, class_2680> builder, CallbackInfo ci) {
        builder.method_11667(new class_2769[]{HAS_EGG});
        builder.method_11667(new class_2769[]{BREEDING_ACTIVATED});
    }

    @Inject(at={@At(value="HEAD")}, method={"useWithoutItem"}, cancellable=true)
    private void onUse(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit, CallbackInfoReturnable<class_1269> cir) {
        if (!world.field_9236) {
            boolean is_bottom_part = state.method_11654((class_2769)PastureBlock.Companion.getPART()) == PastureBlock.PasturePart.BOTTOM;
            PastureInventory pastureInventory = (PastureInventory)world.method_8321(pos);
            if (pastureInventory != null && !pastureInventory.method_5442() && is_bottom_part) {
                player.method_31548().method_7398(pastureInventory.getItem());
                pastureInventory.removeItemNoUpdate();
                player.method_31548().method_7381();
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_EGG, (Comparable)Boolean.valueOf(!pastureInventory.method_5442())));
                cir.setReturnValue((Object)class_1269.field_5812);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"playerWillDestroy"})
    private void onBroken(class_1937 world, class_2338 pos, class_2680 state, class_1657 player, CallbackInfoReturnable<class_2680> cir) {
        if (!world.field_9236) {
            int hash = state.hashCode();
            PastureBreedingData.registry.remove(hash);
            Path path = world.method_8503().method_27050(class_5218.field_24188).resolve("pokemon").resolve("cobbreeding");
            File pastureFile = path.resolve("pastures").toFile();
            UUID ownerUuid = CobbreedingFile.getUuid(pastureFile, pos.toString());
            CobbreedingFile.removeCompoundTag(pastureFile, pos.toString());
            if (ownerUuid != null) {
                File playerFile = path.resolve(ownerUuid.toString().substring(0, 2)).resolve(ownerUuid.toString()).toFile();
                CobbreedingFile.removeCompoundTag(playerFile, pos.toString());
            }
        }
    }
}

