/*
 * Decompiled with CFR 0.152.
 */
package ludichat.cobbreeding.mixin;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.block.entity.PokemonPastureBlockEntity;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.pokemon.Species;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Pair;
import kotlin.UninitializedPropertyAccessException;
import ludichat.cobbreeding.BreedingUtilities;
import ludichat.cobbreeding.Cobbreeding;
import ludichat.cobbreeding.Config;
import ludichat.cobbreeding.CustomProperties;
import ludichat.cobbreeding.EggUtilities;
import ludichat.cobbreeding.PastureBreedingData;
import ludichat.cobbreeding.PastureInventory;
import ludichat.cobbreeding.components.CobbreedingComponents;
import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PokemonPastureBlockEntity.class})
public abstract class PokemonPastureBlockEntityMixin
extends class_2586
implements PastureInventory,
class_1278 {
    @Unique
    private static final Logger LOGGER = Cobbreeding.LOGGER;
    @Unique
    private static final class_2746 HAS_EGG = CustomProperties.HAS_EGG;
    private static final class_2746 BREEDING_ACTIVATED = CustomProperties.BREEDING_ACTIVATED;

    public PokemonPastureBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    @Override
    public class_2371<class_1799> getItems() {
        PastureBreedingData data;
        class_2338 pos = this.field_11867;
        if (PastureBreedingData.registry.containsKey(pos)) {
            data = PastureBreedingData.registry.get(pos);
        } else {
            data = new PastureBreedingData(-1L, (class_2371<class_1799>)class_2371.method_10213((int)PokemonPastureBlockEntityMixin.getConfig().getPastureInventorySize(), (Object)class_1799.field_8037), PokemonPastureBlockEntityMixin.getNewBreedingTime());
            PastureBreedingData.registry.put(pos, data);
        }
        return data.getEggs();
    }

    @Unique
    private static Config getConfig() {
        Config config;
        try {
            config = Cobbreeding.INSTANCE.getConfig();
        }
        catch (UninitializedPropertyAccessException e) {
            LOGGER.warn("Trying to read configurations but they haven't been initialized. Returning Default configs instead. This might happen because the client is running logic it shouldn't.");
            return new Config();
        }
        return config;
    }

    private static int getNewBreedingTime() {
        return new Random().nextInt(PokemonPastureBlockEntityMixin.getConfig().getMinBreedingTimeInTicks(), PokemonPastureBlockEntityMixin.getConfig().getMaxBreedingTimeInTicks() + 1);
    }

    @Inject(at={@At(value="HEAD")}, method={"TICKER$lambda$14"})
    private static void tick(class_1937 world, class_2338 pos, class_2680 state, PokemonPastureBlockEntity blockEntity, CallbackInfo ci) {
        long world_time = world.method_8510();
        if (!world.field_9236 && world_time % (long)Cobblemon.config.getPastureBlockUpdateTicks() == 0L) {
            PastureBreedingData data;
            List<Object> pokemon = new LinkedList();
            try {
                List tetheredPokemon = blockEntity.getTetheredPokemon();
                pokemon = BreedingUtilities.getPokemon(tetheredPokemon);
            }
            catch (NullPointerException tetheredPokemon) {
                // empty catch block
            }
            if (world_time % (long)PokemonPastureBlockEntityMixin.getConfig().getMirrorHerbTimeInTicks() == 0L) {
                BreedingUtilities.applyMirrorHerb(pokemon);
            }
            if (PastureBreedingData.registry.containsKey(pos)) {
                data = PastureBreedingData.registry.get(pos);
            } else {
                data = new PastureBreedingData(world.method_8510(), (class_2371<class_1799>)class_2371.method_10213((int)PokemonPastureBlockEntityMixin.getConfig().getPastureInventorySize(), (Object)class_1799.field_8037), PokemonPastureBlockEntityMixin.getNewBreedingTime());
                PastureBreedingData.registry.put(pos, data);
            }
            Collection<Map.Entry<FormData, List<Pair<Pokemon, Pokemon>>>> possibleEggs = BreedingUtilities.getPossibleEggs(pokemon);
            if (((Boolean)state.method_11654((class_2769)BREEDING_ACTIVATED)).booleanValue() && !possibleEggs.isEmpty()) {
                if (data.getEggs().stream().anyMatch(itemStack -> itemStack.equals(class_1799.field_8037))) {
                    boolean egg_created = false;
                    long pasture_time = data.getTime() == -1L ? world_time : data.getTime();
                    data.setTime(pasture_time);
                    for (long time_difference = world_time - pasture_time; time_difference >= (long)data.getRequiredTicks(); time_difference -= (long)data.getRequiredTicks()) {
                        egg_created = true;
                        PokemonPastureBlockEntityMixin.addEgg(world, data, pos, blockEntity, possibleEggs);
                        data.setRequiredTicks(PokemonPastureBlockEntityMixin.getNewBreedingTime());
                        if (data.getEggs().stream().anyMatch(itemStack -> itemStack.equals(class_1799.field_8037))) continue;
                    }
                    if (egg_created) {
                        data.setTime(world_time);
                        world.method_8501(pos, (class_2680)state.method_11657((class_2769)HAS_EGG, (Comparable)Boolean.valueOf(data.getEggs().stream().anyMatch(itemStack -> !itemStack.equals(class_1799.field_8037)))));
                        world.method_8396(null, pos, class_3417.field_15219, class_3419.field_15245, 1.0f, 1.0f);
                    }
                }
            } else {
                data.setTime(-1L);
            }
        }
    }

    private static void addEgg(class_1937 world, PastureBreedingData data, class_2338 pos, PokemonPastureBlockEntity blockEntity, Collection<Map.Entry<FormData, List<Pair<Pokemon, Pokemon>>>> possibleEggs) {
        PokemonProperties eggData = BreedingUtilities.chooseEgg(possibleEggs);
        class_1799 eggItem = null;
        if (eggData != null) {
            if (eggData.getSpecies() != null) {
                Species egg_pokemon = PokemonSpecies.INSTANCE.getByName(eggData.getSpecies());
                if (egg_pokemon != null) {
                    FormData form = egg_pokemon.getStandardForm();
                    if (eggData.getForm() != null) {
                        form = egg_pokemon.getFormByShowdownId(eggData.getForm());
                    }
                    eggItem = Cobbreeding.config.getCustomColors() ? EggUtilities.selectEggItem(form) : new class_1799((class_1935)Cobbreeding.EGG_ITEMS.get("pokemon_egg").get());
                    Object name = egg_pokemon.getName();
                    if (eggData.getForm() != null && !form.getName().equals("Normal")) {
                        name = (String)name + " " + form.getName();
                    }
                    eggItem.method_57379((class_9331)CobbreedingComponents.NAME.get(), name);
                    eggItem.method_57379((class_9331)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(egg_pokemon));
                }
                if (eggData.getSpecies().equals("random")) {
                    eggItem = new class_1799((class_1935)Cobbreeding.EGG_ITEMS.get("pokemon_egg").get());
                    eggItem.method_57379((class_9331)CobbreedingComponents.TIMER.get(), (Object)EggUtilities.calculateTimer(PokemonSpecies.INSTANCE.random()));
                }
                if (egg_pokemon != null || eggData.getSpecies().equals("random")) {
                    if (!PokemonPastureBlockEntityMixin.getConfig().getEggEncryptionEnabled()) {
                        eggItem.method_57379((class_9331)CobbreedingComponents.POKEMON_PROPERTIES.get(), (Object)eggData.asString(" "));
                    }
                    eggItem.method_57379((class_9331)CobbreedingComponents.EGG_INFO.get(), (Object)EggUtilities.encrypt(eggData));
                    eggItem.method_57379((class_9331)CobbreedingComponents.VERSION.get(), (Object)"2.0.0");
                    PokemonPastureBlockEntityMixin.set(data.getEggs(), eggItem);
                }
            }
            if (eggItem == null) {
                Cobbreeding.LOGGER.error("Couldn't add egg to pasture. Properties : " + String.valueOf(eggData));
            }
        }
        data.setRequiredTicks(PokemonPastureBlockEntityMixin.getNewBreedingTime());
    }

    private static void set(class_2371<class_1799> list, class_1799 stack) {
        for (int slot = 0; slot < list.size(); ++slot) {
            class_1799 itemStack = (class_1799)list.get(slot);
            if (!itemStack.equals(class_1799.field_8037)) continue;
            list.set(slot, (Object)stack);
            return;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"saveAdditional"})
    private void writeNbt(class_2487 nbt, class_7225.class_7874 provider, CallbackInfo ci) {
        class_1262.method_5426((class_2487)nbt, this.getItems(), (class_7225.class_7874)provider);
    }

    @Inject(at={@At(value="TAIL")}, method={"loadAdditional"})
    private void readNbt(class_2487 nbt, class_7225.class_7874 provider, CallbackInfo ci) {
        class_1262.method_5429((class_2487)nbt, this.getItems(), (class_7225.class_7874)provider);
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 direction) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 direction) {
        return PokemonPastureBlockEntityMixin.getConfig().getAllowHoppersToPullFromPastureBlock();
    }

    public int @NotNull [] method_5494(class_2350 direction) {
        return new int[]{0};
    }
}

