/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util.text;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;

public class StyleUtil {
    private static boolean debug = false;

    private StyleUtil() {
    }

    public static Component restyle(Component msg, String cleanStr, Trigger trig, Matcher matcher, TextStyle textStyle, boolean restyleAllInstances) {
        block22: {
            boolean bl = debug = Config.get().debugMode == Config.DebugMode.ALL;
            if (!textStyle.isEnabled()) {
                return msg;
            }
            try {
                msg = FormatUtil.convertToStyledLiteral(msg.m_6881_());
                if (debug) {
                    ChatNotify.LOG.warn("Converting message prior to initiating restyle", new Object[0]);
                    ChatNotify.LOG.warn("Converted text:", new Object[0]);
                    ChatNotify.LOG.warn(msg.getString(), new Object[0]);
                    ChatNotify.LOG.warn("Converted tree:", new Object[0]);
                    ChatNotify.LOG.warn(msg.toString(), new Object[0]);
                }
                boolean restyled = false;
                if (trig.styleTarget.enabled && !trig.styleTarget.string.isBlank()) {
                    switch (trig.styleTarget.type) {
                        case NORMAL: {
                            Matcher m = StyleUtil.styleSearch(cleanStr, trig.styleTarget.string);
                            if (!m.find()) break;
                            restyled = true;
                            do {
                                msg = StyleUtil.restyleLeaves(msg, textStyle, m.start(), m.end());
                            } while (restyleAllInstances && m.find());
                            break;
                        }
                        case REGEX: {
                            Matcher m;
                            if (trig.styleTarget.pattern == null || !(m = trig.styleTarget.pattern.matcher(cleanStr)).find()) break;
                            restyled = true;
                            do {
                                msg = StyleUtil.restyleLeaves(msg, textStyle, m.start(), m.end());
                            } while (restyleAllInstances && m.find());
                            break;
                        }
                        case CAPTURING: {
                            if (trig.type != Trigger.Type.REGEX || matcher.groupCount() < 1) break;
                            for (int i = 1; i <= matcher.groupCount(); ++i) {
                                if (!trig.styleTarget.groupIndexes.contains(i)) continue;
                                restyled = true;
                                msg = StyleUtil.restyleLeaves(msg, textStyle, matcher.start(i), matcher.end(i));
                            }
                            break;
                        }
                    }
                }
                if (!restyled) {
                    if (debug) {
                        ChatNotify.LOG.warn("Style target '{}' (type {})", new Object[]{trig.styleTarget.string, trig.styleTarget.type});
                        ChatNotify.LOG.warn("Defaulting to trigger restyle", new Object[0]);
                    }
                    switch (trig.type) {
                        case NORMAL: {
                            do {
                                msg = StyleUtil.restyleLeaves(msg, textStyle, matcher.start() + matcher.group(1).length(), matcher.end() - matcher.group(2).length());
                            } while (restyleAllInstances && matcher.find());
                            break;
                        }
                        case REGEX: {
                            do {
                                msg = StyleUtil.restyleLeaves(msg, textStyle, matcher.start(), matcher.end());
                            } while (restyleAllInstances && matcher.find());
                            break;
                        }
                        case KEY: {
                            msg = StyleUtil.restyleRoot(msg, textStyle);
                        }
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!debug) break block22;
                ChatNotify.LOG.warn("Restyle error", e);
            }
        }
        return msg;
    }

    public static Matcher styleSearch(String msg, String str) {
        return Pattern.compile("(?iU)" + Pattern.quote(str)).matcher(msg);
    }

    private static Component restyleRoot(Component msg, TextStyle style) {
        return msg.m_6881_().m_6270_(StyleUtil.applyStyle(msg.m_7383_(), style));
    }

    private static Component restyleLeaves(Component msg, TextStyle style, int start, int end) {
        return StyleUtil.recursiveRestyle(msg.m_6881_(), style, start, end, 0);
    }

    private static MutableComponent recursiveRestyle(MutableComponent msg, TextStyle style, int start, int end, int index) {
        if (debug) {
            ChatNotify.LOG.warn("recursiveRestyle('{}', {}, {}, {})", msg.getString(), start, end, index);
        }
        ArrayList oldSiblings = new ArrayList(msg.m_7360_());
        msg.m_7360_().clear();
        ComponentContents componentContents = msg.m_214077_();
        if (componentContents instanceof LiteralContents) {
            String str;
            LiteralContents contents = (LiteralContents)componentContents;
            if (debug) {
                ChatNotify.LOG.warn("LiteralContents", new Object[0]);
            }
            if (index + (str = contents.f_237368_()).length() >= start && index < end) {
                String part3;
                String part2;
                Style oldStyle = msg.m_7383_();
                msg = Component.m_237119_().m_130948_(oldStyle);
                int localStart = Math.max(0, start - index);
                int localEnd = Math.min(str.length(), end - index);
                String part1 = str.substring(0, localStart);
                if (!part1.isEmpty()) {
                    msg.m_7220_((Component)Component.m_237113_((String)part1));
                }
                if (!(part2 = str.substring(localStart, localEnd)).isEmpty()) {
                    msg.m_7220_((Component)Component.m_237113_((String)part2).m_130948_(style.getStyle()));
                }
                if (!(part3 = str.substring(localEnd)).isEmpty()) {
                    msg.m_7220_((Component)Component.m_237113_((String)part3));
                }
            }
            index += str.length();
        } else {
            index += msg.getString().length();
        }
        List siblings = msg.m_7360_();
        for (Component sibling : oldSiblings) {
            String str = sibling.getString();
            if (index + str.length() >= start && index < end) {
                siblings.add(StyleUtil.recursiveRestyle(sibling.m_6881_(), style, start, end, index));
            } else {
                siblings.add(sibling);
            }
            index += str.length();
        }
        return msg;
    }

    public static Component styledSubstring(Component msg, int start, int end) {
        return StyleUtil.recursiveStyledSubstring(msg.m_6881_(), start, end, 0);
    }

    private static MutableComponent recursiveStyledSubstring(MutableComponent msg, int start, int end, int index) {
        if (debug) {
            ChatNotify.LOG.warn("recursiveStyledSubstring('{}', {}, {}, {})", msg.getString(), start, end, index);
        }
        ArrayList oldSiblings = new ArrayList(msg.m_7360_());
        msg.m_7360_().clear();
        ComponentContents componentContents = msg.m_214077_();
        if (componentContents instanceof LiteralContents) {
            LiteralContents contents = (LiteralContents)componentContents;
            if (debug) {
                ChatNotify.LOG.warn("LiteralContents", new Object[0]);
            }
            Style oldStyle = msg.m_7383_();
            msg = Component.m_237119_().m_130948_(oldStyle);
            String str = contents.f_237368_();
            if (index + str.length() >= start && index < end) {
                int localStart = Math.max(0, start - index);
                int localEnd = Math.min(str.length(), end - index);
                str = str.substring(localStart, localEnd);
                msg.m_7220_((Component)Component.m_237113_((String)str));
            }
            index += str.length();
        }
        List siblings = msg.m_7360_();
        for (Component sibling : oldSiblings) {
            String str = sibling.getString();
            if (index + str.length() >= start && index < end) {
                siblings.add(StyleUtil.recursiveStyledSubstring(sibling.m_6881_(), start, end, index));
            }
            index += str.length();
        }
        return msg;
    }

    private static Style applyStyle(Style style, TextStyle textStyle) {
        if (!textStyle.bold.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.m_131136_(Boolean.valueOf(textStyle.bold.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (!textStyle.italic.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.m_131155_(Boolean.valueOf(textStyle.italic.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (!textStyle.underlined.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.m_131162_(Boolean.valueOf(textStyle.underlined.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (!textStyle.strikethrough.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.m_178522_(Boolean.valueOf(textStyle.strikethrough.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (!textStyle.obfuscated.equals((Object)TextStyle.FormatMode.DISABLED)) {
            style = style.m_178524_(Boolean.valueOf(textStyle.obfuscated.equals((Object)TextStyle.FormatMode.ON)));
        }
        if (textStyle.doColor) {
            style = style.m_131148_(textStyle.getTextColor());
        }
        return style;
    }
}

