/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.Sound;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.config.util.JsonUtil;
import dev.terminalmc.chatnotify.util.functional.StringSupplier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public class Notification
implements StringSupplier {
    public static final int VERSION = 8;
    public final int version = 8;
    public transient boolean editing = false;
    public boolean enabled;
    public static final boolean enabledDefault = true;
    public CheckOwnMode checkOwnMode;
    public boolean inclusionEnabled;
    public static final boolean inclusionEnabledDefault = true;
    public boolean exclusionEnabled;
    public static final boolean exclusionEnabledDefault = true;
    public boolean responseEnabled;
    public static final boolean responseEnabledDefault = true;
    public final Sound sound;
    public static final Supplier<Sound> soundDefault = Sound::new;
    public final TextStyle textStyle;
    public static final Supplier<TextStyle> textStyleDefault = TextStyle::new;
    public String replacementMsg;
    public static final String replacementMsgDefault = "";
    public boolean replacementMsgEnabled;
    public static final boolean replacementMsgEnabledDefault = false;
    public String statusBarMsg;
    public static final String statusBarMsgDefault = "";
    public boolean statusBarMsgEnabled;
    public static final boolean statusBarMsgEnabledDefault = false;
    public String titleMsg;
    public static final String titleMsgDefault = "";
    public boolean titleMsgEnabled;
    public static final boolean titleMsgEnabledDefault = false;
    public String subtitleMsg;
    public static final String subtitleMsgDefault = "";
    public boolean subtitleMsgEnabled;
    public static final boolean subtitleMsgEnabledDefault = false;
    public String toastMsg;
    public static final String toastMsgDefault = "";
    public boolean toastMsgEnabled;
    public static final boolean toastMsgEnabledDefault = false;
    public String typedMsg;
    public static final String typedMsgDefault = "";
    public boolean typedMsgEnabled;
    public static final boolean typedMsgEnabledDefault = false;
    public String clipboardMsg;
    public static final String clipboardMsgDefault = "";
    public boolean clipboardMsgEnabled;
    public static final boolean clipboardMsgEnabledDefault = false;
    public boolean soundSync;
    public static final boolean soundSyncDefault = true;
    public int delay;
    public static final int timingDelayDefault = 0;
    public int titleFadeIn;
    public static final int titleFadeInDefault = 10;
    public int titleStay;
    public static final int titleStayDefault = 70;
    public int titleFadeOut;
    public static final int titleFadeOutDefault = 20;
    public int statusBarStay;
    public static final int statusBarStayDefault = 60;
    public int toastStay;
    public static final int toastStayDefault = 100;
    public final List<Trigger> triggers;
    public static final Supplier<List<Trigger>> triggersDefault = ArrayList::new;
    public final List<Trigger> inclusionTriggers;
    public static final Supplier<List<Trigger>> inclusionTriggersDefault = ArrayList::new;
    public final List<Trigger> exclusionTriggers;
    public static final Supplier<List<Trigger>> exclusionTriggersDefault = ArrayList::new;
    public final List<Response> responses;
    public static final Supplier<List<Response>> responsesDefault = ArrayList::new;

    Notification(boolean enabled, CheckOwnMode checkOwnMode, boolean inclusionEnabled, boolean exclusionEnabled, boolean responseEnabled, Sound sound, TextStyle textStyle, String replacementMsg, boolean replacementMsgEnabled, String statusBarMsg, boolean statusBarMsgEnabled, String titleMsg, boolean titleMsgEnabled, String subtitleMsg, boolean subtitleMsgEnabled, String toastMsg, boolean toastMsgEnabled, String typedMsg, boolean typedMsgEnabled, String clipboardMsg, boolean clipboardMsgEnabled, boolean soundSync, int delay, int titleFadeIn, int titleStay, int titleFadeOut, int statusBarStay, int toastStay, List<Trigger> triggers, List<Trigger> inclusionTriggers, List<Trigger> exclusionTriggers, List<Response> responses) {
        this.enabled = enabled;
        this.checkOwnMode = checkOwnMode;
        this.inclusionEnabled = inclusionEnabled;
        this.exclusionEnabled = exclusionEnabled;
        this.responseEnabled = responseEnabled;
        this.sound = sound;
        this.textStyle = textStyle;
        this.replacementMsg = replacementMsg;
        this.replacementMsgEnabled = replacementMsgEnabled;
        this.statusBarMsg = statusBarMsg;
        this.statusBarMsgEnabled = statusBarMsgEnabled;
        this.titleMsg = titleMsg;
        this.titleMsgEnabled = titleMsgEnabled;
        this.subtitleMsg = subtitleMsg;
        this.subtitleMsgEnabled = subtitleMsgEnabled;
        this.toastMsg = toastMsg;
        this.toastMsgEnabled = toastMsgEnabled;
        this.typedMsg = typedMsg;
        this.typedMsgEnabled = typedMsgEnabled;
        this.clipboardMsg = clipboardMsg;
        this.clipboardMsgEnabled = clipboardMsgEnabled;
        this.soundSync = soundSync;
        this.delay = delay;
        this.titleFadeIn = titleFadeIn;
        this.titleStay = titleStay;
        this.titleFadeOut = titleFadeOut;
        this.statusBarStay = statusBarStay;
        this.toastStay = toastStay;
        this.triggers = triggers;
        this.inclusionTriggers = inclusionTriggers;
        this.exclusionTriggers = exclusionTriggers;
        this.responses = responses;
    }

    static Notification createUser() {
        return new Notification(true, CheckOwnMode.values()[0], true, true, true, soundDefault.get(), textStyleDefault.get(), "", false, "", false, "", false, "", false, "", false, "", false, "", false, true, 0, 10, 70, 20, 60, 100, new ArrayList<Trigger>(List.of(new Trigger("Profile name"), new Trigger("Display name"))), inclusionTriggersDefault.get(), exclusionTriggersDefault.get(), responsesDefault.get());
    }

    static Notification createBlank(Sound sound, TextStyle textStyle) {
        return new Notification(true, CheckOwnMode.values()[0], true, true, true, sound, textStyle, "", false, "", false, "", false, "", false, "", false, "", false, "", false, true, 0, 10, 70, 20, 60, 100, new ArrayList<Trigger>(List.of(new Trigger(""))), inclusionTriggersDefault.get(), exclusionTriggersDefault.get(), responsesDefault.get());
    }

    public boolean canBeTriggered(boolean ownMsg) {
        if (this.enabled && !this.editing) {
            if (ownMsg) {
                return switch (this.checkOwnMode) {
                    default -> throw new IncompatibleClassChangeError();
                    case CheckOwnMode.DEFER -> Config.get().checkOwnMessages;
                    case CheckOwnMode.ON -> true;
                    case CheckOwnMode.OFF -> false;
                };
            }
            return true;
        }
        return false;
    }

    public boolean moveTrigger(int srcIdx, int dstIdx) {
        if (srcIdx != dstIdx) {
            this.triggers.add(dstIdx, this.triggers.remove(srcIdx));
            return true;
        }
        return false;
    }

    public boolean moveInclusionTrigger(int srcIdx, int dstIdx) {
        if (srcIdx != dstIdx) {
            this.inclusionTriggers.add(dstIdx, this.inclusionTriggers.remove(srcIdx));
            return true;
        }
        return false;
    }

    public boolean moveExclusionTrigger(int srcIdx, int dstIdx) {
        if (srcIdx != dstIdx) {
            this.exclusionTriggers.add(dstIdx, this.exclusionTriggers.remove(srcIdx));
            return true;
        }
        return false;
    }

    public boolean moveResponseMessage(int srcIdx, int dstIdx) {
        if (srcIdx != dstIdx) {
            this.responses.add(dstIdx, this.responses.remove(srcIdx));
            return true;
        }
        return false;
    }

    @Override
    public String getString() {
        StringBuilder sb = new StringBuilder();
        for (Trigger t : this.triggers) {
            sb.append(t.getString());
        }
        return sb.toString();
    }

    Notification validate() {
        this.textStyle.validate();
        this.sound.validate();
        this.triggers.removeIf(t -> {
            t.validate();
            return t.string.isBlank();
        });
        this.inclusionTriggers.removeIf(t -> {
            t.validate();
            return t.string.isBlank();
        });
        this.exclusionTriggers.removeIf(t -> {
            t.validate();
            return t.string.isBlank();
        });
        this.responses.removeIf(m -> {
            m.validate();
            return m.string.isBlank();
        });
        return this;
    }

    public static enum CheckOwnMode {
        DEFER,
        ON,
        OFF;

    }

    public static class Deserializer
    implements JsonDeserializer<Notification> {
        public Notification deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 8;
            boolean enabled = JsonUtil.getOrDefault(obj, "enabled", true, silent);
            boolean inclusionEnabled = JsonUtil.getOrDefault(obj, "inclusionEnabled", true, silent);
            boolean exclusionEnabled = JsonUtil.getOrDefault(obj, "exclusionEnabled", true, silent);
            CheckOwnMode checkOwnMode = JsonUtil.getOrDefault(obj, "checkOwnMode", CheckOwnMode.class, CheckOwnMode.values()[0], silent);
            boolean responseEnabled = JsonUtil.getOrDefault(obj, "responseEnabled", true, silent);
            Sound sound = JsonUtil.getOrDefault(ctx, obj, "sound", Sound.class, soundDefault.get(), silent);
            TextStyle textStyle = JsonUtil.getOrDefault(ctx, obj, "textStyle", TextStyle.class, textStyleDefault.get(), silent);
            String replacementMsg = JsonUtil.getOrDefault(obj, "replacementMsg", "", silent);
            boolean replacementMsgEnabled = JsonUtil.getOrDefault(obj, "replacementMsgEnabled", false, silent);
            String statusBarMsg = JsonUtil.getOrDefault(obj, "statusBarMsg", "", silent);
            boolean statusBarMsgEnabled = JsonUtil.getOrDefault(obj, "statusBarMsgEnabled", false, silent);
            String titleMsg = JsonUtil.getOrDefault(obj, "titleMsg", "", silent);
            boolean titleMsgEnabled = JsonUtil.getOrDefault(obj, "titleMsgEnabled", false, silent);
            String subtitleMsg = JsonUtil.getOrDefault(obj, "subtitleMsg", "", silent);
            boolean subtitleMsgEnabled = JsonUtil.getOrDefault(obj, "subtitleMsgEnabled", false, silent);
            String toastMsg = JsonUtil.getOrDefault(obj, "toastMsg", "", silent);
            boolean toastMsgEnabled = JsonUtil.getOrDefault(obj, "toastMsgEnabled", false, silent);
            String typedMsg = JsonUtil.getOrDefault(obj, "typedMsg", "", silent);
            boolean typedMsgEnabled = JsonUtil.getOrDefault(obj, "typedMsgEnabled", false, silent);
            String clipboardMsg = JsonUtil.getOrDefault(obj, "clipboardMsg", "", silent);
            boolean clipboardMsgEnabled = JsonUtil.getOrDefault(obj, "clipboardMsgEnabled", false, silent);
            boolean soundSync = JsonUtil.getOrDefault(obj, "soundSync", true, silent);
            int delay = JsonUtil.getOrDefault(obj, "delay", 0, silent);
            int titleFadeIn = JsonUtil.getOrDefault(obj, "titleFadeIn", 10, silent);
            int titleStay = JsonUtil.getOrDefault(obj, "titleStay", 70, silent);
            int titleFadeOut = JsonUtil.getOrDefault(obj, "titleFadeOut", 20, silent);
            int statusBarStay = JsonUtil.getOrDefault(obj, "statusBarStay", 60, silent);
            int toastStay = JsonUtil.getOrDefault(obj, "toastStay", 100, silent);
            List<Trigger> triggers = JsonUtil.getOrDefault(ctx, obj, "triggers", Trigger.class, triggersDefault.get(), silent);
            List<Trigger> inclusionTriggers = JsonUtil.getOrDefault(ctx, obj, "inclusionTriggers", Trigger.class, inclusionTriggersDefault.get(), silent);
            List<Trigger> exclusionTriggers = JsonUtil.getOrDefault(ctx, obj, "exclusionTriggers", Trigger.class, exclusionTriggersDefault.get(), silent);
            List<Response> responses = JsonUtil.getOrDefault(ctx, obj, "responses", Response.class, responsesDefault.get(), silent);
            if (version < 8) {
                responses = JsonUtil.getOrDefault(ctx, obj, "responseMessages", Response.class, responsesDefault.get(), true);
            }
            if (version <= 3) {
                int totalDelay = 0;
                for (Response resMsg : responses) {
                    resMsg.delayTicks -= totalDelay;
                    totalDelay += resMsg.delayTicks;
                }
            }
            return new Notification(enabled, checkOwnMode, inclusionEnabled, exclusionEnabled, responseEnabled, sound, textStyle, replacementMsg, replacementMsgEnabled, statusBarMsg, statusBarMsgEnabled, titleMsg, titleMsgEnabled, subtitleMsg, subtitleMsgEnabled, toastMsg, toastMsgEnabled, typedMsg, typedMsgEnabled, clipboardMsg, clipboardMsgEnabled, soundSync, delay, titleFadeIn, titleStay, titleFadeOut, statusBarStay, toastStay, triggers, inclusionTriggers, exclusionTriggers, responses).validate();
        }
    }
}

