/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.screen;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.list.FilterList;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.gui.widget.list.root.ControlList;
import dev.terminalmc.chatnotify.gui.widget.list.root.DefaultList;
import dev.terminalmc.chatnotify.gui.widget.list.root.DetectionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;

public class RootScreen
extends OptionScreen {
    public RootScreen(class_437 lastScreen) {
        this(lastScreen, TabKey.NOTIFICATION.key);
    }

    public RootScreen(class_437 lastScreen, String defaultKey) {
        super(lastScreen);
        this.addTabs(defaultKey);
        this.updateTabTitles();
    }

    private void addTabs(String defaultKey) {
        List<OptionScreen.Tab> tabs = List.of(new OptionScreen.Tab(TabKey.NOTIFICATION.key, this::getNotificationList), new OptionScreen.Tab(TabKey.CONTROL.key, RootScreen::getControlList), new OptionScreen.Tab(TabKey.DEFAULT.key, RootScreen::getDefaultList), new OptionScreen.Tab(TabKey.DETECTION.key, RootScreen::getDetectionList));
        super.setTabs(tabs, defaultKey);
    }

    public void updateTabTitles() {
        for (TabKey tabKey : TabKey.values()) {
            this.updateTabTitle(tabKey);
        }
    }

    private void updateTabTitle(TabKey tabKey) {
        class_5250 title = class_2561.method_43471((String)tabKey.key);
        switch (tabKey) {
            case NOTIFICATION: {
                if (Config.get().getNotifs().isEmpty()) break;
                title.method_27693(" ");
                title.method_10852((class_2561)Localization.localized("common", "count", Config.get().getNotifs().size()));
            }
        }
        super.updateTabTitle(tabKey.key, (class_2561)title);
    }

    @Override
    protected void addFooter() {
        int spacing = 4;
        int buttonWidth = 116 - spacing;
        int buttonHeight = 20;
        int x1 = this.field_22789 / 2 - buttonWidth - spacing / 2;
        int x2 = this.field_22789 / 2 + spacing / 2;
        int y = Math.min(this.field_22790 - buttonHeight, this.field_22790 - 16 - buttonHeight / 2);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.onCancel()).method_46433(x1, y).method_46437(buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46433(x2, y).method_46437(buttonWidth, buttonHeight).method_46431());
    }

    private void onCancel() {
        class_310.method_1551().method_1507((class_437)new class_410(confirm -> {
            if (confirm) {
                Config.reload();
                class_310.method_1551().method_1507((class_437)this);
                this.method_25419();
            } else {
                class_310.method_1551().method_1507((class_437)this);
            }
        }, (class_2561)Localization.localized("option", "root.exit_without_saving", new Object[0]), (class_2561)Localization.localized("option", "root.exit_without_saving.confirm", new Object[0])));
    }

    @Override
    public void method_25419() {
        super.method_25419();
        Config.save();
    }

    private OptionList getNotificationList(OptionScreen screen) {
        return new FilterList<Notification>(class_310.method_1551(), screen, 0, 0, 0, 0, 232, 20, 5, FilterList.Entry.NotifOptions.class, (srcIdx, dstIdx) -> {
            srcIdx = srcIdx + 1;
            dstIdx = dstIdx + 1;
            return Config.get().moveNotif((int)srcIdx, (int)dstIdx);
        }, () -> this.updateTabTitle(TabKey.NOTIFICATION), (class_2561)Localization.localized("option", "notif.list", Unicode.INFO.str), (class_2561)Localization.localized("option", "notif.list.tooltip", new Object[0]), null, null, () -> Config.get().getNotifs(), (x, width, height, list, notif, index) -> index == 0 ? new FilterList.Entry.NotifOptions.Locked(x, width, height, list, (Notification)notif) : new FilterList.Entry.NotifOptions(x, width, height, list, (Notification)notif, index), null, () -> Config.get().addNotif());
    }

    private static OptionList getControlList(OptionScreen screen) {
        return new ControlList(class_310.method_1551(), screen, 0, 0, 0, 0, 232, 20, 5);
    }

    private static OptionList getDetectionList(OptionScreen screen) {
        return new DetectionList(class_310.method_1551(), screen, 0, 0, 0, 0, 232, 20, 5);
    }

    private static OptionList getDefaultList(OptionScreen screen) {
        return new DefaultList(class_310.method_1551(), screen, 0, 0, 0, 0, 232, 20, 5);
    }

    public static enum TabKey {
        NOTIFICATION(Localization.translationKey("option", "notif")),
        CONTROL(Localization.translationKey("option", "control")),
        DEFAULT(Localization.translationKey("option", "default")),
        DETECTION(Localization.translationKey("option", "detection"));

        public final String key;

        private TabKey(String key) {
            this.key = key;
        }
    }
}

