/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import dev.terminalmc.chatnotify.mixin.accessor.AbstractWidgetAccessor;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public abstract class OverlayWidget
extends class_339 {
    private Consumer<OverlayWidget> close;
    public final boolean fixedSize;
    public final double nominalWidthRatio;
    public final double nominalHeightRatio;

    public OverlayWidget(int x, int y, int width, int height, boolean fixedSize, class_2561 msg, Consumer<OverlayWidget> close) {
        super(x, y, width, height, msg);
        this.checkWidth(width);
        this.checkHeight(height);
        this.close = close;
        class_1041 window = class_310.method_1551().method_22683();
        this.fixedSize = fixedSize;
        this.nominalWidthRatio = (double)width / (double)window.method_4486();
        this.nominalHeightRatio = (double)height / (double)window.method_4502();
    }

    public void addOnClose(Consumer<OverlayWidget> close) {
        Consumer<OverlayWidget> close2 = this.close;
        this.close = widget -> {
            close.accept((OverlayWidget)((Object)widget));
            close2.accept((OverlayWidget)((Object)widget));
        };
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return true;
    }

    protected abstract void init();

    public void onClose() {
        this.close.accept(this);
    }

    public abstract int getMinWidth();

    public abstract int getMaxWidth();

    public abstract int getMinHeight();

    public abstract int getMaxHeight();

    public int getNominalWidth(int screenWidth) {
        if (this.fixedSize) {
            return this.field_22758;
        }
        return Math.min(Math.max(this.getMinWidth(), (int)((double)screenWidth * this.nominalWidthRatio)), this.getMaxWidth());
    }

    public int getNominalHeight(int screenHeight) {
        if (this.fixedSize) {
            return this.field_22759;
        }
        return Math.min(Math.max(this.getMinHeight(), (int)((double)screenHeight * this.nominalHeightRatio)), this.getMaxHeight());
    }

    public void updateBounds(int screenWidth, int screenHeight) {
        super.method_25358(this.getNominalWidth(screenWidth));
        ((AbstractWidgetAccessor)((Object)this)).chatnotify$setHeight(this.getNominalHeight(screenHeight));
        super.method_46421(screenWidth / 2 - this.method_25368() / 2);
        super.method_46419(screenHeight / 2 - this.method_25364() / 2);
        this.init();
    }

    public void method_48229(int x, int y) {
        super.method_48229(x, y);
        this.init();
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.init();
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.init();
    }

    public void setSize(int width, int height) {
        this.method_25358(width);
        this.setHeight(height);
        this.init();
    }

    public void method_25358(int width) {
        super.method_25358(this.checkWidth(width));
        this.init();
    }

    public void setHeight(int height) {
        ((AbstractWidgetAccessor)((Object)this)).chatnotify$setHeight(this.checkHeight(height));
        this.init();
    }

    protected int checkWidth(int width) {
        if (width < this.getMinWidth()) {
            throw new IllegalArgumentException("Width cannot be less than " + this.getMinWidth() + ", got " + width);
        }
        return width;
    }

    protected int checkHeight(int height) {
        if (height < this.getMinHeight()) {
            throw new IllegalArgumentException("Height cannot be less than " + this.getMinHeight() + ", got " + height);
        }
        return height;
    }

    protected void method_47399(@NotNull class_6382 narration) {
    }
}

