/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfirmButton
extends Button {
    private Component message;
    private Component confirmMessage;
    private boolean hasBeenPressed;

    public ConfirmButton(int x, int y, int width, int height, Component message, Component confirmMessage, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
        this.message = message;
        this.confirmMessage = confirmMessage;
    }

    public void reset() {
        this.hasBeenPressed = false;
        super.setMessage(this.message);
    }

    public void setMessage(@NotNull Component message) {
        this.message = message;
        if (!this.hasBeenPressed) {
            super.setMessage(message);
        }
    }

    public void setConfirmMessage(@NotNull Component confirmMessage) {
        this.confirmMessage = confirmMessage;
        if (this.hasBeenPressed) {
            super.setMessage(confirmMessage);
        }
    }

    public void onPress() {
        if (!this.hasBeenPressed) {
            this.hasBeenPressed = true;
            super.setMessage(this.confirmMessage);
        } else {
            super.onPress();
        }
    }
}

