/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.NotifScreen;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.screen.TriggerScreen;
import dev.terminalmc.chatnotify.gui.widget.ConfirmButton;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.RightClickableButton;
import dev.terminalmc.chatnotify.gui.widget.field.DropdownTextField;
import dev.terminalmc.chatnotify.gui.widget.field.FakeTextField;
import dev.terminalmc.chatnotify.gui.widget.field.MultiLineTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.DragReorderList;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.KeyAccessor;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.functional.StringSupplier;
import dev.terminalmc.chatnotify.util.text.ColorUtil;
import java.awt.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_3544;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class FilterList<E extends StringSupplier>
extends DragReorderList {
    private String filterString = "";
    @Nullable
    private Pattern filterPattern = null;
    private OptionList.Entry.ActionButton addButtonEntry;
    private final Runnable tabNameUpdate;
    private final class_2561 title;
    private final class_2561 titleTooltip;
    @Nullable
    private final Supplier<Boolean> statusSupplier;
    @Nullable
    private final Consumer<Boolean> statusConsumer;
    private final Supplier<List<E>> listSupplier;
    private final EntrySupplier<E> entrySupplier;
    @Nullable
    private final TrailerSupplier<E> trailerSupplier;

    public FilterList(class_310 mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing, Class<? extends Entry.ListEntry> entryClass, BiFunction<Integer, Integer, Boolean> moveFunction, Runnable tabNameUpdate, class_2561 title, class_2561 titleTooltip, @Nullable Supplier<Boolean> statusSupplier, @Nullable Consumer<Boolean> statusConsumer, Supplier<List<E>> listSupplier, EntrySupplier<E> entrySupplier, @Nullable TrailerSupplier<E> trailerSupplier, Runnable addRunnable) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, entrySpacing, new HashMap<Class<? extends OptionList.Entry>, BiFunction<Integer, Integer, Boolean>>(Map.of(entryClass, moveFunction)));
        this.tabNameUpdate = tabNameUpdate;
        this.title = title;
        this.titleTooltip = titleTooltip;
        this.statusSupplier = statusSupplier;
        this.statusConsumer = statusConsumer;
        this.listSupplier = listSupplier;
        this.entrySupplier = entrySupplier;
        this.trailerSupplier = trailerSupplier;
        this.addButtonEntry = new OptionList.Entry.ActionButton(this.entryX, entryWidth, entryHeight, (class_2561)class_2561.method_43470((String)"+"), null, -1, button -> {
            addRunnable.run();
            tabNameUpdate.run();
            this.filterString = "";
            this.filterPattern = null;
            this.init();
            this.method_25328((class_350.class_351)this.addButtonEntry);
        });
    }

    @Override
    protected void addEntries() {
        this.method_25321((class_350.class_351)new Entry.ListHeader(this.dynEntryX, this.dynEntryWidth, this.entryHeight, this));
        this.refreshSubList();
        this.addButtonEntry.setBounds(this.entryX, this.entryWidth, this.entryHeight);
        this.method_25321((class_350.class_351)this.addButtonEntry);
    }

    protected void refreshSubList() {
        Iterator iterator = this.method_25396().iterator();
        while (iterator.hasNext()) {
            OptionList.Entry entry = (OptionList.Entry)((Object)iterator.next());
            if (entry instanceof Entry.SpacedListEntry) {
                iterator.remove();
                iterator.next();
                iterator.remove();
                continue;
            }
            if (!(entry instanceof Entry.ListEntry) && !(entry instanceof Entry.ListEntryTrailer)) continue;
            iterator.remove();
        }
        int start = this.method_25396().indexOf((Object)this.addButtonEntry);
        if (start == -1) {
            start = this.method_25396().size();
        }
        List<E> list = this.listSupplier.get();
        for (int i = list.size() - 1; i >= 0; --i) {
            Entry.ListEntryTrailer trailer;
            StringSupplier e = (StringSupplier)list.get(i);
            if (this.filterPattern != null && !this.filterPattern.matcher(e.getString()).find()) continue;
            Entry.ListEntry entry = this.entrySupplier.get(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, e, list.indexOf(e));
            if (entry instanceof Entry.SpacedListEntry) {
                this.addEntry(start, new OptionList.Entry.Space(entry));
            } else if (this.trailerSupplier != null && (trailer = this.trailerSupplier.get(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, e)) != null) {
                this.addEntry(start, trailer);
            }
            this.addEntry(start, entry);
        }
        this.tabNameUpdate.run();
        this.method_60322();
    }

    @FunctionalInterface
    public static interface EntrySupplier<E extends StringSupplier> {
        public Entry.ListEntry get(int var1, int var2, int var3, FilterList<?> var4, E var5, int var6);
    }

    @FunctionalInterface
    public static interface TrailerSupplier<E extends StringSupplier> {
        @Nullable
        public Entry.ListEntryTrailer get(int var1, int var2, int var3, FilterList<?> var4, E var5);
    }

    public static abstract class Entry
    extends OptionList.Entry {

        public static class NotifOptions
        extends ListEntry {
            public NotifOptions(int x, int width, int height, FilterList<?> list, Notification notif, int index) {
                TextField triggerField;
                int minFieldWidth;
                class_310 mc = class_310.method_1551();
                Trigger trigger = notif.triggers.size() == 1 ? notif.triggers.getFirst() : null;
                boolean singleTrig = trigger != null;
                int statusButtonWidth = 24;
                int soundFieldWidth = minFieldWidth = mc.field_1772.method_1727("#FFAAFF++");
                int soundFieldWidthMax = mc.field_1772.method_1727("block.note_block.chime++");
                boolean showColorField = false;
                boolean showColorFieldNominal = notif.textStyle.doColor;
                boolean showSoundField = false;
                boolean showSoundFieldNominal = notif.sound.isEnabled();
                int triggerWidth = width - 2 - list.smallWidgetWidth - 2 - list.tinyWidgetWidth - 2 - list.tinyWidgetWidth - 2 - statusButtonWidth;
                int triggerWidthNominalMin = 220;
                int excess = triggerWidth - triggerWidthNominalMin;
                if (excess > minFieldWidth && showSoundFieldNominal) {
                    showSoundField = true;
                    triggerWidth -= soundFieldWidth;
                }
                if ((excess = triggerWidth - triggerWidthNominalMin) > minFieldWidth && showColorFieldNominal) {
                    showColorField = true;
                    triggerWidth -= minFieldWidth;
                }
                if (showSoundField) {
                    excess = triggerWidth - triggerWidthNominalMin;
                    triggerWidth -= excess;
                    int soundBonus = (int)((double)excess * 0.7);
                    int soundMargin = Math.max(0, soundFieldWidth + soundBonus - 100);
                    soundBonus -= (int)((double)soundMargin * 0.5);
                    soundMargin = Math.max(0, soundFieldWidth + soundBonus - soundFieldWidthMax);
                    soundFieldWidth += (soundBonus -= soundMargin);
                    triggerWidth += excess - soundBonus;
                }
                int triggerFieldWidth = triggerWidth;
                if (singleTrig) {
                    triggerFieldWidth -= list.tinyWidgetWidth * 2;
                }
                int movingX = x;
                if (index != 0) {
                    class_4185 indicatorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(index + 1)), button -> {}).method_46433(x - list.smallWidgetWidth - 4 - list.tinyWidgetWidth, 0).method_46437(list.tinyWidgetWidth, height).method_46431();
                    indicatorButton.field_22763 = false;
                    this.elements.add(indicatorButton);
                    class_4185 dragButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.UP_DOWN.str), button -> {
                        this.method_25398(true);
                        list.startDragging(this, null, false);
                    }).method_46433(x - list.smallWidgetWidth - 4, 0).method_46437(list.smallWidgetWidth, height).method_46431();
                    dragButton.field_22763 = list.filterPattern == null;
                    this.elements.add(dragButton);
                }
                if (singleTrig) {
                    class_5676 typeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.icon)).method_32624((Object[])Trigger.Type.values()).method_32616().method_32619((Object)trigger.type).method_32618(type -> class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.type." + String.valueOf(type) + ".tooltip", new Object[0]))).method_32617(movingX, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43473(), (button, type) -> {
                        trigger.type = type;
                        list.init();
                    });
                    typeButton.method_47402(Duration.ofMillis(200L));
                    this.elements.add(typeButton);
                    class_4185 editorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.EDIT.str), button -> {
                        notif.editing = true;
                        mc.method_1507((class_437)new TriggerScreen(mc.field_1755, trigger, notif.textStyle, () -> {
                            notif.editing = false;
                        }, TriggerScreen.TabKey.TRIGGER_EDITOR.key));
                    }).method_46433(movingX += list.tinyWidgetWidth, 0).method_46437(list.tinyWidgetWidth, height).method_46431();
                    editorButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.open.trigger_editor.tooltip", new Object[0])));
                    editorButton.method_47402(Duration.ofMillis(200L));
                    this.elements.add(editorButton);
                    movingX += list.tinyWidgetWidth;
                }
                if (singleTrig) {
                    triggerField = new TextField(movingX, 0, triggerFieldWidth, height);
                    if (trigger.type == Trigger.Type.REGEX) {
                        triggerField.regexValidator();
                    }
                    triggerField.withValidator(new TextField.Validator.UniqueTrigger(notif, trigger));
                    triggerField.method_1880(240);
                    triggerField.method_1863(str -> {
                        trigger.string = str.strip();
                    });
                    triggerField.method_1852(trigger.string);
                    triggerField.method_47404((class_2561)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                } else {
                    triggerField = new FakeTextField(movingX, 0, triggerFieldWidth, height, () -> mc.method_1507((class_437)new NotifScreen(mc.field_1755, notif)));
                    triggerField.method_1880(240);
                    triggerField.method_1852(NotifOptions.createLabel(notif, triggerFieldWidth - 10).getString());
                }
                this.elements.add(triggerField);
                class_344 editButton = new class_344(movingX += triggerFieldWidth + 2, 0, list.smallWidgetWidth, height, OPTION_SPRITES, button -> mc.method_1507((class_437)new NotifScreen(mc.field_1755, notif)));
                editButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.open.options.tooltip", new Object[0])));
                editButton.method_47402(Duration.ofMillis(200L));
                this.elements.add(editButton);
                RightClickableButton colorEditButton = new RightClickableButton(movingX += list.smallWidgetWidth + 2, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43470((String)Unicode.PAINT.str).method_54663(notif.textStyle.doColor ? notif.textStyle.color : 0xFFFFFF), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.screen.setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, list.screen.field_22790 / 2 - cpHeight / 2, cpWidth, cpHeight, () -> notif.textStyle.color, color -> {
                        notif.textStyle.color = color;
                    }, widget -> list.init()));
                }, button -> {
                    notif.textStyle.doColor = !notif.textStyle.doColor;
                    list.init();
                });
                colorEditButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.color.status.tooltip." + (notif.textStyle.doColor ? "enabled" : "disabled"), new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "notif.click_edit", new Object[0]))));
                colorEditButton.method_47402(Duration.ofMillis(200L));
                if (showColorField) {
                    TextField colorField = new TextField(movingX, 0, minFieldWidth, height);
                    colorField.hexColorValidator().strict();
                    colorField.method_1880(7);
                    colorField.method_1863(val -> {
                        class_5251 textColor = ColorUtil.parseColor(val);
                        if (textColor != null) {
                            int color;
                            notif.textStyle.color = color = textColor.method_27716();
                            float[] hsv = new float[3];
                            Color.RGBtoHSB(class_9848.method_61327((int)color), class_9848.method_61329((int)color), class_9848.method_61331((int)color), hsv);
                            if ((double)hsv[2] < 0.1) {
                                colorField.method_1868(0xFFFFFF);
                            } else {
                                colorField.method_1868(color);
                            }
                            colorEditButton.method_25355((class_2561)colorEditButton.method_25369().method_27661().method_54663(color));
                        }
                    });
                    colorField.method_1852(((TextColorAccessor)class_5251.method_27717((int)notif.textStyle.color)).chatnotify$formatValue());
                    colorField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.color.field.tooltip", new Object[0])));
                    colorField.method_47402(Duration.ofMillis(500L));
                    this.elements.add(colorField);
                    movingX += minFieldWidth;
                }
                colorEditButton.method_48229(movingX, 0);
                this.elements.add(colorEditButton);
                movingX += list.tinyWidgetWidth + 2;
                if (showSoundField) {
                    TextField soundField = new TextField(movingX, 0, soundFieldWidth, height);
                    soundField.soundValidator();
                    soundField.method_1880(240);
                    soundField.method_1863(notif.sound::setId);
                    soundField.method_1852(notif.sound.getId());
                    soundField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.sound.field.tooltip", new Object[0])));
                    soundField.method_47402(Duration.ofMillis(500L));
                    this.elements.add(soundField);
                    movingX += soundFieldWidth;
                }
                RightClickableButton soundEditButton = new RightClickableButton(movingX, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43470((String)Unicode.SOUND.str).method_27692(notif.sound.isEnabled() ? class_124.field_1068 : class_124.field_1061), button -> mc.method_1507((class_437)new NotifScreen(mc.field_1755, notif, NotifScreen.TabKey.SOUND.key)), button -> {
                    notif.sound.setEnabled(!notif.sound.isEnabled());
                    list.init();
                });
                soundEditButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.sound.status.tooltip." + (notif.sound.isEnabled() ? "enabled" : "disabled"), new Object[0]).method_27693("\n").method_10852((class_2561)Localization.localized("option", "notif.click_edit", new Object[0]))));
                soundEditButton.method_47402(Duration.ofMillis(200L));
                this.elements.add(soundEditButton);
                this.elements.add(class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32616().method_32619((Object)notif.enabled).method_32617(x + width - statusButtonWidth, 0, statusButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                    notif.enabled = status;
                    list.refreshSubList();
                }));
                if (index != 0) {
                    this.elements.add(new ConfirmButton(x + width + 4, 0, list.smallWidgetWidth, height, (class_2561)class_2561.method_43470((String)Unicode.CROSS.str), (class_2561)class_2561.method_43470((String)Unicode.CROSS.str).method_27692(class_124.field_1061), button -> {
                        if (Config.get().removeNotif(index)) {
                            list.init();
                        }
                    }));
                }
            }

            private static class_5250 createLabel(Notification notif, int maxWidth) {
                class_5250 label;
                class_327 font = class_310.method_1551().field_1772;
                String separator = ", ";
                String plusNumFormat = " [+%d]";
                Pattern plusNumPattern = Pattern.compile(" \\[\\+\\d+]");
                if (notif.triggers.isEmpty() || notif.triggers.getFirst().string.isBlank()) {
                    label = class_2561.method_43470((String)"> ").method_27692(class_124.field_1054).method_10852((class_2561)Localization.localized("option", "notif.label.configure", new Object[0]).method_27692(class_124.field_1068)).method_27693(" <");
                } else {
                    String str;
                    TreeSet<String> usedStrings = new TreeSet<String>();
                    ArrayList<String> strList = new ArrayList<String>();
                    int cap = 10;
                    int i = 0;
                    for (Trigger trig : notif.triggers) {
                        String str2 = class_3544.method_15440((String)trig.string);
                        if (!usedStrings.contains(str2)) {
                            strList.add((String)(i == 0 ? str2 : separator + str2));
                            usedStrings.add(str2);
                        }
                        if (++i < cap) continue;
                        break;
                    }
                    if (notif.triggers.size() > cap) {
                        strList.add(String.format(plusNumFormat, notif.triggers.size() - cap));
                    }
                    while (!(font.method_1727(NotifOptions.compileLabel(strList)) <= maxWidth || strList.size() == 1 || strList.size() == 2 && plusNumPattern.matcher((CharSequence)strList.getLast()).matches())) {
                        if (plusNumPattern.matcher((CharSequence)strList.removeLast()).matches()) {
                            strList.removeLast();
                        }
                        strList.add(String.format(plusNumFormat, usedStrings.size() - strList.size()));
                    }
                    while (font.method_1727(NotifOptions.compileLabel(strList)) > maxWidth && (str = (String)strList.getFirst()).length() >= 3) {
                        strList.set(0, str.substring(0, str.length() - 5) + " ...");
                    }
                    label = class_2561.method_43470((String)NotifOptions.compileLabel(strList));
                    if (notif.textStyle.isEnabled()) {
                        label.method_54663(notif.textStyle.color);
                    }
                }
                return label;
            }

            private static String compileLabel(List<String> list) {
                StringBuilder builder = new StringBuilder();
                for (String s : list) {
                    builder.append(s);
                }
                return builder.toString();
            }

            public static class Locked
            extends NotifOptions {
                public Locked(int x, int width, int height, FilterList<?> list, Notification notif) {
                    super(x, width, height, list, notif, 0);
                }
            }
        }

        public static class ResponseOptions
        extends SpacedListEntry {
            public ResponseOptions(int x, int width, int height, FilterList<?> list, Response message, int index, Consumer<Integer> removeFunction) {
                int fieldSpacing = 1;
                int timeFieldWidth = class_310.method_1551().field_1772.method_1727("00000");
                int msgFieldWidth = width - timeFieldWidth - list.tinyWidgetWidth - fieldSpacing * 2;
                int movingX = x;
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.UP_DOWN.str), button -> {
                    this.method_25398(true);
                    list.startDragging(this, null, false);
                }).method_46433(x - list.smallWidgetWidth - 4, 0).method_46437(list.smallWidgetWidth, height).method_46431());
                class_5676 typeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.icon)).method_32624((Object[])Response.Type.values()).method_32616().method_32619((Object)message.type).method_32618(type -> class_7919.method_47407((class_2561)Localization.localized("option", "notif.response.type." + type.name() + ".tooltip", new Object[0]))).method_32617(movingX, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43473(), (button, type) -> {
                    message.type = type;
                    list.init();
                });
                typeButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(typeButton);
                movingX += list.tinyWidgetWidth + fieldSpacing;
                if (message.type.equals((Object)Response.Type.COMMANDKEYS)) {
                    int keyFieldWidth = msgFieldWidth / 2;
                    List<String> keys = KeyAccessor.chatnotify$getNameMap().keySet().stream().sorted().toList();
                    FakeTextField keyField1 = new FakeTextField(movingX, 0, keyFieldWidth, height, () -> {
                        int wHeight = Math.max(40, ((FilterList)list).field_22759);
                        int wWidth = Math.max(80, list.dynWideEntryWidth);
                        int wX = x + width / 2 - wWidth / 2;
                        int wY = list.method_46427();
                        list.screen.setOverlayWidget(new DropdownTextField(wX, wY, wWidth, wHeight, (class_2561)class_2561.method_43473(), () -> message.string.matches(".+-.+") ? message.string.split("-")[0] : "", val -> {
                            message.string = val + "-" + (message.string.matches(".+-.+") ? message.string.split("-")[1] : "key.keyboard.unknown");
                        }, widget -> list.init(), keys));
                    });
                    class_5250 label1 = Localization.localized("option", "notif.response.commandkeys.limit_key", new Object[0]);
                    keyField1.method_47404((class_2561)label1.method_27661());
                    keyField1.method_47400(class_7919.method_47407((class_2561)label1.method_27693("\n\n").method_10852((class_2561)Localization.localized("option", "notif.response.commandkeys.limit_key.tooltip", new Object[0]))));
                    keyField1.method_1880(240);
                    keyField1.withValidator(new TextField.Validator.InputKey(keys));
                    keyField1.method_1852(message.string.matches(".+-.+") ? message.string.split("-")[0] : "");
                    this.elements.add(keyField1);
                    FakeTextField keyField2 = new FakeTextField(movingX += keyFieldWidth, 0, keyFieldWidth, height, () -> {
                        int wHeight = Math.max(40, ((FilterList)list).field_22759);
                        int wWidth = Math.max(80, list.dynWideEntryWidth);
                        int wX = x + width / 2 - wWidth / 2;
                        int wY = list.method_46427();
                        list.screen.setOverlayWidget(new DropdownTextField(wX, wY, wWidth, wHeight, (class_2561)class_2561.method_43473(), () -> message.string.matches(".+-.+") ? message.string.split("-")[1] : "", val -> {
                            message.string = message.string.matches(".+-.+") ? message.string.split("-")[0] + "-" + val : "key.keyboard.unknown";
                        }, widget -> list.init(), keys));
                    });
                    class_5250 label2 = Localization.localized("option", "notif.response.commandkeys.key", new Object[0]);
                    keyField2.method_47404((class_2561)label2.method_27661());
                    keyField2.method_47400(class_7919.method_47407((class_2561)label2.method_27693("\n\n").method_10852((class_2561)Localization.localized("option", "notif.response.commandkeys.key.tooltip", new Object[0]))));
                    keyField2.method_1880(240);
                    keyField2.withValidator(new TextField.Validator.InputKey(keys));
                    keyField2.method_1852(message.string.matches(".+-.+") ? message.string.split("-")[1] : "");
                    this.elements.add(keyField2);
                } else {
                    MultiLineTextField msgField = new MultiLineTextField(movingX, 0, msgFieldWidth, height * 2);
                    msgField.method_44402(256);
                    msgField.method_44400(message.string);
                    msgField.method_44401(val -> {
                        message.string = val.strip();
                    });
                    this.elements.add(msgField);
                }
                TextField timeField = new TextField(x + width - timeFieldWidth, 0, timeFieldWidth, height);
                timeField.posIntValidator().strict();
                timeField.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.response.time.tooltip", new Object[0])));
                timeField.method_47402(Duration.ofMillis(500L));
                timeField.method_1880(5);
                timeField.method_1863(s -> {
                    message.delayTicks = Integer.parseInt(s.strip());
                });
                timeField.method_1852(String.valueOf(message.delayTicks));
                this.elements.add(timeField);
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.CROSS.str).method_27692(class_124.field_1061), button -> {
                    removeFunction.accept(index);
                    list.init();
                }).method_46433(x + width + 4, 0).method_46437(list.smallWidgetWidth, height).method_46431());
            }
        }

        public static class StyleTargetOptions
        extends ListEntryTrailer {
            public StyleTargetOptions(int x, int width, int height, FilterList<?> list, StyleTarget styleTarget) {
                int stringFieldWidth = width - list.tinyWidgetWidth * 4;
                int movingX = x + list.tinyWidgetWidth;
                class_7842 infoIcon = new class_7842(movingX, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43470((String)Unicode.INFO.str), class_310.method_1551().field_1772);
                infoIcon.method_48597();
                infoIcon.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.style_target.tooltip", new Object[0])));
                infoIcon.method_47402(Duration.ofMillis(500L));
                this.elements.add(infoIcon);
                class_5676 typeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.icon)).method_32624((Object[])StyleTarget.Type.values()).method_32616().method_32619((Object)styleTarget.type).method_32618(type -> class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.style_target.type." + String.valueOf(type) + ".tooltip", new Object[0]))).method_32617(movingX += list.tinyWidgetWidth, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43473(), (button, type) -> {
                    styleTarget.type = type;
                    list.init();
                });
                typeButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(typeButton);
                TextField stringField = new TextField(movingX += list.tinyWidgetWidth, 0, stringFieldWidth, height);
                if (styleTarget.type == StyleTarget.Type.REGEX) {
                    stringField.regexValidator();
                }
                stringField.method_1880(240);
                stringField.method_1852(styleTarget.string);
                stringField.method_1863(string -> {
                    styleTarget.string = string.strip();
                });
                stringField.method_47404((class_2561)Localization.localized("option", "notif.trigger.style_target.field.hint", new Object[0]));
                this.elements.add(stringField);
                movingX = x + width - list.tinyWidgetWidth;
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.CROSS.str).method_27692(class_124.field_1061), button -> {
                    styleTarget.enabled = false;
                    list.init();
                }).method_46433(movingX, 0).method_46437(list.tinyWidgetWidth, height).method_46431());
            }
        }

        public static class LockedTriggerOptions
        extends ListEntry {
            public LockedTriggerOptions(int x, int width, int height, Trigger trigger, class_2561 tooltip) {
                TextField displayField = new TextField(x, 0, width, height);
                displayField.method_1852(trigger.string);
                displayField.method_47400(class_7919.method_47407((class_2561)tooltip));
                displayField.method_47402(Duration.ofMillis(500L));
                displayField.method_1888(false);
                displayField.field_22763 = false;
                this.elements.add(displayField);
            }
        }

        public static class TriggerOptions
        extends ListEntry {
            public TriggerOptions(int x, int width, int height, FilterList<?> list, Trigger trigger, TextStyle textStyle, int index, Consumer<Integer> removeFunction, TextField.Validator validator, boolean canUseStyleTarget) {
                class_310 mc = class_310.method_1551();
                int triggerFieldWidth = width - list.tinyWidgetWidth * 2;
                if (canUseStyleTarget) {
                    triggerFieldWidth -= list.tinyWidgetWidth;
                }
                int movingX = x;
                class_4185 indicatorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)String.valueOf(index + 1)), button -> {}).method_46433(x - list.smallWidgetWidth - 4 - list.tinyWidgetWidth, 0).method_46437(list.tinyWidgetWidth, height).method_46431();
                indicatorButton.field_22763 = false;
                this.elements.add(indicatorButton);
                class_4185 dragButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.UP_DOWN.str), button -> {
                    this.method_25398(true);
                    list.startDragging(this, StyleTargetOptions.class, trigger.styleTarget.enabled);
                }).method_46433(x - list.smallWidgetWidth - 4, 0).method_46437(list.smallWidgetWidth, height).method_46431();
                dragButton.field_22763 = list.filterPattern == null;
                this.elements.add(dragButton);
                class_5676 typeButton = class_5676.method_32606(type -> class_2561.method_43470((String)type.icon)).method_32624((Object[])Trigger.Type.values()).method_32616().method_32619((Object)trigger.type).method_32618(type -> class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.type." + String.valueOf(type) + ".tooltip", new Object[0]))).method_32617(movingX, 0, list.tinyWidgetWidth, height, (class_2561)class_2561.method_43473(), (button, type) -> {
                    trigger.type = type;
                    list.init();
                });
                typeButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(typeButton);
                class_4185 editorButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.EDIT.str), button -> mc.method_1507((class_437)new TriggerScreen(mc.field_1755, trigger, textStyle, () -> {}, TriggerScreen.TabKey.TRIGGER_EDITOR.key))).method_46433(movingX += list.tinyWidgetWidth, 0).method_46437(list.tinyWidgetWidth, height).method_46431();
                editorButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.open.trigger_editor.tooltip", new Object[0])));
                editorButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(editorButton);
                TextField triggerField = new TextField(movingX += list.tinyWidgetWidth, 0, triggerFieldWidth, height);
                triggerField.withValidator(validator);
                if (trigger.type == Trigger.Type.REGEX) {
                    triggerField.regexValidator();
                }
                triggerField.method_1880(240);
                triggerField.method_1863(str -> {
                    trigger.string = str.strip();
                });
                triggerField.method_1852(trigger.string);
                triggerField.method_47404((class_2561)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                this.elements.add(triggerField);
                movingX += triggerFieldWidth;
                if (canUseStyleTarget) {
                    class_4185 styleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"+"), button -> {
                        trigger.styleTarget.enabled = true;
                        list.init();
                    }).method_46433(movingX, 0).method_46437(list.tinyWidgetWidth, height).method_46431();
                    if (!trigger.styleTarget.enabled) {
                        styleButton.method_47400(class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.style_target.add.tooltip", new Object[0])));
                        styleButton.method_47402(Duration.ofMillis(500L));
                    } else {
                        styleButton.field_22763 = false;
                    }
                    this.elements.add(styleButton);
                }
                this.elements.add(class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.CROSS.str).method_27692(class_124.field_1061), button -> {
                    removeFunction.accept(index);
                    list.init();
                }).method_46433(x + width + 4, 0).method_46437(list.smallWidgetWidth, height).method_46431());
            }
        }

        public static abstract class ListEntryTrailer
        extends Entry {
        }

        public static abstract class SpacedListEntry
        extends ListEntry {
        }

        public static abstract class ListEntry
        extends Entry {
        }

        private static class ListHeader
        extends Entry {
            ListHeader(int x, int width, int height, FilterList<?> list) {
                boolean hasStatus = list.statusSupplier != null && list.statusConsumer != null;
                int cappedWidth = Math.min(width, 320);
                if (cappedWidth < width) {
                    x += (width - cappedWidth) / 2;
                    width = cappedWidth;
                }
                int titleWidth = class_310.method_1551().field_1772.method_27525((class_5348)list.title) + 8;
                int statusButtonWidth = 25;
                int searchFieldMinWidth = 50;
                int searchFieldWidth = width - titleWidth - 4;
                if (hasStatus) {
                    searchFieldWidth -= statusButtonWidth + 4;
                }
                if (searchFieldWidth < searchFieldMinWidth) {
                    int diff = searchFieldMinWidth - searchFieldWidth;
                    searchFieldWidth += diff;
                    titleWidth -= diff;
                }
                int movingX = x;
                class_7842 titleWidget = new class_7842(movingX, 0, titleWidth, height, list.title, list.mc.field_1772);
                titleWidget.method_47400(class_7919.method_47407((class_2561)list.titleTooltip));
                this.elements.add(titleWidget);
                movingX += titleWidth + 4;
                if (hasStatus) {
                    this.elements.add(class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32616().method_32619((Object)list.statusSupplier.get()).method_32617(movingX, 0, statusButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> {
                        list.statusConsumer.accept((Boolean)status);
                        list.tabNameUpdate.run();
                    }));
                    movingX += statusButtonWidth + 4;
                }
                TextField searchField = new TextField(movingX, 0, searchFieldWidth, height);
                searchField.method_1880(64);
                searchField.method_47404((class_2561)Localization.localized("common", "search", new Object[0]));
                searchField.method_1852(list.filterString);
                searchField.method_1863(str -> {
                    list.filterString = str;
                    list.filterPattern = str.isBlank() ? null : Pattern.compile("(?iU)" + Pattern.quote(str));
                    list.refreshSubList();
                });
                this.elements.add(searchField);
            }
        }
    }
}

