/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util;

import dev.terminalmc.chatnotify.compat.commandkeys.CommandKeysWrapper;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Response;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_634;

public class ResponseUtil {
    private static final List<ScheduledResponse> RESPONSES = new ArrayList<ScheduledResponse>();

    private ResponseUtil() {
    }

    public static void send(Response response, int totalDelay) {
        RESPONSES.add(new ScheduledResponse(response, totalDelay));
    }

    public static void clear() {
        RESPONSES.clear();
    }

    public static void tickResponses(class_310 mc) {
        if (mc.method_1562() == null || !mc.method_1562().method_48106()) {
            RESPONSES.clear();
            return;
        }
        ArrayList<String> sending = new ArrayList<String>();
        RESPONSES.removeIf(sr -> {
            if (sr.tick()) {
                Response res = sr.response;
                if (res.cooldown <= 0) {
                    res.cooldown = res.cooldownTicks;
                    if (res.sendingString != null && !res.sendingString.isBlank()) {
                        if (res.type.equals((Object)Response.Type.COMMANDKEYS)) {
                            CommandKeysWrapper.trySend(res.sendingString);
                        } else {
                            sending.add(res.sendingString);
                        }
                    }
                }
                return false;
            }
            return sr.canRemove();
        });
        ResponseUtil.sendMessages(sending, mc.method_1562());
    }

    private static void sendMessages(List<String> messages, class_634 connection) {
        if (messages.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        switch (Config.get().sendMode) {
            case SCREEN: {
                Object object;
                class_437 oldScreen = mc.field_1755;
                if (!(mc.field_1755 instanceof class_408)) {
                    mc.method_1507((class_437)new class_408(""));
                }
                if ((object = mc.field_1755) instanceof class_408) {
                    class_408 cs = (class_408)object;
                    for (String msg : messages) {
                        cs.method_44056(msg, false);
                    }
                }
                mc.method_1507(oldScreen);
                break;
            }
            case PACKET: {
                for (String msg : messages) {
                    if (msg.startsWith("/")) {
                        connection.method_45730(msg.substring(1));
                        continue;
                    }
                    connection.method_45729(msg);
                }
                break;
            }
        }
    }

    private static class ScheduledResponse {
        Response response;
        int ticks;
        boolean completed;

        ScheduledResponse(Response response, int delay) {
            this.response = response;
            this.ticks = delay;
            this.completed = false;
        }

        boolean tick() {
            --this.response.cooldown;
            if (--this.ticks <= 0 && !this.completed) {
                this.completed = true;
                return true;
            }
            return false;
        }

        boolean canRemove() {
            return this.completed && this.response.cooldown <= 0;
        }
    }
}

