/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.field;

import dev.terminalmc.chatnotify.gui.widget.ExpandingList;
import dev.terminalmc.chatnotify.gui.widget.OverlayWidget;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropdownTextField
extends OverlayWidget {
    public static final int MIN_WIDTH = 80;
    public static final int MIN_HEIGHT = 40;
    public static final int MAX_WIDTH = 500;
    public static final int MAX_HEIGHT = 800;
    private final Supplier<String> supplier;
    private final Consumer<String> consumer;
    private final Collection<String> dropdownValues;
    private Function<String, DropdownWidget> dropWidgetProvider;
    private Button cancelButton;
    private Button confirmButton;
    private TextField textField;
    private ExpandingList dropdown;
    private boolean suppressUpdate;
    @Nullable
    private String oldVal = null;

    public DropdownTextField(int x, int y, int width, int height, Component msg, Supplier<String> supplier, Consumer<String> consumer, Consumer<OverlayWidget> close, Collection<String> dropdownValues) {
        super(x, y, width, height, false, msg, close);
        this.supplier = supplier;
        this.consumer = consumer;
        this.dropdownValues = dropdownValues;
        this.dropWidgetProvider = this::createDefaultDropWidget;
        this.init();
    }

    @Override
    protected void init() {
        Minecraft mc = Minecraft.getInstance();
        int x = this.getX();
        int y = this.getY();
        int widgetHeight = 20;
        int verticalSpace = 1;
        int buttonWidth = 20;
        int textFieldWidth = this.width - 2 * widgetHeight;
        this.cancelButton = Button.builder((Component)Component.literal((String)Unicode.CROSS.str).withStyle(ChatFormatting.RED), button -> this.onClose()).pos(x + this.width - buttonWidth * 2, y).size(buttonWidth, widgetHeight).build();
        this.confirmButton = Button.builder((Component)Component.literal((String)Unicode.CHECK.str).withStyle(ChatFormatting.GREEN), button -> {
            this.consumer.accept(this.textField.getValue());
            this.onClose();
        }).pos(x + this.width - buttonWidth, y).size(buttonWidth, widgetHeight).build();
        this.textField = new TextField(x, y, textFieldWidth, widgetHeight);
        Objects.requireNonNull(mc.font);
        Objects.requireNonNull(mc.font);
        this.dropdown = new ExpandingList(x, y + widgetHeight + verticalSpace, this.width, this.height - widgetHeight - verticalSpace, 9, 9, 2);
        this.textField.setMaxLength(240);
        this.textField.setResponder(this::valueResponder);
        this.textField.setValue(this.oldVal == null ? this.supplier.get() : this.oldVal);
        this.textField.setFocused(true);
    }

    @Override
    public int getMinWidth() {
        return 80;
    }

    @Override
    public int getMaxWidth() {
        return 500;
    }

    @Override
    public int getMinHeight() {
        return 40;
    }

    @Override
    public int getMaxHeight() {
        return 800;
    }

    private DropdownWidget createDefaultDropWidget(String str) {
        int n = this.textField.getX();
        int n2 = this.textField.getY() + this.textField.getHeight();
        int n3 = this.textField.getWidth();
        Objects.requireNonNull(Minecraft.getInstance().font);
        return new DropdownWidget(n, n2, n3, 9 + 2, (Component)Component.literal((String)str), Minecraft.getInstance().font, this::tabComplete);
    }

    public DropdownTextField withSoundDropType() {
        this.dropWidgetProvider = this::createSoundDropWidget;
        this.init();
        return this;
    }

    private SoundDropdownWidget createSoundDropWidget(String str) {
        int n = this.textField.getX();
        int n2 = this.textField.getY() + this.textField.getHeight();
        int n3 = this.textField.getWidth();
        Objects.requireNonNull(Minecraft.getInstance().font);
        return new SoundDropdownWidget(n, n2, n3, 9 + 2, (Component)Component.literal((String)str), Minecraft.getInstance().font, this::tabComplete);
    }

    private void tabComplete(String str) {
        this.suppressUpdate = true;
        this.textField.setValue(str);
        this.suppressUpdate = false;
    }

    private void valueResponder(String str) {
        this.oldVal = str;
        if (!this.suppressUpdate) {
            this.dropdown.highlightIndex = -1;
            this.dropdown.clearWidgets();
            this.dropdown.setScrollAmount(0.0);
            for (String suggestion : this.dropdownValues) {
                if (!suggestion.contains(str) || suggestion.equals(str)) continue;
                StringWidget widget = this.dropWidgetProvider.apply(suggestion);
                widget.alignLeft();
                this.dropdown.addWidget((AbstractWidget)widget);
            }
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.textField.isFocused()) {
            if (!this.dropdown.isEmpty()) {
                if (keyCode == 258) {
                    if (Screen.hasShiftDown()) {
                        this.tabUp();
                    } else {
                        this.tabDown();
                    }
                    return true;
                }
                if (keyCode == 265) {
                    this.tabUp();
                    return true;
                }
                if (keyCode == 264) {
                    this.tabDown();
                    return true;
                }
            }
            return this.textField.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private void tabUp() {
        if (--this.dropdown.highlightIndex < 0) {
            this.dropdown.highlightIndex = this.dropdown.size() - 1;
        }
        this.dropdown.ensureVisible(this.dropdown.highlightIndex);
        this.tabComplete(this.dropdown.get(this.dropdown.highlightIndex).getMessage().getString());
    }

    private void tabDown() {
        if (++this.dropdown.highlightIndex >= this.dropdown.size()) {
            this.dropdown.highlightIndex = 0;
        }
        this.dropdown.ensureVisible(this.dropdown.highlightIndex);
        this.tabComplete(this.dropdown.get(this.dropdown.highlightIndex).getMessage().getString());
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.textField.isFocused()) {
            return this.textField.charTyped(chr, modifiers);
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.mouseOnWidget(this, mouseX, mouseY)) {
            if (this.mouseOnWidget((AbstractWidget)this.textField, mouseX, mouseY)) {
                if (!this.textField.isFocused()) {
                    this.textField.setFocused(true);
                } else {
                    this.textField.mouseClicked(mouseX, mouseY, button);
                }
            } else if (this.textField.isFocused() && this.mouseOnWidget((AbstractWidget)this.dropdown, mouseX, mouseY)) {
                this.dropdown.mouseClicked(mouseX, mouseY, button);
            } else {
                this.textField.setFocused(false);
                if (button == 0) {
                    if (this.mouseOnWidget((AbstractWidget)this.cancelButton, mouseX, mouseY)) {
                        this.cancelButton.mouseClicked(mouseX, mouseY, button);
                    } else if (this.mouseOnWidget((AbstractWidget)this.confirmButton, mouseX, mouseY)) {
                        this.confirmButton.mouseClicked(mouseX, mouseY, button);
                    }
                }
            }
        } else {
            this.cancelButton.onPress();
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.textField.isFocused() && this.mouseOnWidget((AbstractWidget)this.textField, mouseX, mouseY)) {
            return this.textField.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        }
        this.dropdown.setFocused(null);
        return this.dropdown.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.textField.isFocused() && this.mouseOnWidget((AbstractWidget)this.dropdown, mouseX, mouseY)) {
            return this.dropdown.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
        }
        return false;
    }

    private boolean mouseOnWidget(AbstractWidget widget, double mouseX, double mouseY) {
        return (double)widget.getX() <= mouseX && mouseX < (double)(widget.getX() + widget.getWidth()) && (double)widget.getY() <= mouseY && mouseY < (double)(widget.getY() + widget.getHeight());
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.textField.renderWidget(graphics, mouseX, mouseY, delta);
        this.cancelButton.render(graphics, mouseX, mouseY, delta);
        this.confirmButton.render(graphics, mouseX, mouseY, delta);
        if (this.textField.isFocused() && !this.dropdown.isEmpty()) {
            this.dropdown.renderWidget(graphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        if (SoundDropdownWidget.lastSound != null) {
            Minecraft.getInstance().getSoundManager().stop(SoundDropdownWidget.lastSound);
        }
    }

    public static class DropdownWidget
    extends StringWidget {
        private final Consumer<String> consumer;

        private DropdownWidget(int x, int y, int width, int height, Component msg, Font font, Consumer<String> consumer) {
            super(x, y, width, height, msg, font);
            this.active = true;
            this.consumer = consumer;
        }

        public static DropdownWidget create(int x, int y, int width, int height, Component msg, Font font, Consumer<String> dest) {
            return new DropdownWidget(x, y, width, height, msg, font, dest);
        }

        public void onClick(double mouseX, double mouseY) {
            this.consumer.accept(this.getMessage().getString());
        }
    }

    public static class SoundDropdownWidget
    extends DropdownWidget {
        @Nullable
        private static SoundInstance lastSound;

        private SoundDropdownWidget(int x, int y, int width, int height, Component msg, Font font, Consumer<String> consumer) {
            super(x, y, width, height, msg, font, consumer);
        }

        public static SoundDropdownWidget create(int x, int y, int width, int height, Component msg, Font font, Consumer<String> consumer) {
            return new SoundDropdownWidget(x, y, width, height, msg, font, consumer);
        }

        public void playDownSound(@NotNull SoundManager soundManager) {
            if (lastSound != null) {
                soundManager.stop(lastSound);
            }
            lastSound = new SimpleSoundInstance(ResourceLocation.parse((String)this.getMessage().getString()), SoundSource.MASTER, 1.0f, 1.0f, SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
            soundManager.play(lastSound);
        }
    }
}

