/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.field;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.text.ColorUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextField
extends EditBox {
    public static final long CLICK_CHAIN_TIME = 250L;
    public static final int TEXT_COLOR_DEFAULT = 0xE0E0E0;
    public static final int TEXT_COLOR_ERROR = 0xFF5555;
    public static final int TEXT_COLOR_HINT = 0x555555;
    public static final int TEXT_COLOR_PREVIEW = 0xAAAAAA;
    private final Font font;
    public final List<@NotNull Validator> validators = new ArrayList<Validator>();
    public boolean lenient = true;
    private int normalTextColor = 0xE0E0E0;
    @Nullable
    private Tooltip normalTooltip;
    @Nullable
    private Tooltip errorTooltip;
    private final List<String> history = new ArrayList<String>();
    private int historyIndex = -1;
    private double dragOriginX;
    private int dragOriginPos;
    private long lastClickTime;
    private int chainedClicks;

    public TextField(int x, int y, int width, int height) {
        this(Minecraft.getInstance().font, x, y, width, height, (Component)Component.empty(), null);
    }

    public TextField(int x, int y, int width, int height, @Nullable Validator validator) {
        this(Minecraft.getInstance().font, x, y, width, height, (Component)Component.empty(), validator);
    }

    public TextField(Font font, int x, int y, int width, int height, Component msg, @Nullable Validator validator) {
        super(font, x, y, width, height, msg);
        this.font = font;
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    public TextField withValidator(@NotNull Validator validator) {
        this.validators.add(validator);
        return this;
    }

    public TextField regexValidator() {
        this.validators.add(new Validator.Regex());
        return this;
    }

    public TextField hexColorValidator() {
        this.validators.add(new Validator.HexColor());
        return this;
    }

    public TextField soundValidator() {
        this.validators.add(new Validator.Sound());
        return this;
    }

    public TextField posIntValidator() {
        this.validators.add(new Validator.PosInt());
        return this;
    }

    public TextField strict() {
        this.lenient = false;
        return this;
    }

    public TextField lenient() {
        this.lenient = true;
        return this;
    }

    public void setResponder(@NotNull Consumer<String> responder) {
        super.setResponder(str -> {
            this.updateHistory((String)str);
            if (this.validate((String)str) || this.lenient) {
                responder.accept((String)str);
            }
        });
    }

    private boolean validate(String str) {
        for (Validator v : this.validators) {
            Optional<Component> error = v.validate(str);
            if (!error.isPresent()) continue;
            this.errorTooltip = Tooltip.create((Component)error.get());
            super.setTooltip(this.errorTooltip);
            super.setTextColor(0xFF5555);
            return false;
        }
        this.errorTooltip = null;
        super.setTextColor(this.normalTextColor);
        super.setTooltip(this.normalTooltip);
        return true;
    }

    public void setHint(@NotNull Component hint) {
        super.setHint((Component)hint.copy().withColor(0x555555));
    }

    public void setTooltip(@Nullable Tooltip tooltip) {
        this.normalTooltip = tooltip;
        if (this.errorTooltip == null) {
            super.setTooltip(tooltip);
        }
    }

    public void setTextColor(int color) {
        this.normalTextColor = color;
        if (this.errorTooltip == null) {
            super.setTextColor(color);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            long time = Util.getMillis();
            if (this.lastClickTime + 250L > time) {
                switch (++this.chainedClicks) {
                    case 1: {
                        int pos;
                        int start = pos = this.getCursorPosition();
                        if (pos < 0) {
                            start = 0;
                        } else if (pos >= this.getValue().length() || this.getValue().charAt(pos) == ' ' || pos > 0 && this.getValue().charAt(pos - 1) != ' ') {
                            start = this.getWordPosition(-1);
                        }
                        int end = this.getWordPosition(1);
                        this.moveCursorTo(start, false);
                        this.moveCursorTo(end, true);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.moveCursorToEnd(false);
                        this.setHighlightPos(0);
                        break;
                    }
                    case 4: {
                        this.chainedClicks = 0;
                        this.setHighlightPos(this.getCursorPosition());
                    }
                }
            } else {
                this.chainedClicks = 0;
            }
            this.lastClickTime = time;
            this.dragOriginX = mouseX;
            this.dragOriginPos = this.getCursorPosition();
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button != 0) {
            return false;
        }
        String str = this.getValue();
        if (mouseX < this.dragOriginX) {
            String subLeft = str.substring(0, this.dragOriginPos);
            int offsetChars = this.font.plainSubstrByWidth(subLeft, Mth.floor((double)(this.dragOriginX - mouseX)), true).length();
            this.moveCursorTo(this.dragOriginPos - offsetChars, true);
        } else {
            String subRight = str.substring(this.dragOriginPos);
            int offsetChars = this.font.plainSubstrByWidth(subRight, Mth.floor((double)(mouseX - this.dragOriginX)), false).length();
            this.moveCursorTo(this.dragOriginPos + offsetChars, true);
        }
        return true;
    }

    private void updateHistory(String str) {
        if (this.historyIndex == -1 || !this.history.get(this.historyIndex).equals(str)) {
            if (this.historyIndex < this.history.size() - 1) {
                for (int i = this.history.size() - 1; i > this.historyIndex; --i) {
                    this.history.removeLast();
                }
            }
            this.history.add(str);
            ++this.historyIndex;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!super.keyPressed(keyCode, scanCode, modifiers)) {
            if (TextField.isUndo(keyCode)) {
                this.undo();
                return true;
            }
            if (TextField.isRedo(keyCode)) {
                this.redo();
                return true;
            }
            return false;
        }
        return true;
    }

    private void undo() {
        if (this.historyIndex > 0) {
            this.setValue(this.history.get(--this.historyIndex));
        }
    }

    private void redo() {
        if (this.historyIndex < this.history.size() - 1) {
            this.setValue(this.history.get(++this.historyIndex));
        }
    }

    public static boolean isUndo(int keyCode) {
        return keyCode == 90 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public static boolean isRedo(int keyCode) {
        return keyCode == 89 && Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown();
    }

    public static String fixRegexMessage(String str) {
        Matcher indexMatcher;
        if ((str = str.replaceAll("\\n", "")).endsWith("^") && (indexMatcher = Pattern.compile("near index (\\d+)\n").matcher(str)).find()) {
            Font font = Minecraft.getInstance().font;
            int index = Integer.parseInt(indexMatcher.group(1));
            int startPos = indexMatcher.end();
            int cursorPos = startPos + index;
            int cursorOffset = font.width(str.substring(startPos, cursorPos));
            char[] charArray = new char[cursorOffset / font.width(" ")];
            Arrays.fill(charArray, ' ');
            String newSpace = new String(charArray);
            Matcher cursorMatcher = Pattern.compile("\n( *\\^)$").matcher(str);
            if (cursorMatcher.find(cursorPos)) {
                String cursorLine = cursorMatcher.group(1);
                str = str.replaceAll(Pattern.quote(cursorLine) + "$", newSpace + "^");
            }
        }
        return str;
    }

    @FunctionalInterface
    public static interface Validator {
        public Optional<Component> validate(String var1);

        public static class UniqueTrigger
        implements Validator {
            final Notification notif;
            final Trigger trigger;
            final Type type;

            public UniqueTrigger(Notification notif, Trigger trigger) {
                this(notif, trigger, Type.MAIN);
            }

            private UniqueTrigger(Notification notif, Trigger trigger, Type type) {
                this.notif = notif;
                this.trigger = trigger;
                this.type = type;
            }

            public static UniqueTrigger inclusion(Notification notif, Trigger trigger) {
                return new UniqueTrigger(notif, trigger, Type.INCLUSION);
            }

            public static UniqueTrigger exclusion(Notification notif, Trigger trigger) {
                return new UniqueTrigger(notif, trigger, Type.EXCLUSION);
            }

            @Override
            public Optional<Component> validate(String str) {
                if (str.isBlank()) {
                    return Optional.empty();
                }
                MutableComponent err = Component.empty().withStyle(ChatFormatting.RED);
                boolean hasErr = this.checkTriggers(err, false, this.notif.triggers, str, "");
                if (this.notif.inclusionEnabled) {
                    boolean bl = hasErr = this.checkTriggers(err, hasErr, this.notif.inclusionTriggers, str, ".inclusion") || hasErr;
                }
                if (this.notif.exclusionEnabled) {
                    boolean bl = hasErr = this.checkTriggers(err, hasErr, this.notif.exclusionTriggers, str, ".exclusion") || hasErr;
                }
                if (!(this.type != Type.MAIN || this.notif.inclusionEnabled && !this.notif.inclusionTriggers.isEmpty() || this.notif.exclusionEnabled && !this.notif.exclusionTriggers.isEmpty())) {
                    hasErr = this.checkOtherNotifs(err, hasErr, str);
                }
                return hasErr ? Optional.of(err) : Optional.empty();
            }

            private boolean checkOtherNotifs(MutableComponent err, boolean hasErr, String str) {
                int i = 0;
                for (Notification n : Config.get().getNotifs()) {
                    ++i;
                    if (n == this.notif || !n.enabled || n.inclusionEnabled && !n.inclusionTriggers.isEmpty() || n.exclusionEnabled && !n.exclusionTriggers.isEmpty()) continue;
                    int j = 0;
                    for (Trigger t : n.triggers) {
                        ++j;
                        if (t.type != this.trigger.type || !t.string.equals(str)) continue;
                        if (hasErr) {
                            err.append("\n");
                        }
                        err.append((Component)Localization.localized("ui", "field.error.trigger.duplicate", Component.literal((String)String.valueOf(j)).withStyle(ChatFormatting.GOLD), Component.literal((String)String.valueOf(i)).withStyle(ChatFormatting.GOLD)));
                        return true;
                    }
                }
                return hasErr;
            }

            private boolean checkTriggers(MutableComponent err, boolean hasErr, List<Trigger> triggers, String str, String errKey) {
                int i = 0;
                for (Trigger t : triggers) {
                    ++i;
                    if (t.equals(this.trigger) || t.type != this.trigger.type || !t.string.equals(str)) continue;
                    if (hasErr) {
                        err.append("\n");
                    }
                    err.append((Component)Localization.localized("ui", "field.error.trigger.duplicate.here" + errKey, Component.literal((String)String.valueOf(i)).withStyle(ChatFormatting.GOLD)));
                    return true;
                }
                return hasErr;
            }

            private static enum Type {
                MAIN,
                INCLUSION,
                EXCLUSION;

            }
        }

        public static class InputKey
        implements Validator {
            List<String> keys;

            public InputKey(List<String> keys) {
                this.keys = keys;
            }

            @Override
            public Optional<Component> validate(String str) {
                if (this.keys.contains(str)) {
                    return Optional.empty();
                }
                return Optional.of(Localization.localized("ui", "field.error.input_key", new Object[0]).withStyle(ChatFormatting.RED));
            }
        }

        public static class PosInt
        implements Validator {
            @Override
            public Optional<Component> validate(String str) {
                try {
                    if (Integer.parseInt(str) < 0) {
                        throw new NumberFormatException();
                    }
                    return Optional.empty();
                }
                catch (NumberFormatException ignored) {
                    return Optional.of(Localization.localized("ui", "field.error.pos_int", new Object[0]).withStyle(ChatFormatting.RED));
                }
            }
        }

        public static class Sound
        implements Validator {
            private final Set<String> sounds = new HashSet<String>(Minecraft.getInstance().getSoundManager().getAvailableSounds().stream().map(ResourceLocation::toString).toList());

            @Override
            public Optional<Component> validate(String str) {
                if (this.sounds.contains(str) || !str.contains(":") && this.sounds.contains("minecraft:" + str)) {
                    return Optional.empty();
                }
                return Optional.of(Localization.localized("ui", "field.error.sound", new Object[0]).withStyle(ChatFormatting.RED));
            }
        }

        public static class HexColor
        implements Validator {
            @Override
            public Optional<Component> validate(String str) {
                if (ColorUtil.parseColor(str) != null) {
                    return Optional.empty();
                }
                return Optional.of(Localization.localized("ui", "field.error.color", new Object[0]).withStyle(ChatFormatting.RED));
            }
        }

        public static class Regex
        implements Validator {
            @Override
            public Optional<Component> validate(String str) {
                try {
                    Pattern.compile(str);
                    return Optional.empty();
                }
                catch (PatternSyntaxException e) {
                    return Optional.of(Component.literal((String)TextField.fixRegexMessage(e.getMessage())).withStyle(ChatFormatting.RED));
                }
            }
        }
    }
}

