/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.mixin;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientPacketListener.class}, priority=792)
public class ClientPacketListenerMixin {
    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    private void getProfileName(ClientboundLoginPacket packet, CallbackInfo ci) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        String name = FormatUtil.stripCodes(Minecraft.getInstance().player.getName().getString());
        Config.get().setProfileName(name);
        Config.get().setDisplayName(name);
    }

    @Inject(method={"applyPlayerInfoUpdate"}, at={@At(value="TAIL")})
    private void getDisplayName(ClientboundPlayerInfoUpdatePacket.Action action, ClientboundPlayerInfoUpdatePacket.Entry entry, PlayerInfo playerInfo, CallbackInfo ci) {
        if (Minecraft.getInstance().player == null) {
            return;
        }
        if (action.equals((Object)ClientboundPlayerInfoUpdatePacket.Action.UPDATE_DISPLAY_NAME) && playerInfo.getProfile().getId().equals(Minecraft.getInstance().player.getUUID()) && entry.displayName() != null) {
            Config.get().setDisplayName(FormatUtil.stripCodes(entry.displayName().getString()));
        }
    }

    @Inject(method={"sendChat"}, at={@At(value="HEAD")})
    private void getMessage(String message, CallbackInfo ci) {
        this.chatnotify$storeMessage(message);
    }

    @Inject(method={"sendCommand"}, at={@At(value="HEAD")})
    private void getCommand(String command, CallbackInfo ci) {
        this.chatnotify$storeCommand(command);
    }

    @Inject(method={"sendUnsignedCommand"}, at={@At(value="HEAD")})
    private void getUnsignedCommand(String command, CallbackInfoReturnable<Boolean> cir) {
        this.chatnotify$storeCommand(command);
    }

    @Unique
    private void chatnotify$storeMessage(String message) {
        long time = System.nanoTime();
        this.chatnotify$removeOldMessages(time);
        String plainMsg = "";
        for (String prefix : Config.get().prefixes) {
            if (!message.startsWith(prefix)) continue;
            plainMsg = message.replaceFirst(prefix, "").strip();
            break;
        }
        ChatNotify.recentMessages.add((Pair<Long, String>)Pair.of((Object)(time + 5000000000L), (Object)(plainMsg.isEmpty() ? message : plainMsg)));
    }

    @Unique
    private void chatnotify$storeCommand(String command) {
        long time = System.currentTimeMillis();
        this.chatnotify$removeOldMessages(time);
        command = "/" + (String)command;
        for (String prefix : Config.get().prefixes) {
            if (!((String)command).startsWith(prefix)) continue;
            if (((String)(command = ((String)command).replaceFirst(prefix, "").strip())).isEmpty()) break;
            ChatNotify.recentMessages.add((Pair<Long, String>)Pair.of((Object)(time + 5000000000L), (Object)command));
            break;
        }
    }

    @Unique
    private void chatnotify$removeOldMessages(long time) {
        ChatNotify.recentMessages.removeIf(pair -> (Long)pair.getFirst() < time);
    }
}

