/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.ModLogger;
import dev.terminalmc.chatnotify.util.ResponseUtil;
import dev.terminalmc.chatnotify.util.TimingUtil;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;

public class ChatNotify {
    public static final String MOD_ID = "chatnotify";
    public static final String MOD_NAME = "ChatNotify";
    public static final ModLogger LOG = new ModLogger("ChatNotify");
    public static boolean hasResetConfig = false;
    public static final List<Pair<Long, String>> recentMessages = new ArrayList<Pair<Long, String>>();
    public static final Queue<Component> unmodifiedChat = new LinkedList<Component>();

    public static void init() {
        Config.getAndSave();
    }

    public static void onConfigSaved(Config config) {
        for (Notification notif : config.getNotifs()) {
            for (Trigger trig : notif.triggers) {
                if (trig.type == Trigger.Type.REGEX) {
                    trig.tryCompilePattern();
                }
                if (trig.styleTarget.type == StyleTarget.Type.REGEX) {
                    trig.styleTarget.tryCompilePattern();
                    continue;
                }
                if (trig.styleTarget.type != StyleTarget.Type.CAPTURING) continue;
                trig.styleTarget.tryParseIndexes();
            }
            for (Trigger trig : notif.exclusionTriggers) {
                if (trig.type != Trigger.Type.REGEX) continue;
                trig.tryCompilePattern();
            }
        }
    }

    public static void afterClientTick(Minecraft mc) {
        ResponseUtil.tickResponses(mc);
        TimingUtil.tickActions();
        if (hasResetConfig && mc.screen instanceof TitleScreen) {
            hasResetConfig = false;
            mc.getToastManager().addToast((Toast)new SystemToast(new SystemToast.SystemToastId(15000L), (Component)Localization.localized("toast", "reset.title", new Object[0]), (Component)Localization.localized("toast", "reset.message", Component.literal((String)"chatnotify.unreadable.json").withStyle(ChatFormatting.GOLD))));
        }
    }

    public static void updateUsernameNotif(Config config) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            config.setProfileName(FormatUtil.stripCodes(mc.player.getName().getString()));
            config.setDisplayName(FormatUtil.stripCodes(mc.player.getDisplayName().getString()));
        }
    }
}

