/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.screen;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.gui.widget.HorizontalList;
import dev.terminalmc.chatnotify.gui.widget.OverlayWidget;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.ScreenAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.OptionsSubScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionScreen
extends OptionsSubScreen {
    public static final int HEADER_MARGIN = 32;
    public static final int FOOTER_MARGIN = 32;
    public static final int BASE_ROW_WIDTH = 320;
    public static final int SCROLL_BAR_MARGIN = 20;
    public static final int ELEMENT_SPACING = 4;
    public static final int ELEMENT_SPACING_NARROW = 2;
    public static final int ELEMENT_SPACING_FINE = 1;
    public static final int LIST_ENTRY_HEIGHT = 20;
    public static final int LIST_ENTRY_SPACING = 5;
    public static final int HANGING_WIDGET_MARGIN = 24;
    public static final int BASE_LIST_ENTRY_WIDTH = 232;
    public static final int TAB_LIST_HEIGHT = 28;
    public static final int TAB_LIST_Y = 2;
    public static final int TAB_LIST_MARGIN = 24;
    public static final int MIN_TAB_WIDTH = 40;
    public static final int MAX_TAB_WIDTH = 120;
    public static final int TAB_HEIGHT = 20;
    public static final int TAB_SPACING = 4;
    protected final Map<String, Button> tabLookup = new HashMap<String, Button>();
    protected final HorizontalList<Button> tabs = new HorizontalList(24, 2, this.width - 48, 28, 4, true);
    @Nullable
    private OptionList list;
    @Nullable
    private OverlayWidget overlay = null;

    public OptionScreen(Screen lastScreen) {
        super(lastScreen, Minecraft.getInstance().options, (Component)Component.empty());
    }

    protected void init() {
        this.clearWidgets();
        this.clearFocus();
        this.addHeader();
        this.addContents();
        this.addFooter();
        this.addOverlay();
        this.setInitialFocus();
    }

    public void resize(@NotNull Minecraft mc, int width, int height) {
        this.width = width;
        this.height = height;
        this.init();
    }

    protected void addHeader() {
        this.tabs.setWidth(this.width - 48);
        this.addRenderableWidget((GuiEventListener)this.tabs);
    }

    protected void addContents() {
        if (this.list != null) {
            this.list.updateSizeAndPosition(this.width, this.height - 32 - 32, 32);
            this.addRenderableWidget((GuiEventListener)this.list);
        }
    }

    protected void addFooter() {
        int w = 232;
        int h = 20;
        int x = this.width / 2 - w / 2;
        int y = Math.min(this.height - h, this.height - 16 - h / 2);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).pos(x, y).size(w, h).build());
    }

    protected void addOverlay() {
        if (this.overlay != null) {
            this.overlay.updateBounds(this.width, this.height);
            this.setOverlay(this.overlay);
        }
    }

    protected void addOptions() {
    }

    public void onClose() {
        Screen screen = this.lastScreen;
        if (screen instanceof OptionScreen) {
            OptionScreen screen2 = (OptionScreen)screen;
            screen2.resize(Minecraft.getInstance(), this.width, this.height);
        }
        super.onClose();
    }

    protected void setTabs(List<Tab> tabList, String defaultKey) {
        if (tabList.isEmpty()) {
            throw new IllegalArgumentException("Tab list cannot be empty!");
        }
        int defaultIndex = -1;
        int i = 0;
        for (Tab tab : tabList) {
            if (this.tabLookup.containsKey(tab.key)) {
                ChatNotify.LOG.error("Duplicate tab found with key '{}'!", tab.key);
                continue;
            }
            MutableComponent title = Component.translatable((String)tab.key);
            Button button = Button.builder((Component)title, b -> {
                this.tabs.entries().forEach(b2 -> {
                    b2.active = true;
                });
                b.active = false;
                this.setList(tab.getList(this));
            }).size(Math.clamp((long)(Minecraft.getInstance().font.width((FormattedText)title) + 8), 40, 120), 20).build();
            this.tabLookup.put(tab.key, button);
            this.tabs.addEntry(button);
            if (defaultIndex == -1 && tab.key.equals(defaultKey)) {
                defaultIndex = i;
                continue;
            }
            ++i;
        }
        if (defaultIndex == -1) {
            defaultIndex = 0;
        }
        this.tabs.getEntry((int)defaultIndex).active = false;
        this.list = tabList.get(defaultIndex).getList(this);
    }

    private void setList(@NotNull OptionList list) {
        this.list = list;
        this.init();
    }

    public void updateTabTitle(String key, Component title) {
        Button button = this.tabLookup.get(key);
        if (button != null) {
            button.setMessage(title);
            button.setWidth(Math.clamp((long)(Minecraft.getInstance().font.width((FormattedText)title) + 8), 40, 120));
        }
    }

    public void setOverlayWidget(OverlayWidget widget) {
        widget.addOnClose(w -> this.removeOverlay());
        this.setOverlay(widget);
    }

    private void setOverlay(OverlayWidget widget) {
        this.removeOverlay();
        this.overlay = widget;
        this.setChildrenVisible(false);
        ((ScreenAccessor)((Object)this)).chatnotify$getChildren().addFirst((GuiEventListener)widget);
        ((ScreenAccessor)((Object)this)).chatnotify$getNarratables().addFirst((NarratableEntry)widget);
        ((ScreenAccessor)((Object)this)).chatnotify$getRenderables().addLast((Renderable)widget);
    }

    public void removeOverlay() {
        if (this.overlay != null) {
            this.removeWidget((GuiEventListener)this.overlay);
            this.overlay = null;
            this.setChildrenVisible(true);
        }
    }

    private void setChildrenVisible(boolean visible) {
        for (GuiEventListener listener : this.children()) {
            if (!(listener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)listener;
            widget.visible = visible;
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.overlay != null) {
            if (keyCode == 256) {
                this.overlay.onClose();
                this.removeOverlay();
            } else {
                this.overlay.keyPressed(keyCode, scanCode, modifiers);
            }
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.overlay != null) {
            this.overlay.charTyped(chr, modifiers);
            return true;
        }
        return super.charTyped(chr, modifiers);
    }

    public static class Tab {
        final String key;
        private final Function<OptionScreen, OptionList> supplier;
        @Nullable
        private OptionList list = null;

        public Tab(String key, Function<OptionScreen, OptionList> supplier) {
            this.key = key;
            this.supplier = supplier;
        }

        @NotNull
        public OptionList getList(OptionScreen screen) {
            if (this.list == null) {
                this.list = this.supplier.apply(screen);
            }
            return this.list;
        }
    }
}

