/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HorizontalList<E extends AbstractWidget>
extends AbstractContainerWidget {
    private static final ResourceLocation LEFT_SEPARATOR = ResourceLocation.fromNamespaceAndPath((String)"chatnotify", (String)"textures/gui/left_separator.png");
    private static final ResourceLocation RIGHT_SEPARATOR = ResourceLocation.fromNamespaceAndPath((String)"chatnotify", (String)"textures/gui/right_separator.png");
    private static final ResourceLocation MENU_LIST_BACKGROUND = ResourceLocation.withDefaultNamespace((String)"textures/gui/menu_list_background.png");
    private static final ResourceLocation SCROLLER_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"chatnotify", (String)"widget/scroller_horizontal");
    private static final ResourceLocation SCROLLER_BACKGROUND_SPRITE = ResourceLocation.fromNamespaceAndPath((String)"chatnotify", (String)"widget/scroller_background_horizontal");
    private static final int SCROLLBAR_WIDTH = 32;
    private static final int SCROLLBAR_HEIGHT = 6;
    private static final int MIN_WIDTH = 64;
    private static final int MIN_HEIGHT = 26;
    private final List<E> entries = new ArrayList();
    private final Minecraft mc;
    private final int space;
    public Snap snap = Snap.BOTTOM;
    public boolean topScrollbar;
    private boolean scrolling;
    private double scrollAmount;
    @Nullable
    private E hovered;
    @Nullable
    private E selected;

    public HorizontalList(int x, int y, int width, int height, int spacing, boolean topScrollbar) {
        super(x, y, width, height, (Component)Component.empty());
        this.space = spacing;
        this.mc = Minecraft.getInstance();
        this.topScrollbar = topScrollbar;
    }

    @Nullable
    public E getHovered() {
        return this.hovered;
    }

    private void updateHovered(double mouseX, double mouseY) {
        if (this.isMouseOver(mouseX, mouseY)) {
            for (AbstractWidget e : this.entries) {
                if (!e.isMouseOver(mouseX, mouseY)) continue;
                this.hovered = e;
                return;
            }
        }
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        if (!this.entries.contains(selected)) {
            throw new IllegalArgumentException("Specified entry is not present in the list.");
        }
        this.selected = selected;
    }

    public int numEntries() {
        return this.entries.size();
    }

    @NotNull
    public List<E> entries() {
        return Collections.unmodifiableList(this.entries);
    }

    public E getEntry(int index) {
        return (E)((AbstractWidget)this.entries.get(index));
    }

    public int addEntry(E entry) {
        this.entries.add(entry);
        return this.entries.size() - 1;
    }

    public boolean removeEntry(E entry) {
        boolean removed = this.entries.remove(entry);
        if (removed && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return removed;
    }

    public void clearEntries() {
        this.entries.clear();
        this.setSelected(null);
    }

    public void setWidth(int width) {
        this.setSize(width, this.getHeight());
    }

    public void setHeight(int height) {
        this.setSize(this.getWidth(), height);
    }

    public void setSize(int width, int height) {
        super.setSize(Math.max(width, 64), Math.max(height, 26));
        this.refreshScrollAmount();
    }

    public void setBounds(int width, int height, int x, int y) {
        this.setSize(width, height);
        this.setPosition(x, y);
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.renderListBackground(graphics);
        this.renderChildren(graphics, mouseX, mouseY, partialTick);
        this.renderScrollbar(graphics);
        this.renderSeparators(graphics);
        this.updateHovered(mouseX, mouseY);
    }

    protected void renderListBackground(GuiGraphics graphics) {
        RenderSystem.enableBlend();
        graphics.blit(RenderType::guiTextured, MENU_LIST_BACKGROUND, this.getX(), this.getY(), 0.0f, 0.0f, this.getWidth(), this.getHeight(), 32, 32);
        RenderSystem.disableBlend();
    }

    protected void renderChildren(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
        int x = this.getX() - (int)this.scrollAmount;
        int topOffset = this.topScrollbar ? 6 : 0;
        int bottomOffset = this.topScrollbar ? 0 : 6;
        for (AbstractWidget child : this.entries) {
            int y = switch (this.snap.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> this.getY() + topOffset;
                case 1 -> this.getY() + (this.getHeight() - child.getHeight()) / 2;
                case 2 -> this.getY() + this.getHeight() - child.getHeight() - bottomOffset;
            };
            child.setPosition(x, y);
            if (child.getRight() > this.getX() && child.getX() < this.getRight()) {
                child.render(graphics, mouseX, mouseY, partialTick);
            }
            x += child.getWidth() + this.space;
        }
        graphics.disableScissor();
    }

    protected void renderScrollbar(@NotNull GuiGraphics graphics) {
        if (this.scrollbarVisible()) {
            int y = this.scrollBarX();
            int scrollerWidth = (int)((float)(this.getWidth() * this.getWidth()) / (float)this.getMaxPosition());
            scrollerWidth = Mth.clamp((int)scrollerWidth, (int)32, (int)this.getWidth());
            int scrollerPos = Math.max(this.getX(), (int)this.scrollAmount * (this.getWidth() - scrollerWidth) / this.getMaxScroll() + this.getX());
            RenderSystem.enableBlend();
            graphics.blitSprite(RenderType::guiTextured, SCROLLER_BACKGROUND_SPRITE, this.getX(), y, this.getWidth(), 6);
            graphics.blitSprite(RenderType::guiTextured, SCROLLER_SPRITE, scrollerPos, y, scrollerWidth, 6);
            RenderSystem.disableBlend();
        }
    }

    protected boolean scrollbarVisible() {
        return this.getMaxScroll() > 0;
    }

    protected void renderSeparators(GuiGraphics guiGraphics) {
        RenderSystem.enableBlend();
        guiGraphics.blit(RenderType::guiTextured, LEFT_SEPARATOR, this.getX() - 2, this.getY() - 1, 0.0f, 0.0f, 2, this.getHeight() + 2, 2, 32);
        guiGraphics.blit(RenderType::guiTextured, RIGHT_SEPARATOR, this.getRight(), this.getY() - 1, 0.0f, 0.0f, 2, this.getHeight() + 2, 2, 32);
        guiGraphics.blit(RenderType::guiTextured, Screen.HEADER_SEPARATOR, this.getX() - 1, this.getY() - 2, 0.0f, 0.0f, this.getWidth() + 2, 2, 32, 2);
        guiGraphics.blit(RenderType::guiTextured, Screen.FOOTER_SEPARATOR, this.getX() - 1, this.getBottom(), 0.0f, 0.0f, this.getWidth() + 2, 2, 32, 2);
        RenderSystem.disableBlend();
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        super.setFocused(focused);
        int i = this.entries.indexOf((AbstractWidget)focused);
        if (i >= 0) {
            AbstractWidget entry = (AbstractWidget)this.entries.get(i);
            this.setSelected(entry);
            if (this.mc.getLastInputType().isKeyboard()) {
                this.ensureVisible(entry);
            }
        }
    }

    protected void ensureVisible(E entry) {
        int leftHang = entry.getX() - this.getX();
        int rightHang = entry.getRight() - this.getRight();
        if (leftHang < 0) {
            this.scroll(leftHang);
        } else if (rightHang > 0) {
            this.scroll(rightHang);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        return this.scrolling || super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.scrolling) {
            if (mouseX < (double)this.getX()) {
                this.setScrollAmount(0.0);
            } else if (mouseX > (double)this.getRight()) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double maxScroll = Math.max(1, this.getMaxScroll());
                int innerWidth = this.getWidth();
                int scrollerWidth = Mth.clamp((int)((int)((float)(innerWidth * innerWidth) / (float)this.getMaxPosition())), (int)32, (int)innerWidth);
                double multiplier = Math.max(1.0, maxScroll / (double)(innerWidth - scrollerWidth));
                this.setScrollAmount(this.scrollAmount + dragX * multiplier);
            }
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int scrollMultiplier = 10;
        this.setScrollAmount(this.scrollAmount - scrollY * (double)scrollMultiplier);
        return true;
    }

    protected void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseY >= (double)this.scrollBarX() && mouseY < (double)(this.scrollBarX() + 6) && mouseX >= (double)this.getX() && mouseX < (double)this.getRight();
    }

    protected int scrollBarX() {
        return this.topScrollbar ? this.getY() : this.getY() + this.getHeight() - 6;
    }

    protected int getMaxPosition() {
        int pos = 0;
        for (AbstractWidget e : this.entries) {
            pos += e.getWidth();
            pos += this.space;
        }
        return pos - this.space;
    }

    private void scroll(int scroll) {
        this.setScrollAmount(this.scrollAmount + (double)scroll);
    }

    public void setScrollAmount(double scroll) {
        this.setClampedScrollAmount(scroll);
    }

    public void refreshScrollAmount() {
        this.setClampedScrollAmount(this.scrollAmount);
    }

    public void setClampedScrollAmount(double scroll) {
        this.scrollAmount = Mth.clamp((double)scroll, (double)0.0, (double)this.getMaxScroll());
    }

    public int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - this.getWidth());
    }

    protected int contentHeight() {
        return 0;
    }

    protected double scrollRate() {
        return 0.0;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull NarratableEntry.NarrationPriority narrationPriority() {
        if (this.isFocused()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        return this.hovered != null ? NarratableEntry.NarrationPriority.HOVERED : NarratableEntry.NarrationPriority.NONE;
    }

    public void updateWidgetNarration(@NotNull NarrationElementOutput output) {
        E hovered = this.getHovered();
        if (hovered != null) {
            hovered.updateNarration(output.nest());
            this.narrateListElementPosition(output, hovered);
        } else {
            AbstractWidget focused = (AbstractWidget)this.getFocused();
            if (focused != null) {
                focused.updateNarration(output.nest());
                this.narrateListElementPosition(output, focused);
            }
        }
        output.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.component_list.usage"));
    }

    protected void narrateListElementPosition(NarrationElementOutput output, E entry) {
        int index;
        if (this.entries.size() > 1 && (index = this.entries.indexOf(entry)) != -1) {
            output.add(NarratedElementType.POSITION, (Component)Component.translatable((String)"narrator.position.list", (Object[])new Object[]{index + 1, this.entries.size()}));
        }
    }

    @NotNull
    public final List<E> children() {
        return Collections.unmodifiableList(this.entries);
    }

    public static enum Snap {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

