/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Sound;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.SilentButton;
import dev.terminalmc.chatnotify.gui.widget.field.DropdownTextField;
import dev.terminalmc.chatnotify.gui.widget.field.FakeTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.SoundOptionsScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import org.jetbrains.annotations.Nullable;

public class SoundList
extends OptionList {
    public static final String[] NOTEBLOCK_SOUNDS = new String[]{"block.note_block.banjo", "block.note_block.bass", "block.note_block.basedrum", "block.note_block.bell", "block.note_block.bit", "block.note_block.chime", "block.note_block.cow_bell", "block.note_block.didgeridoo", "block.note_block.flute", "block.note_block.guitar", "block.note_block.harp", "block.note_block.hat", "block.note_block.iron_xylophone", "block.note_block.pling", "block.note_block.snare", "block.note_block.xylophone"};
    public static final String[] POWER_SOUNDS = new String[]{"block.beacon.activate", "block.beacon.deactivate", "block.beacon.power_select", "block.conduit.activate", "block.conduit.deactivate", "block.end_portal_frame.fill", "block.portal.travel", "block.portal.trigger", "entity.enderman.teleport", "item.trident.return", "entity.elder_guardian.curse", "entity.warden.sonic_boom", "entity.evoker.cast_spell", "entity.evoker.prepare_summon", "entity.evoker.prepare_attack", "entity.zombie_villager.converted"};
    public static final String[] EXPLOSION_SOUNDS = new String[]{"entity.tnt.primed", "entity.generic.explode", "entity.lightning_bolt.thunder", "item.firecharge.use", "block.fire.extinguish", "entity.firework_rocket.blast", "entity.firework_rocket.large_blast", "entity.firework_rocket.twinkle"};
    public static final String[] VILLAGER_SOUNDS = new String[]{"entity.villager.ambient", "entity.villager.yes", "entity.villager.no", "entity.villager.trade", "entity.pillager.ambient", "entity.vindicator.ambient", "entity.vindicator.celebrate", "entity.evoker.ambient"};
    public static final String[] MISC_SOUNDS = new String[]{"entity.arrow.hit_player", "block.bell.use", "block.amethyst_block.hit", "block.amethyst_cluster.place", "entity.allay.item_thrown", "entity.iron_golem.repair", "block.anvil.land", "item.shield.block", "item.shield.break", "entity.player.death", "entity.goat.screaming.prepare_ram", "ui.button.click"};
    private final Sound sound;
    @Nullable
    private SoundInstance lastSound;

    public SoundList(Minecraft mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, Sound sound) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, 1);
        this.sound = sound;
    }

    @Override
    protected void addEntries() {
        this.addEntry((AbstractSelectionList.Entry)new Entry.SoundField(this.entryX, this.entryWidth, this.entryHeight, this.sound, this));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.DoubleSlider(this.entryX, this.entryWidth, this.entryHeight, 0.0, 1.0, 2, Localization.localized("option", "notif.sound.volume", new Object[0]).getString(), null, CommonComponents.OPTION_OFF.getString(), null, () -> this.sound.getVolume(), value -> this.sound.setVolume(value.floatValue())));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.DoubleSlider(this.entryX, this.entryWidth, this.entryHeight, 0.5, 2.0, 2, Localization.localized("option", "notif.sound.pitch", new Object[0]).getString(), null, null, null, () -> this.sound.getPitch(), value -> this.sound.setPitch(value.floatValue())));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.SilentActionButton(this.entryX, this.entryWidth, this.entryHeight, (Component)Component.literal((String)"> ").withStyle(ChatFormatting.YELLOW).append((Component)Localization.localized("option", "notif.sound.test", new Object[0]).withStyle(ChatFormatting.WHITE)).append(" <"), null, -1, button -> this.playNotifSound()));
        this.addEntry((AbstractSelectionList.Entry)new Entry.SoundSource(this.entryX, this.entryWidth, this.entryHeight, this));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("sound", "group.noteblock", new Object[0]), null, -1));
        this.addSoundEntries(NOTEBLOCK_SOUNDS);
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("sound", "group.power", new Object[0]), null, -1));
        this.addSoundEntries(POWER_SOUNDS);
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("sound", "group.explosion", new Object[0]), null, -1));
        this.addSoundEntries(EXPLOSION_SOUNDS);
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("sound", "group.illager", new Object[0]), null, -1));
        this.addSoundEntries(VILLAGER_SOUNDS);
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("sound", "group.misc", new Object[0]), null, -1));
        this.addSoundEntries(MISC_SOUNDS);
    }

    private void addSoundEntries(String[] sounds) {
        for (int i = 0; i < sounds.length; ++i) {
            this.addEntry((AbstractSelectionList.Entry)new Entry.SoundOption(this.entryX, this.entryWidth, this.entryHeight, this, this.sound, sounds[i], i < sounds.length - 1 ? sounds[++i] : null));
        }
    }

    private void refreshSoundField() {
        OptionList.Entry entry = (OptionList.Entry)this.getEntry(0);
        if (entry instanceof Entry.SoundField) {
            Entry.SoundField soundField = (Entry.SoundField)entry;
            soundField.updateValue();
        }
    }

    private void playNotifSound() {
        ResourceLocation location = this.sound.getResourceLocation();
        if (location != null) {
            if (this.lastSound != null) {
                this.mc.getSoundManager().stop(this.lastSound);
            }
            this.lastSound = new SimpleSoundInstance(location, Config.get().soundSource, this.sound.getVolume(), this.sound.getPitch(), SoundInstance.createUnseededRandom(), false, 0, SoundInstance.Attenuation.NONE, 0.0, 0.0, 0.0, true);
            this.mc.getSoundManager().play(this.lastSound);
        }
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class SoundOption
        extends Entry {
            SoundOption(int x, int width, int height, SoundList list, Sound sound, String soundId1, @Nullable String soundId2) {
                int buttonWidth = (width - 1) / 2;
                this.elements.add(new SilentButton(x, 0, buttonWidth, height, (Component)Localization.localized("sound", "id." + soundId1, new Object[0]), button -> {
                    sound.setId(soundId1);
                    list.refreshSoundField();
                    list.playNotifSound();
                }));
                if (soundId2 != null) {
                    this.elements.add(new SilentButton(x + width - buttonWidth, 0, buttonWidth, height, (Component)Localization.localized("sound", "id." + soundId2, new Object[0]), button -> {
                        sound.setId(soundId2);
                        list.refreshSoundField();
                        list.playNotifSound();
                    }));
                }
            }
        }

        private static class SoundSource
        extends Entry {
            SoundSource(int x, int width, int height, SoundList list) {
                int mainButtonWidth = width - list.smallWidgetWidth - 1;
                this.elements.add(CycleButton.builder(source -> Component.translatable((String)("soundCategory." + source.getName()))).withValues((Object[])net.minecraft.sounds.SoundSource.values()).withInitialValue((Object)Config.get().soundSource).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "notif.sound.source.tooltip", new Object[0]))).create(x, 0, mainButtonWidth, height, (Component)Localization.localized("option", "notif.sound.source", new Object[0]), (button, status) -> {
                    Config.get().soundSource = status;
                }));
                this.elements.add(Button.builder((Component)Component.literal((String)Unicode.SOUND.str), button -> Minecraft.getInstance().setScreen((Screen)new SoundOptionsScreen((Screen)list.screen, Minecraft.getInstance().options))).tooltip(Tooltip.create((Component)Localization.localized("option", "notif.sound.open.minecraft_volume.tooltip", new Object[0]))).pos(x + width - list.smallWidgetWidth, 0).size(list.smallWidgetWidth, height).build());
            }
        }

        private static class SoundField
        extends Entry {
            private final Sound sound;
            private final TextField soundField;

            SoundField(int x, int width, int height, Sound sound, SoundList list) {
                this.sound = sound;
                int statusButtonWidth = 25;
                int fieldWidth = width - statusButtonWidth - 2;
                this.soundField = new FakeTextField(x, 0, fieldWidth, height, () -> {
                    int wHeight = Math.max(40, list.height);
                    int wWidth = Math.max(80, list.dynWideEntryWidth);
                    int wX = x + width / 2 - wWidth / 2;
                    int wY = list.getY();
                    list.screen.setOverlayWidget(new DropdownTextField(wX, wY, wWidth, wHeight, (Component)Component.empty(), sound::getId, sound::setId, widget -> list.init(), Minecraft.getInstance().getSoundManager().getAvailableSounds().stream().map(ResourceLocation::toString).sorted().toList()).withSoundDropType());
                });
                this.soundField.soundValidator();
                this.soundField.setMaxLength(240);
                this.soundField.setValue(sound.getId());
                this.elements.add(this.soundField);
                this.elements.add(CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).displayOnlyValue().withInitialValue((Object)sound.isEnabled()).create(x + width - statusButtonWidth, 0, statusButtonWidth, height, (Component)Component.empty(), (button, status) -> sound.setEnabled((boolean)status)));
            }

            public void updateValue() {
                this.soundField.setValue(this.sound.getId());
            }
        }
    }
}

