/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.Sound;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.config.util.JsonUtil;
import dev.terminalmc.chatnotify.platform.Services;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    public static final int VERSION = 9;
    public final int version = 9;
    private static final Path CONFIG_DIR = Services.PLATFORM.getConfigDir();
    public static final String FILE_NAME = "chatnotify.json";
    public static final String UNREADABLE_FILE_NAME = "chatnotify.unreadable.json";
    public static final String OLD_FILE_NAME = "chatnotify.old.json";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Config.class, (Object)new Deserializer()).registerTypeAdapter(Notification.class, (Object)new Notification.Deserializer()).registerTypeAdapter(Sound.class, (Object)new Sound.Deserializer()).registerTypeAdapter(TextStyle.class, (Object)new TextStyle.Deserializer()).registerTypeAdapter(Trigger.class, (Object)new Trigger.Deserializer()).registerTypeAdapter(StyleTarget.class, (Object)new StyleTarget.Deserializer()).registerTypeAdapter(Response.class, (Object)new Response.Deserializer()).setPrettyPrinting().create();
    public DetectionMode detectionMode;
    public DebugMode debugMode;
    public NotifMode notifMode;
    public RestyleMode restyleMode;
    public SendMode sendMode;
    public SenderDetectionMode senderDetectionMode;
    public boolean checkOwnMessages;
    public static final boolean checkOwnMessagesDefault = true;
    public class_3419 soundSource;
    public static final class_3419 soundSourceDefault = class_3419.field_15248;
    public int defaultColor;
    public static final int defaultColorDefault = 16761856;
    public final Sound defaultSound;
    public static final Supplier<Sound> defaultSoundDefault = Sound::new;
    public final List<String> prefixes;
    public static final Supplier<List<String>> prefixesDefault = () -> new ArrayList<String>(List.of("/shout", "/me", "!"));
    private final List<Notification> notifications;
    private static final Supplier<List<Notification>> notificationsDefault = () -> new ArrayList<Notification>(List.of(Notification.createUser()));
    private static Config instance = null;

    public Config() {
        this(DetectionMode.values()[0], DebugMode.values()[0], NotifMode.values()[0], RestyleMode.values()[0], SendMode.values()[0], SenderDetectionMode.values()[0], true, soundSourceDefault, 16761856, defaultSoundDefault.get(), prefixesDefault.get(), notificationsDefault.get());
    }

    Config(DetectionMode detectionMode, DebugMode debugMode, NotifMode notifMode, RestyleMode restyleMode, SendMode sendMode, SenderDetectionMode senderDetectionMode, boolean checkOwnMessages, class_3419 soundSource, int defaultColor, Sound defaultSound, List<String> prefixes, List<Notification> notifications) {
        this.detectionMode = detectionMode;
        this.debugMode = debugMode;
        this.notifMode = notifMode;
        this.restyleMode = restyleMode;
        this.sendMode = sendMode;
        this.senderDetectionMode = senderDetectionMode;
        this.checkOwnMessages = checkOwnMessages;
        this.soundSource = soundSource;
        this.defaultColor = defaultColor;
        this.defaultSound = defaultSound;
        this.prefixes = prefixes;
        this.notifications = notifications;
    }

    public Notification getUserNotif() {
        this.validateUserNotif();
        return this.notifications.getFirst();
    }

    public void setProfileName(String name) {
        this.getUserNotif().triggers.getFirst().string = name;
    }

    public void setDisplayName(String name) {
        this.getUserNotif().triggers.get((int)1).string = name;
    }

    public List<Notification> getNotifs() {
        return Collections.unmodifiableList(this.notifications);
    }

    public void addNotif() {
        this.notifications.add(Notification.createBlank(new Sound(this.defaultSound), new TextStyle(this.defaultColor)));
    }

    public boolean removeNotif(int index) {
        if (index != 0) {
            this.notifications.remove(index);
            return true;
        }
        return false;
    }

    public boolean moveNotif(int srcIdx, int dstIdx) {
        if (srcIdx > 0 && dstIdx > 0 && srcIdx != dstIdx) {
            this.notifications.add(dstIdx, this.notifications.remove(srcIdx));
            return true;
        }
        return false;
    }

    public static Config get() {
        if (instance == null) {
            instance = Config.load();
        }
        return instance;
    }

    public static Config getAndSave() {
        Config.get();
        Config.save();
        return instance;
    }

    public static Config resetAndSave() {
        instance = new Config();
        Config.save();
        return instance;
    }

    public static Config reload() {
        instance = null;
        Config.get();
        ChatNotify.RESPONSES.clear();
        ChatNotify.updateUsernameNotif(instance);
        return instance;
    }

    @NotNull
    public static Config load() {
        Path file = CONFIG_DIR.resolve(FILE_NAME);
        Config config = null;
        if (Files.exists(file, new LinkOption[0])) {
            JsonUtil.reset();
            config = Config.load(file, GSON);
            if (config == null) {
                Config.backup(UNREADABLE_FILE_NAME);
                ChatNotify.LOG.warn("Resetting config", new Object[0]);
                ChatNotify.hasResetConfig = true;
            } else if (JsonUtil.hasChanged) {
                Config.backup(OLD_FILE_NAME);
            }
        }
        return config != null ? config : new Config();
    }

    @Nullable
    private static Config load(Path file, Gson gson) {
        Config config;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file.toFile()), StandardCharsets.UTF_8);
        try {
            config = (Config)gson.fromJson((Reader)reader, Config.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                ChatNotify.LOG.error("Unable to load config", e);
                return null;
            }
        }
        reader.close();
        return config;
    }

    private static void backup(String path) {
        try {
            ChatNotify.LOG.warn("Copying {} to {}", FILE_NAME, path);
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path backupFile = file.resolveSibling(path);
            Files.move(file, backupFile, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ChatNotify.LOG.error("Unable to copy config file", e);
        }
    }

    public static void save() {
        if (instance == null) {
            return;
        }
        instance.validate();
        try {
            if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
                Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
            }
            Path file = CONFIG_DIR.resolve(FILE_NAME);
            Path tempFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".tmp");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile.toFile()), StandardCharsets.UTF_8);){
                writer.write(GSON.toJson((Object)instance));
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            ChatNotify.onConfigSaved(instance);
        }
        catch (IOException e) {
            ChatNotify.LOG.error("Unable to save config", e);
        }
    }

    private Config validate() {
        this.defaultColor = Config.validateColor(this.defaultColor);
        this.defaultSound.validate();
        this.prefixes.removeIf(String::isBlank);
        this.prefixes.sort(Comparator.comparingInt(String::length).reversed());
        this.validateUserNotif();
        this.notifications.removeIf(n -> {
            n.validate();
            return n != this.notifications.getFirst() && n.triggers.isEmpty() && n.exclusionTriggers.isEmpty() && n.responses.isEmpty();
        });
        return this;
    }

    private void validateUserNotif() {
        if (this.notifications.isEmpty()) {
            ChatNotify.LOG.error("Username notification does not exist! Creating...", new Object[0]);
            this.notifications.add(Notification.createUser());
        } else if (this.notifications.getFirst().triggers.size() < 2) {
            ChatNotify.LOG.error("Username notification missing triggers! Recreating...", new Object[0]);
            this.notifications.set(0, Notification.createUser());
        }
    }

    static int validateColor(int color) {
        if (color >= 0 && color <= 0xFFFFFF) {
            return color;
        }
        return color & 0xFFFFFF;
    }

    public static enum DetectionMode {
        HUD_KNOWN_TAGS,
        HUD,
        PACKET;

    }

    public static enum DebugMode {
        NONE,
        ALL;

    }

    public static enum NotifMode {
        ALL_SINGLE_SOUND,
        ALL,
        SINGLE;

    }

    public static enum RestyleMode {
        ALL_INSTANCES,
        SINGLE;

    }

    public static enum SendMode {
        PACKET,
        SCREEN;

    }

    public static enum SenderDetectionMode {
        COMBINED,
        SENT_MATCH;

    }

    public static class Deserializer
    implements JsonDeserializer<Config> {
        public Config deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 9;
            DetectionMode detectionMode = JsonUtil.getOrDefault(obj, "detectionMode", DetectionMode.class, DetectionMode.values()[0], silent);
            DebugMode debugMode = JsonUtil.getOrDefault(obj, "debugMode", DebugMode.class, DebugMode.values()[0], silent);
            NotifMode notifMode = JsonUtil.getOrDefault(obj, "notifMode", NotifMode.class, NotifMode.values()[0], silent);
            RestyleMode restyleMode = JsonUtil.getOrDefault(obj, "restyleMode", RestyleMode.class, RestyleMode.values()[0], silent);
            SendMode sendMode = JsonUtil.getOrDefault(obj, "sendMode", SendMode.class, SendMode.values()[0], silent);
            SenderDetectionMode senderDetectionMode = JsonUtil.getOrDefault(obj, "senderDetectionMode", SenderDetectionMode.class, SenderDetectionMode.values()[0], silent);
            boolean checkOwnMessages = JsonUtil.getOrDefault(obj, "checkOwnMessages", true, silent);
            class_3419 soundSource = JsonUtil.getOrDefault(obj, "soundSource", class_3419.class, soundSourceDefault, silent);
            int defaultColor = JsonUtil.getOrDefault(obj, "defaultColor", 16761856, silent);
            Sound defaultSound = JsonUtil.getOrDefault(ctx, obj, "defaultSound", Sound.class, defaultSoundDefault.get(), silent);
            List<String> prefixes = JsonUtil.getOrDefault(obj, "prefixes", prefixesDefault.get(), silent);
            List<Notification> notifications = JsonUtil.getOrDefault(ctx, obj, "notifications", Notification.class, notificationsDefault.get(), silent);
            return new Config(detectionMode, debugMode, notifMode, restyleMode, sendMode, senderDetectionMode, checkOwnMessages, soundSource, defaultColor, defaultSound, prefixes, notifications).validate();
        }
    }
}

