/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.field;

import dev.terminalmc.chatnotify.gui.widget.ExpandingList;
import dev.terminalmc.chatnotify.gui.widget.OverlayWidget;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3419;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DropdownTextField
extends OverlayWidget {
    public static final int MIN_WIDTH = 80;
    public static final int MIN_HEIGHT = 40;
    public static final int MAX_WIDTH = 500;
    public static final int MAX_HEIGHT = 800;
    private final Supplier<String> supplier;
    private final Consumer<String> consumer;
    private final Collection<String> dropdownValues;
    private Function<String, DropdownWidget> dropWidgetProvider;
    private class_4185 cancelButton;
    private class_4185 confirmButton;
    private TextField textField;
    private ExpandingList dropdown;
    private boolean suppressUpdate;
    @Nullable
    private String oldVal = null;

    public DropdownTextField(int x, int y, int width, int height, class_2561 msg, Supplier<String> supplier, Consumer<String> consumer, Consumer<OverlayWidget> close, Collection<String> dropdownValues) {
        super(x, y, width, height, false, msg, close);
        this.supplier = supplier;
        this.consumer = consumer;
        this.dropdownValues = dropdownValues;
        this.dropWidgetProvider = this::createDefaultDropWidget;
        this.init();
    }

    @Override
    protected void init() {
        class_310 mc = class_310.method_1551();
        int x = this.method_46426();
        int y = this.method_46427();
        int widgetHeight = 20;
        int verticalSpace = 1;
        int buttonWidth = 20;
        int textFieldWidth = this.field_22758 - 2 * widgetHeight;
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.CROSS.str).method_27692(class_124.field_1061), button -> this.onClose()).method_46433(x + this.field_22758 - buttonWidth * 2, y).method_46437(buttonWidth, widgetHeight).method_46431();
        this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)Unicode.CHECK.str).method_27692(class_124.field_1060), button -> {
            this.consumer.accept(this.textField.method_1882());
            this.onClose();
        }).method_46433(x + this.field_22758 - buttonWidth, y).method_46437(buttonWidth, widgetHeight).method_46431();
        this.textField = new TextField(x, y, textFieldWidth, widgetHeight);
        Objects.requireNonNull(mc.field_1772);
        Objects.requireNonNull(mc.field_1772);
        this.dropdown = new ExpandingList(x, y + widgetHeight + verticalSpace, this.field_22758, this.field_22759 - widgetHeight - verticalSpace, 9, 9, 2);
        this.textField.method_1880(240);
        this.textField.method_1863(this::valueResponder);
        this.textField.method_1852(this.oldVal == null ? this.supplier.get() : this.oldVal);
        this.textField.method_25365(true);
    }

    @Override
    public int getMinWidth() {
        return 80;
    }

    @Override
    public int getMaxWidth() {
        return 500;
    }

    @Override
    public int getMinHeight() {
        return 40;
    }

    @Override
    public int getMaxHeight() {
        return 800;
    }

    private DropdownWidget createDefaultDropWidget(String str) {
        int n = this.textField.method_46426();
        int n2 = this.textField.method_46427() + this.textField.method_25364();
        int n3 = this.textField.method_25368();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return new DropdownWidget(n, n2, n3, 9 + 2, (class_2561)class_2561.method_43470((String)str), class_310.method_1551().field_1772, this::tabComplete);
    }

    public DropdownTextField withSoundDropType() {
        this.dropWidgetProvider = this::createSoundDropWidget;
        this.init();
        return this;
    }

    private SoundDropdownWidget createSoundDropWidget(String str) {
        int n = this.textField.method_46426();
        int n2 = this.textField.method_46427() + this.textField.method_25364();
        int n3 = this.textField.method_25368();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        return new SoundDropdownWidget(n, n2, n3, 9 + 2, (class_2561)class_2561.method_43470((String)str), class_310.method_1551().field_1772, this::tabComplete);
    }

    private void tabComplete(String str) {
        this.suppressUpdate = true;
        this.textField.method_1852(str);
        this.suppressUpdate = false;
    }

    private void valueResponder(String str) {
        this.oldVal = str;
        if (!this.suppressUpdate) {
            this.dropdown.highlightIndex = -1;
            this.dropdown.clearWidgets();
            this.dropdown.method_44382(0.0);
            for (String suggestion : this.dropdownValues) {
                if (!suggestion.contains(str) || suggestion.equals(str)) continue;
                class_7842 widget = this.dropWidgetProvider.apply(suggestion);
                widget.method_48596();
                this.dropdown.addWidget((class_339)widget);
            }
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.textField.method_25370()) {
            if (!this.dropdown.isEmpty()) {
                if (keyCode == 258) {
                    if (class_437.method_25442()) {
                        this.tabUp();
                    } else {
                        this.tabDown();
                    }
                    return true;
                }
                if (keyCode == 265) {
                    this.tabUp();
                    return true;
                }
                if (keyCode == 264) {
                    this.tabDown();
                    return true;
                }
            }
            return this.textField.method_25404(keyCode, scanCode, modifiers);
        }
        return false;
    }

    private void tabUp() {
        if (--this.dropdown.highlightIndex < 0) {
            this.dropdown.highlightIndex = this.dropdown.size() - 1;
        }
        this.dropdown.ensureVisible(this.dropdown.highlightIndex);
        this.tabComplete(this.dropdown.get(this.dropdown.highlightIndex).method_25369().getString());
    }

    private void tabDown() {
        if (++this.dropdown.highlightIndex >= this.dropdown.size()) {
            this.dropdown.highlightIndex = 0;
        }
        this.dropdown.ensureVisible(this.dropdown.highlightIndex);
        this.tabComplete(this.dropdown.get(this.dropdown.highlightIndex).method_25369().getString());
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.textField.method_25370()) {
            return this.textField.method_25400(chr, modifiers);
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.mouseOnWidget(this, mouseX, mouseY)) {
            if (this.mouseOnWidget((class_339)this.textField, mouseX, mouseY)) {
                if (!this.textField.method_25370()) {
                    this.textField.method_25365(true);
                } else {
                    this.textField.method_25402(mouseX, mouseY, button);
                }
            } else if (this.textField.method_25370() && this.mouseOnWidget((class_339)this.dropdown, mouseX, mouseY)) {
                this.dropdown.method_25402(mouseX, mouseY, button);
            } else {
                this.textField.method_25365(false);
                if (button == 0) {
                    if (this.mouseOnWidget((class_339)this.cancelButton, mouseX, mouseY)) {
                        this.cancelButton.method_25402(mouseX, mouseY, button);
                    } else if (this.mouseOnWidget((class_339)this.confirmButton, mouseX, mouseY)) {
                        this.confirmButton.method_25402(mouseX, mouseY, button);
                    }
                }
            }
        } else {
            this.cancelButton.method_25306();
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.textField.method_25370() && this.mouseOnWidget((class_339)this.textField, mouseX, mouseY)) {
            return this.textField.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }
        this.dropdown.method_25395(null);
        return this.dropdown.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.textField.method_25370() && this.mouseOnWidget((class_339)this.dropdown, mouseX, mouseY)) {
            return this.dropdown.method_25401(mouseX, mouseY, deltaX, deltaY);
        }
        return false;
    }

    private boolean mouseOnWidget(class_339 widget, double mouseX, double mouseY) {
        return (double)widget.method_46426() <= mouseX && mouseX < (double)(widget.method_46426() + widget.method_25368()) && (double)widget.method_46427() <= mouseY && mouseY < (double)(widget.method_46427() + widget.method_25364());
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        this.textField.method_48579(graphics, mouseX, mouseY, delta);
        this.cancelButton.method_25394(graphics, mouseX, mouseY, delta);
        this.confirmButton.method_25394(graphics, mouseX, mouseY, delta);
        if (this.textField.method_25370() && !this.dropdown.isEmpty()) {
            this.dropdown.method_48579(graphics, mouseX, mouseY, delta);
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        if (SoundDropdownWidget.lastSound != null) {
            class_310.method_1551().method_1483().method_4870(SoundDropdownWidget.lastSound);
        }
    }

    public static class DropdownWidget
    extends class_7842 {
        private final Consumer<String> consumer;

        private DropdownWidget(int x, int y, int width, int height, class_2561 msg, class_327 font, Consumer<String> consumer) {
            super(x, y, width, height, msg, font);
            this.field_22763 = true;
            this.consumer = consumer;
        }

        public static DropdownWidget create(int x, int y, int width, int height, class_2561 msg, class_327 font, Consumer<String> dest) {
            return new DropdownWidget(x, y, width, height, msg, font, dest);
        }

        public void method_25348(double mouseX, double mouseY) {
            this.consumer.accept(this.method_25369().getString());
        }
    }

    public static class SoundDropdownWidget
    extends DropdownWidget {
        @Nullable
        private static class_1113 lastSound;

        private SoundDropdownWidget(int x, int y, int width, int height, class_2561 msg, class_327 font, Consumer<String> consumer) {
            super(x, y, width, height, msg, font, consumer);
        }

        public static SoundDropdownWidget create(int x, int y, int width, int height, class_2561 msg, class_327 font, Consumer<String> consumer) {
            return new SoundDropdownWidget(x, y, width, height, msg, font, consumer);
        }

        public void method_25354(@NotNull class_1144 soundManager) {
            if (lastSound != null) {
                soundManager.method_4870(lastSound);
            }
            lastSound = new class_1109(class_2960.method_60654((String)this.method_25369().getString()), class_3419.field_15250, 1.0f, 1.0f, class_1113.method_43221(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true);
            soundManager.method_4873(lastSound);
        }
    }
}

