/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.mixin;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import net.minecraft.class_2678;
import net.minecraft.class_2703;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class}, priority=792)
public class ClientPacketListenerMixin {
    @Inject(method={"handleLogin"}, at={@At(value="TAIL")})
    private void getProfileName(class_2678 packet, CallbackInfo ci) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        String name = FormatUtil.stripCodes(class_310.method_1551().field_1724.method_5477().getString());
        Config.get().setProfileName(name);
        Config.get().setDisplayName(name);
    }

    @Inject(method={"applyPlayerInfoUpdate"}, at={@At(value="TAIL")})
    private void getDisplayName(class_2703.class_5893 action, class_2703.class_2705 entry, class_640 playerInfo, CallbackInfo ci) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        if (action.equals((Object)class_2703.class_5893.field_29139) && playerInfo.method_2966().getId().equals(class_310.method_1551().field_1724.method_5667()) && entry.comp_1111() != null) {
            Config.get().setDisplayName(FormatUtil.stripCodes(entry.comp_1111().getString()));
        }
    }

    @Inject(method={"sendChat"}, at={@At(value="HEAD")})
    private void getMessage(String message, CallbackInfo ci) {
        this.chatnotify$storeMessage(message);
    }

    @Inject(method={"sendCommand"}, at={@At(value="HEAD")})
    private void getCommand(String command, CallbackInfo ci) {
        this.chatnotify$storeCommand(command);
    }

    @Inject(method={"sendUnattendedCommand"}, at={@At(value="HEAD")})
    private void getUnsignedCommand(String command, class_437 screen, CallbackInfo ci) {
        this.chatnotify$storeCommand(command);
    }

    @Unique
    private void chatnotify$storeMessage(String message) {
        long time = System.nanoTime();
        this.chatnotify$removeOldMessages(time);
        String plainMsg = "";
        for (String prefix : Config.get().prefixes) {
            if (!message.startsWith(prefix)) continue;
            plainMsg = message.replaceFirst(prefix, "").strip();
            break;
        }
        ChatNotify.recentMessages.add((Pair<Long, String>)Pair.of((Object)(time + 5000000000L), (Object)(plainMsg.isEmpty() ? message : plainMsg)));
    }

    @Unique
    private void chatnotify$storeCommand(String command) {
        long time = System.currentTimeMillis();
        this.chatnotify$removeOldMessages(time);
        command = "/" + (String)command;
        for (String prefix : Config.get().prefixes) {
            if (!((String)command).startsWith(prefix)) continue;
            if (((String)(command = ((String)command).replaceFirst(prefix, "").strip())).isEmpty()) break;
            ChatNotify.recentMessages.add((Pair<Long, String>)Pair.of((Object)(time + 5000000000L), (Object)command));
            break;
        }
    }

    @Unique
    private void chatnotify$removeOldMessages(long time) {
        ChatNotify.recentMessages.removeIf(pair -> (Long)pair.getFirst() < time);
    }
}

