/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util.text;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.mixin.accessor.StyleAccessor;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import org.jetbrains.annotations.Nullable;

public class FormatUtil {
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile(Pattern.quote(Unicode.SECTION.str) + ".?");
    private static final String PLACEHOLDER_PATTERN_STRING = "%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("%(\\d+\\$)?([-#+ 0,(<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    private FormatUtil() {
    }

    public static String stripCodes(String str) {
        return COLOR_CODE_PATTERN.matcher(str).replaceAll("");
    }

    public static class_5250 convertToStyledLiteral(class_5250 text) throws IllegalArgumentException {
        if (text.method_10851() instanceof class_2588) {
            text = FormatUtil.convertToLiteral(text);
        }
        text.method_10855().replaceAll(sibling -> FormatUtil.convertToStyledLiteral(sibling.method_27661()));
        if (text.method_10851() instanceof class_8828) {
            text = FormatUtil.convertCodesToStyles(text);
        }
        return text;
    }

    private static class_5250 convertToLiteral(class_5250 text) throws IllegalArgumentException {
        boolean validFormat;
        String string;
        ArrayList oldSiblings;
        boolean debug;
        class_2588 contents;
        block24: {
            class_7417 class_74172 = text.method_10851();
            if (!(class_74172 instanceof class_2588)) {
                return text;
            }
            contents = (class_2588)class_74172;
            debug = Config.get().debugMode.equals((Object)Config.DebugMode.ALL);
            if (debug) {
                ChatNotify.LOG.warn("Converting message to literal", new Object[0]);
                ChatNotify.LOG.warn("Text:", new Object[0]);
                ChatNotify.LOG.warn(text.getString(), new Object[0]);
                ChatNotify.LOG.warn("Tree:", new Object[0]);
                ChatNotify.LOG.warn(text.toString(), new Object[0]);
            }
            oldSiblings = new ArrayList(text.method_10855());
            class_2477 lang = class_2477.method_10517();
            String key = contents.method_11022();
            @Nullable String fallback = contents.method_48323();
            string = fallback == null ? lang.method_48307(key) : lang.method_4679(key, fallback);
            validFormat = true;
            try {
                String.format(string, contents.method_11023());
            }
            catch (IllegalFormatException e) {
                validFormat = false;
                text = class_2561.method_43470((String)string).method_27696(text.method_10866());
                if (!debug) break block24;
                ChatNotify.LOG.warn("Invalid string format:", new Object[0]);
                ChatNotify.LOG.warn(e.getMessage(), new Object[0]);
                ChatNotify.LOG.warn(string, new Object[0]);
            }
        }
        if (validFormat) {
            Object[] unorderedArgs = contents.method_11023();
            Object[] args = new Object[unorderedArgs.length];
            int argIdx = 0;
            ArrayList<String> split = new ArrayList<String>();
            Matcher m = PLACEHOLDER_PATTERN.matcher(string);
            int previousEnd = 0;
            while (m.find()) {
                split.add(string.substring(previousEnd, m.start()));
                previousEnd = m.end();
                if (m.group(1) == null) {
                    args[argIdx] = unorderedArgs[argIdx];
                } else {
                    int num = Integer.parseInt(m.group(1).substring(0, m.group(1).length() - 1));
                    if (num < 1 || num > unorderedArgs.length) {
                        ChatNotify.LOG.warn("Translation specifies arg number {} out of range for length {}", num, unorderedArgs.length);
                        num = argIdx + 1;
                    }
                    args[argIdx] = unorderedArgs[num - 1];
                }
                ++argIdx;
            }
            if (previousEnd != 0) {
                if (previousEnd < string.length()) {
                    split.add(string.substring(previousEnd));
                } else {
                    split.add("");
                }
            }
            if (debug) {
                ChatNotify.LOG.warn("Format string:", new Object[0]);
                ChatNotify.LOG.warn(string, new Object[0]);
                ChatNotify.LOG.warn("Size of split array: {}", split.size());
                ChatNotify.LOG.warn("Size of args array: {}", contents.method_11023().length);
                ChatNotify.LOG.warn("Split array:", new Object[0]);
                StringBuilder sb = new StringBuilder("[");
                int i = 0;
                for (String s : split) {
                    if (i++ != 0) {
                        sb.append(",");
                    }
                    sb.append(s);
                }
                sb.append("]");
                ChatNotify.LOG.warn(sb.toString(), new Object[0]);
            }
            if (split.isEmpty()) {
                text = class_2561.method_43470((String)string).method_27696(text.method_10866());
            } else {
                int numPlaceholders = split.size() - 1;
                text = class_2561.method_43473().method_27696(text.method_10866());
                List siblings = text.method_10855();
                for (int i = 0; i < numPlaceholders; ++i) {
                    Object object;
                    if (!((String)split.get(i)).isEmpty()) {
                        if (debug) {
                            ChatNotify.LOG.warn("Adding translated substring:", new Object[0]);
                            ChatNotify.LOG.warn((String)split.get(i), new Object[0]);
                        }
                        siblings.add(class_2561.method_43470((String)((String)split.get(i))));
                    }
                    if ((object = args[i]) instanceof class_2561) {
                        class_2561 argComponent = (class_2561)object;
                        if (debug) {
                            ChatNotify.LOG.warn("Adding arg component", new Object[0]);
                            ChatNotify.LOG.warn("Text:", new Object[0]);
                            ChatNotify.LOG.warn(argComponent.getString(), new Object[0]);
                            ChatNotify.LOG.warn("Tree:", new Object[0]);
                            ChatNotify.LOG.warn(argComponent.toString(), new Object[0]);
                        }
                        siblings.add(argComponent);
                        continue;
                    }
                    if (debug) {
                        ChatNotify.LOG.warn("Adding arg object", new Object[0]);
                        ChatNotify.LOG.warn("getClass():", new Object[0]);
                        ChatNotify.LOG.warn(args[i].getClass().getName(), new Object[0]);
                        ChatNotify.LOG.warn("toString():", new Object[0]);
                        ChatNotify.LOG.warn(args[i].toString(), new Object[0]);
                    }
                    siblings.add(class_2561.method_43470((String)args[i].toString()));
                }
                if (!((String)split.getLast()).isEmpty()) {
                    siblings.add(class_2561.method_43470((String)((String)split.getLast())));
                }
            }
        }
        text.method_10855().addAll(oldSiblings);
        return text;
    }

    private static class_5250 convertCodesToStyles(class_5250 text) {
        class_7417 class_74172 = text.method_10851();
        if (!(class_74172 instanceof class_8828)) {
            return text;
        }
        class_8828 contents = (class_8828)class_74172;
        String str = contents.comp_737();
        if (!str.contains(Unicode.SECTION.str)) {
            return text;
        }
        ArrayList oldSiblings = new ArrayList(text.method_10855());
        text = class_2561.method_43473().method_27696(text.method_10866());
        StringBuilder sb = new StringBuilder();
        char[] chars = str.toCharArray();
        FormatCodes codes = new FormatCodes();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == Unicode.SECTION.chr.charValue()) {
                if (!sb.isEmpty()) {
                    text.method_10852((class_2561)class_2561.method_43470((String)sb.toString()).method_27696(codes.createStyle()));
                    sb.setLength(0);
                }
                if (i >= chars.length - 1) continue;
                char next = chars[++i];
                switch (next) {
                    case 'r': {
                        codes.clear();
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        codes.color = class_124.method_544((char)next);
                        break;
                    }
                    case 'k': {
                        codes.obfuscated = true;
                        break;
                    }
                    case 'l': {
                        codes.bold = true;
                        break;
                    }
                    case 'm': {
                        codes.strikethrough = true;
                        break;
                    }
                    case 'n': {
                        codes.underline = true;
                        break;
                    }
                    case 'o': {
                        codes.italic = true;
                        break;
                    }
                }
                continue;
            }
            sb.append(chars[i]);
        }
        if (!sb.isEmpty()) {
            text.method_10852((class_2561)class_2561.method_43470((String)sb.toString()).method_27696(codes.createStyle()));
        }
        text.method_10855().addAll(oldSiblings);
        return text;
    }

    private static class FormatCodes {
        @Nullable
        class_124 color = null;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean strikethrough = false;
        boolean obfuscated = false;

        private FormatCodes() {
        }

        class_2583 createStyle() {
            return StyleAccessor.chatnotify$new(this.color == null ? null : class_5251.method_27718((class_124)this.color), null, this.bold ? Boolean.valueOf(true) : null, this.italic ? Boolean.valueOf(true) : null, this.underline ? Boolean.valueOf(true) : null, this.strikethrough ? Boolean.valueOf(true) : null, this.obfuscated ? Boolean.valueOf(true) : null, null, null, null, null);
        }

        void clear() {
            this.color = null;
            this.bold = false;
            this.italic = false;
            this.underline = false;
            this.strikethrough = false;
            this.obfuscated = false;
        }
    }
}

