/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.chatnotify.config.util.JsonUtil;
import dev.terminalmc.chatnotify.util.functional.StringSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Response
implements StringSupplier {
    public static final int VERSION = 2;
    public final int version = 2;
    public transient int cooldown;
    @Nullable
    public transient String sendingString;
    public boolean enabled;
    public static final boolean enabledDefault = true;
    public String string;
    public static final String stringDefault = "";
    public int delayTicks;
    public static final int delayTicksDefault = 0;
    public int cooldownTicks;
    public static final int cooldownTicksDefault = 0;
    public Type type;

    public Response() {
        this.enabled = true;
        this.string = stringDefault;
        this.delayTicks = 0;
        this.type = Type.values()[0];
    }

    Response(boolean enabled, String string, Type type, int delayTicks, int cooldownTicks) {
        this.enabled = enabled;
        this.string = string;
        this.type = type;
        this.delayTicks = delayTicks;
        this.cooldownTicks = cooldownTicks;
    }

    @Override
    @NotNull
    public String getString() {
        return this.string;
    }

    Response validate() {
        if (this.delayTicks < 0) {
            this.delayTicks = 0;
        }
        return this;
    }

    public static enum Type {
        NORMAL("~"),
        REGEX(".*"),
        COMMANDKEYS("K");

        public final String icon;

        private Type(String icon) {
            this.icon = icon;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<Response> {
        public Response deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 2;
            boolean enabled = JsonUtil.getOrDefault(obj, "enabled", true, silent);
            String string = JsonUtil.getOrDefault(obj, "string", Response.stringDefault, silent);
            int delayTicks = JsonUtil.getOrDefault(obj, "delayTicks", 0, silent);
            int cooldownTicks = JsonUtil.getOrDefault(obj, "cooldownTicks", 0, silent);
            Type type = JsonUtil.getOrDefault(obj, "type", Type.class, Type.values()[0], silent);
            return new Response(enabled, string, type, delayTicks, cooldownTicks).validate();
        }
    }
}

