/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.util.JsonUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyleTarget {
    public static final int VERSION = 2;
    public final int version = 2;
    @Nullable
    public transient Pattern pattern;
    public final transient List<Integer> groupIndexes = new ArrayList<Integer>();
    public boolean enabled;
    public static final boolean enabledDefault = false;
    @NotNull
    public String string;
    @NotNull
    public static final String stringDefault = "";
    public Type type;

    public StyleTarget() {
        this(false, stringDefault, Type.values()[0]);
    }

    public StyleTarget(@NotNull String string) {
        this(true, string, Type.values()[0]);
    }

    StyleTarget(boolean enabled, @NotNull String string, Type type) {
        this.enabled = enabled;
        this.string = string;
        this.type = type;
    }

    public void tryCompilePattern() {
        try {
            this.pattern = Pattern.compile(this.string);
        }
        catch (PatternSyntaxException e) {
            ChatNotify.LOG.warn("Error processing regex: " + String.valueOf(e), new Object[0]);
            this.pattern = null;
        }
    }

    public void tryParseIndexes() {
        String[] split;
        this.groupIndexes.clear();
        for (String str : split = this.string.split(",")) {
            try {
                this.groupIndexes.add(Integer.parseInt(str));
            }
            catch (NumberFormatException e) {
                ChatNotify.LOG.warn("Error processing style target: " + String.valueOf(e), new Object[0]);
                this.pattern = null;
            }
        }
    }

    StyleTarget validate() {
        return this;
    }

    public static enum Type {
        NORMAL("~"),
        REGEX(".*"),
        CAPTURING("()");

        public final String icon;

        private Type(String icon) {
            this.icon = icon;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<StyleTarget> {
        public StyleTarget deserialize(JsonElement json, java.lang.reflect.Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 2;
            boolean enabled = JsonUtil.getOrDefault(obj, "enabled", false, silent);
            String string = JsonUtil.getOrDefault(obj, "string", StyleTarget.stringDefault, silent);
            Type type = JsonUtil.getOrDefault(obj, "type", Type.class, Type.values()[0], silent);
            return new StyleTarget(enabled, string, type).validate();
        }
    }
}

