/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.util.JsonUtil;
import dev.terminalmc.chatnotify.mixin.accessor.StyleAccessor;
import java.lang.reflect.Type;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public class TextStyle {
    public static final int VERSION = 2;
    public final int version = 2;
    public boolean doColor;
    public static final boolean doColorDefault = true;
    public int color;
    public static final int colorDefault = -15360;
    public FormatMode bold;
    public FormatMode italic;
    public FormatMode underlined;
    public FormatMode strikethrough;
    public FormatMode obfuscated;

    public TextStyle() {
        this(-15360);
    }

    TextStyle(int color) {
        this(true, color, FormatMode.values()[0], FormatMode.values()[0], FormatMode.values()[0], FormatMode.values()[0], FormatMode.values()[0]);
    }

    public TextStyle(boolean doColor, int color, FormatMode bold, FormatMode italic, FormatMode underlined, FormatMode strikethrough, FormatMode obfuscated) {
        this.doColor = doColor;
        this.color = color;
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.strikethrough = strikethrough;
        this.obfuscated = obfuscated;
    }

    public TextColor getTextColor() {
        return TextColor.fromRgb((int)this.color);
    }

    public boolean isEnabled() {
        return this.doColor || this.bold != FormatMode.DISABLED || this.italic != FormatMode.DISABLED || this.underlined != FormatMode.DISABLED || this.strikethrough != FormatMode.DISABLED || this.obfuscated != FormatMode.DISABLED;
    }

    public Style getStyle() {
        return StyleAccessor.chatnotify$new(this.doColor ? TextColor.fromRgb((int)this.color) : null, null, this.bold != FormatMode.DISABLED ? Boolean.valueOf(this.bold == FormatMode.ON) : null, this.italic != FormatMode.DISABLED ? Boolean.valueOf(this.italic == FormatMode.ON) : null, this.underlined != FormatMode.DISABLED ? Boolean.valueOf(this.underlined == FormatMode.ON) : null, this.strikethrough != FormatMode.DISABLED ? Boolean.valueOf(this.strikethrough == FormatMode.ON) : null, this.obfuscated != FormatMode.DISABLED ? Boolean.valueOf(this.obfuscated == FormatMode.ON) : null, null, null, null, null);
    }

    TextStyle validate() {
        this.color = Config.validateColor(this.color);
        return this;
    }

    public static enum FormatMode {
        DISABLED,
        ON,
        OFF;

    }

    public static class Deserializer
    implements JsonDeserializer<TextStyle> {
        public TextStyle deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 2;
            boolean doColor = JsonUtil.getOrDefault(obj, "doColor", true, silent);
            int color = JsonUtil.getOrDefault(obj, "color", -15360, silent);
            FormatMode bold = JsonUtil.getOrDefault(obj, "bold", FormatMode.class, FormatMode.values()[0], silent);
            FormatMode italic = JsonUtil.getOrDefault(obj, "italic", FormatMode.class, FormatMode.values()[0], silent);
            FormatMode underlined = JsonUtil.getOrDefault(obj, "underlined", FormatMode.class, FormatMode.values()[0], silent);
            FormatMode strikethrough = JsonUtil.getOrDefault(obj, "strikethrough", FormatMode.class, FormatMode.values()[0], silent);
            FormatMode obfuscated = JsonUtil.getOrDefault(obj, "obfuscated", FormatMode.class, FormatMode.values()[0], silent);
            return new TextStyle(doColor, color, bold, italic, underlined, strikethrough, obfuscated).validate();
        }
    }
}

