/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif.trigger;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.field.MultiLineTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import dev.terminalmc.chatnotify.util.text.MessageUtil;
import dev.terminalmc.chatnotify.util.text.StyleUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;

public class TriggerEditorList
extends OptionList {
    private final Trigger trigger;
    private final TextStyle textStyle;
    private final List<Component> recentChat;
    private boolean filter;
    private boolean restyle;
    private MultiLineTextField textDisplayField;
    private String displayText = "";
    private TextField keyDisplayField;
    private String displayKey = "";

    public TriggerEditorList(Minecraft mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing, Trigger trigger, TextStyle textStyle) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, entrySpacing);
        this.trigger = trigger;
        this.textStyle = textStyle;
        this.recentChat = ChatNotify.unmodifiedChat.stream().toList().reversed();
    }

    @Override
    protected void addEntries() {
        this.addSpacedEntry(new Entry.TriggerOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight + this.defaultEntryHeight, this, this.trigger));
        if (this.trigger.styleTarget.enabled) {
            this.addEntry((AbstractSelectionList.Entry)new Entry.StyleTargetOptions(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this, this.trigger.styleTarget));
        }
        this.textDisplayField = new MultiLineTextField(this.dynWideEntryX, 0, this.dynWideEntryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.trigger.editor.display.text.hint", new Object[0]));
        this.textDisplayField.setValue(this.displayText);
        this.addSpacedEntry(new Entry.DisplayField(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight + this.defaultEntryHeight, (AbstractWidget)this.textDisplayField, (Component)Localization.localized("option", "notif.trigger.editor.display.text", new Object[0])));
        this.keyDisplayField = new TextField(this.dynWideEntryX, 0, this.dynWideEntryWidth, this.entryHeight);
        this.keyDisplayField.setMaxLength(256);
        this.keyDisplayField.setValue(this.displayKey);
        this.addEntry((AbstractSelectionList.Entry)new Entry.DisplayField(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, (AbstractWidget)this.keyDisplayField, (Component)Localization.localized("option", "notif.trigger.editor.display.key", new Object[0])));
        this.addEntry((AbstractSelectionList.Entry)new Entry.Controls(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this));
        this.addChatMessages(this.recentChat);
    }

    private void setTextDisplayValue(String text) {
        this.displayText = text;
        this.textDisplayField.setValue(this.displayText);
    }

    private void setKeyDisplayValue(String key) {
        this.displayKey = key;
        this.keyDisplayField.setValue(this.displayKey);
    }

    private void addChatMessages(List<Component> recentChat) {
        boolean restyleAll = Config.get().restyleMode.equals((Object)Config.RestyleMode.ALL_INSTANCES);
        ArrayList<Pair> displayChat = new ArrayList<Pair>();
        for (Component msg : recentChat) {
            boolean hit;
            MutableComponent restyledMsg = msg.copy();
            Matcher matcher = null;
            String msgStr = FormatUtil.stripCodes(msg.getString());
            switch (this.trigger.type) {
                default: {
                    throw new MatchException(null, null);
                }
                case NORMAL: {
                    boolean bl;
                    matcher = MessageUtil.normalSearch(msgStr, this.trigger.string);
                    boolean bl2 = bl = matcher.find();
                    break;
                }
                case REGEX: {
                    boolean bl2;
                    boolean bl;
                    try {
                        matcher = Pattern.compile(this.trigger.string).matcher(msgStr);
                        bl2 = bl = matcher.find();
                    }
                    catch (PatternSyntaxException ignored) {
                        bl2 = bl = false;
                    }
                    break;
                }
                case KEY: {
                    boolean bl;
                    boolean bl2 = hit = (bl = MessageUtil.keySearch(msg, this.trigger.string));
                }
            }
            if (this.filter && !hit) continue;
            if (this.restyle && hit) {
                if (this.trigger.styleTarget.enabled) {
                    if (this.trigger.styleTarget.type == StyleTarget.Type.REGEX) {
                        this.trigger.styleTarget.tryCompilePattern();
                    } else if (this.trigger.styleTarget.type == StyleTarget.Type.CAPTURING) {
                        this.trigger.styleTarget.tryParseIndexes();
                    }
                }
                restyledMsg = StyleUtil.restyle(msg, msgStr, this.trigger, matcher, this.textStyle, restyleAll);
            }
            displayChat.add(new Pair((Object)msg, (Object)restyledMsg));
        }
        displayChat.forEach(pair -> {
            Entry.MessageEntry entry = new Entry.MessageEntry(this.dynWideEntryX, this.dynWideEntryWidth, this, (Component)pair.getFirst(), (Component)pair.getSecond());
            this.addEntry((AbstractSelectionList.Entry)entry);
            for (int requiredHeight = this.mc.font.wordWrapHeight(((Component)pair.getFirst()).getString(), this.dynWideEntryWidth) - this.defaultEntryHeight; requiredHeight > 0; requiredHeight -= this.defaultEntryHeight) {
                OptionList.Entry.Space spaceEntry = new OptionList.Entry.Space(entry);
                this.addEntry((AbstractSelectionList.Entry)spaceEntry);
            }
        });
        if (!(this.children().getLast() instanceof Entry.MessageEntry)) {
            this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, (Component)Localization.localized("option", "notif.trigger.editor.recent_messages.none", new Object[0]), null, -1));
        }
    }

    static abstract class Entry
    extends OptionList.Entry {
        Entry() {
        }

        private static class MessageEntry
        extends Entry {
            private final TriggerEditorList list;
            private final Component msg;

            MessageEntry(int x, int width, TriggerEditorList list, Component msg, Component restyledMsg) {
                this.list = list;
                this.msg = msg;
                MultiLineTextWidget widget = new MultiLineTextWidget(x, 0, restyledMsg, Minecraft.getInstance().font);
                widget.setMaxWidth(width);
                this.elements.add(widget);
            }

            public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
                String string;
                this.list.setTextDisplayValue(FormatUtil.stripCodes(this.msg.getString()));
                ComponentContents componentContents = this.msg.getContents();
                if (componentContents instanceof TranslatableContents) {
                    TranslatableContents tc = (TranslatableContents)componentContents;
                    string = tc.getKey();
                } else {
                    string = Localization.localized("option", "notif.trigger.editor.display.key.none", new Object[0]).getString();
                }
                this.list.setKeyDisplayValue(string);
                this.list.setScrollAmount(0.0);
                return true;
            }
        }

        private static class DisplayField
        extends Entry {
            DisplayField(int x, int width, int height, AbstractWidget widget, Component label) {
                int labelWidth = 40;
                int fieldWidth = width - labelWidth - 4;
                Button labelButton = Button.builder((Component)label, button -> {}).pos(x, 0).size(labelWidth, height).build();
                labelButton.active = false;
                this.elements.add(labelButton);
                widget.setWidth(fieldWidth);
                widget.setHeight(height);
                widget.setX(x + width - fieldWidth);
                this.elements.add(widget);
            }
        }

        private static class Controls
        extends Entry {
            Controls(int x, int width, int height, TriggerEditorList list) {
                int buttonWidth = (width - 8) / 3;
                int movingX = x;
                this.elements.add(CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)list.filter).create(movingX, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.trigger.editor.filter", new Object[0]), (button, status) -> {
                    list.filter = status;
                    list.init();
                }));
                this.elements.add(CycleButton.booleanBuilder((Component)CommonComponents.OPTION_ON.copy().withStyle(ChatFormatting.GREEN), (Component)CommonComponents.OPTION_OFF.copy().withStyle(ChatFormatting.RED)).withInitialValue((Object)list.restyle).create(movingX += buttonWidth + 4, 0, buttonWidth, height, (Component)Localization.localized("option", "notif.trigger.editor.restyle", new Object[0]), (button, status) -> {
                    list.restyle = status;
                    list.init();
                }));
                movingX = x + width - buttonWidth;
                this.elements.add(Button.builder((Component)Localization.localized("option", "notif.format.color", new Object[0]).setStyle(Style.EMPTY.withColor(list.textStyle.color)), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.screen.setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, ((TriggerEditorList)list).screen.height / 2 - cpHeight / 2, cpWidth, cpHeight, () -> list.textStyle.color, val -> {
                        list.textStyle.color = val;
                    }, widget -> list.init()));
                }).pos(movingX, 0).size(buttonWidth, height).build());
            }
        }

        private static class StyleTargetOptions
        extends Entry {
            StyleTargetOptions(int x, int width, int height, TriggerEditorList list, StyleTarget styleTarget) {
                int stringFieldWidth = width - list.tinyWidgetWidth * 4;
                int movingX = x + list.tinyWidgetWidth;
                StringWidget infoIcon = new StringWidget(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.literal((String)Unicode.INFO.str), Minecraft.getInstance().font);
                infoIcon.setTooltip(Tooltip.create((Component)Localization.localized("option", "notif.trigger.style_target.tooltip", new Object[0])));
                infoIcon.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(infoIcon);
                CycleButton typeButton = CycleButton.builder(type -> Component.literal((String)type.icon)).withValues((Object[])StyleTarget.Type.values()).displayOnlyValue().withInitialValue((Object)styleTarget.type).withTooltip(type -> Tooltip.create((Component)Localization.localized("option", "notif.trigger.style_target.type." + String.valueOf(type) + ".tooltip", new Object[0]))).create(movingX += list.tinyWidgetWidth, 0, list.tinyWidgetWidth, height, (Component)Component.empty(), (button, type) -> {
                    styleTarget.type = type;
                    list.init();
                });
                typeButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(typeButton);
                TextField stringField = new TextField(movingX += list.tinyWidgetWidth, 0, stringFieldWidth, height);
                if (styleTarget.type == StyleTarget.Type.REGEX) {
                    stringField.regexValidator();
                }
                stringField.setMaxLength(240);
                stringField.setValue(styleTarget.string);
                stringField.setResponder(string -> {
                    styleTarget.string = string.strip();
                    list.children().removeIf(entry -> entry instanceof MessageEntry || entry instanceof OptionList.Entry.Text || entry instanceof OptionList.Entry.Space && list.children().indexOf(entry) > 4);
                    list.addChatMessages(list.recentChat);
                });
                stringField.setHint((Component)Localization.localized("option", "notif.trigger.style_target.field.hint", new Object[0]));
                this.elements.add(stringField);
                movingX = x + width - list.tinyWidgetWidth;
                this.elements.add(Button.builder((Component)Component.literal((String)Unicode.CROSS.str).withStyle(ChatFormatting.RED), button -> {
                    styleTarget.enabled = false;
                    list.init();
                }).pos(movingX, 0).size(list.tinyWidgetWidth, height).build());
            }
        }

        private static class TriggerOptions
        extends Entry {
            TriggerOptions(int x, int width, int height, TriggerEditorList list, Trigger trigger) {
                int triggerFieldWidth = width - list.tinyWidgetWidth * 2;
                int movingX = x;
                CycleButton typeButton = CycleButton.builder(type -> Component.literal((String)type.icon)).withValues((Object[])Trigger.Type.values()).displayOnlyValue().withInitialValue((Object)trigger.type).withTooltip(type -> Tooltip.create((Component)Localization.localized("option", "notif.trigger.type." + String.valueOf(type) + ".tooltip", new Object[0]))).create(movingX, 0, list.tinyWidgetWidth, height, (Component)Component.empty(), (button, type) -> {
                    trigger.type = type;
                    list.init();
                });
                typeButton.setTooltipDelay(Duration.ofMillis(500L));
                this.elements.add(typeButton);
                MultiLineTextField triggerField = new MultiLineTextField(movingX += list.tinyWidgetWidth, 0, triggerFieldWidth, height, (Component)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                if (trigger.type == Trigger.Type.REGEX) {
                    triggerField.regexValidator();
                }
                triggerField.setValueListener(str -> {
                    trigger.string = str.strip();
                    if (list.children().size() > 4) {
                        list.children().removeIf(entry -> entry instanceof MessageEntry || entry instanceof OptionList.Entry.Text || entry instanceof OptionList.Entry.Space && list.children().indexOf(entry) > 4);
                        list.addChatMessages(list.recentChat);
                    }
                });
                triggerField.setValue(trigger.string);
                this.elements.add(triggerField);
                Button styleButton = Button.builder((Component)Component.literal((String)"+"), button -> {
                    trigger.styleTarget.enabled = true;
                    list.init();
                }).pos(movingX += triggerFieldWidth, 0).size(list.tinyWidgetWidth, height).build();
                if (!trigger.styleTarget.enabled) {
                    styleButton.setTooltip(Tooltip.create((Component)Localization.localized("option", "notif.trigger.style_target.add.tooltip", new Object[0])));
                    styleButton.setTooltipDelay(Duration.ofMillis(500L));
                } else {
                    styleButton.active = false;
                }
                this.elements.add(styleButton);
            }
        }
    }
}

