/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.screen;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.list.FilterList;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.gui.widget.list.root.ControlList;
import dev.terminalmc.chatnotify.gui.widget.list.root.DefaultList;
import dev.terminalmc.chatnotify.gui.widget.list.root.DetectionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class RootScreen
extends OptionScreen {
    public RootScreen(Screen lastScreen) {
        this(lastScreen, TabKey.NOTIFICATION.key);
    }

    public RootScreen(Screen lastScreen, String defaultKey) {
        super(lastScreen);
        this.addTabs(defaultKey);
        this.updateTabTitles();
    }

    private void addTabs(String defaultKey) {
        List<OptionScreen.Tab> tabs = List.of(new OptionScreen.Tab(TabKey.NOTIFICATION.key, this::getNotificationList), new OptionScreen.Tab(TabKey.CONTROL.key, RootScreen::getControlList), new OptionScreen.Tab(TabKey.DEFAULT.key, RootScreen::getDefaultList), new OptionScreen.Tab(TabKey.DETECTION.key, RootScreen::getDetectionList));
        super.setTabs(tabs, defaultKey);
    }

    public void updateTabTitles() {
        for (TabKey tabKey : TabKey.values()) {
            this.updateTabTitle(tabKey);
        }
    }

    private void updateTabTitle(TabKey tabKey) {
        MutableComponent title = Component.translatable((String)tabKey.key);
        switch (tabKey.ordinal()) {
            case 0: {
                if (Config.get().getNotifs().isEmpty()) break;
                title.append(" ");
                title.append((Component)Localization.localized("common", "count", Config.get().getNotifs().size()));
            }
        }
        super.updateTabTitle(tabKey.key, (Component)title);
    }

    @Override
    protected void addFooter() {
        int spacing = 4;
        int buttonWidth = 116 - spacing;
        int buttonHeight = 20;
        int x1 = this.width / 2 - buttonWidth - spacing / 2;
        int x2 = this.width / 2 + spacing / 2;
        int y = Math.min(this.height - buttonHeight, this.height - 16 - buttonHeight / 2);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onCancel()).pos(x1, y).size(buttonWidth, buttonHeight).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).pos(x2, y).size(buttonWidth, buttonHeight).build());
    }

    private void onCancel() {
        Minecraft.getInstance().setScreen((Screen)new ConfirmScreen(confirm -> {
            if (confirm) {
                Config.reload();
                Minecraft.getInstance().setScreen((Screen)this);
                this.onClose();
            } else {
                Minecraft.getInstance().setScreen((Screen)this);
            }
        }, (Component)Localization.localized("option", "root.exit_without_saving", new Object[0]), (Component)Localization.localized("option", "root.exit_without_saving.confirm", new Object[0])));
    }

    @Override
    public void onClose() {
        super.onClose();
        Config.save();
    }

    private OptionList getNotificationList(OptionScreen screen) {
        return new FilterList<Notification>(Minecraft.getInstance(), screen, 0, 0, 0, 232, 20, 5, FilterList.Entry.NotifOptions.class, (srcIdx, dstIdx) -> {
            srcIdx = srcIdx + 1;
            dstIdx = dstIdx + 1;
            return Config.get().moveNotif((int)srcIdx, (int)dstIdx);
        }, () -> this.updateTabTitle(TabKey.NOTIFICATION), (Component)Localization.localized("option", "notif.list", Unicode.INFO.str), (Component)Localization.localized("option", "notif.list.tooltip", new Object[0]), null, null, () -> Config.get().getNotifs(), (x, width, height, list, notif, index) -> index == 0 ? new FilterList.Entry.NotifOptions.Locked(x, width, height, list, (Notification)notif) : new FilterList.Entry.NotifOptions(x, width, height, list, (Notification)notif, index), null, () -> Config.get().addNotif());
    }

    private static OptionList getControlList(OptionScreen screen) {
        return new ControlList(Minecraft.getInstance(), screen, 0, 0, 0, 232, 20, 5);
    }

    private static OptionList getDetectionList(OptionScreen screen) {
        return new DetectionList(Minecraft.getInstance(), screen, 0, 0, 0, 232, 20, 5);
    }

    private static OptionList getDefaultList(OptionScreen screen) {
        return new DefaultList(Minecraft.getInstance(), screen, 0, 0, 0, 232, 20, 5);
    }

    public static enum TabKey {
        NOTIFICATION(Localization.translationKey("option", "notif")),
        CONTROL(Localization.translationKey("option", "control")),
        DEFAULT(Localization.translationKey("option", "default")),
        DETECTION(Localization.translationKey("option", "detection"));

        public final String key;

        private TabKey(String key) {
            this.key = key;
        }
    }
}

