/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.screen;

import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.gui.widget.list.root.notif.trigger.KeySelectorList;
import dev.terminalmc.chatnotify.gui.widget.list.root.notif.trigger.TriggerEditorList;
import dev.terminalmc.chatnotify.util.Localization;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class TriggerScreen
extends OptionScreen {
    private final Trigger trigger;
    private final TextStyle textStyle;
    private final Runnable onClose;

    public TriggerScreen(Screen lastScreen, Trigger trigger, TextStyle textStyle, Runnable onClose, String defaultKey) {
        super(lastScreen);
        this.trigger = trigger;
        this.textStyle = textStyle;
        this.onClose = onClose;
        this.addTabs(defaultKey);
    }

    private void addTabs(String defaultKey) {
        List<OptionScreen.Tab> tabs = List.of(new OptionScreen.Tab(TabKey.TRIGGER_EDITOR.key, TriggerScreen::getTriggerEditorList), new OptionScreen.Tab(TabKey.KEY_SELECTOR.key, TriggerScreen::getKeySelectorList));
        super.setTabs(tabs, defaultKey);
    }

    @Override
    public void onClose() {
        this.onClose.run();
        super.onClose();
    }

    private static OptionList getTriggerEditorList(OptionScreen screen) {
        return new TriggerEditorList(Minecraft.getInstance(), screen, 0, 0, 0, 232, 20, 5, TriggerScreen.cast((OptionScreen)screen).trigger, TriggerScreen.cast((OptionScreen)screen).textStyle);
    }

    private static OptionList getKeySelectorList(OptionScreen screen) {
        return new KeySelectorList(Minecraft.getInstance(), screen, 0, 0, 0, 232, 20, TriggerScreen.cast((OptionScreen)screen).trigger);
    }

    private static TriggerScreen cast(OptionScreen screen) {
        if (!(screen instanceof TriggerScreen)) {
            throw new IllegalArgumentException(String.format("Option list supplier for class %s cannot use screen type %s", TriggerScreen.class.getName(), ((Object)((Object)screen)).getClass().getName()));
        }
        TriggerScreen s = (TriggerScreen)screen;
        return s;
    }

    public static enum TabKey {
        TRIGGER_EDITOR(Localization.translationKey("option", "notif.trigger.editor")),
        KEY_SELECTOR(Localization.translationKey("option", "notif.trigger.selector"));

        public final String key;

        private TabKey(String key) {
            this.key = key;
        }
    }
}

