/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget;

import dev.terminalmc.chatnotify.gui.widget.OverlayWidget;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.inject.IGuiGraphics;
import dev.terminalmc.chatnotify.util.text.ColorUtil;
import java.awt.Color;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class HsvColorPicker
extends OverlayWidget {
    public static final int GUI_SHADOW = -1610612736;
    public static final int GUI_LIGHT = -6250336;
    public static final int GUI_DARK = -13882324;
    public static final int ARGB_WHITE = -1;
    public static final int ARGB_RED = -65536;
    public static final int ARGB_YELLOW = -256;
    public static final int ARGB_GREEN = -16711936;
    public static final int ARGB_CYAN = -16711681;
    public static final int ARGB_BLUE = -16776961;
    public static final int ARGB_MAGENTA = -65281;
    public static final int[] ARGB_GRADIENT = new int[]{-65536, -256, -16711936, -16711681, -16776961, -65281, -65536};
    public static final int MIN_WIDTH = 200;
    public static final int MIN_HEIGHT = 80;
    public static final int MAX_WIDTH = 400;
    public static final int MAX_HEIGHT = 300;
    public static final int BORDER = 2;
    public static final int OUTLINE = 1;
    public static final int CURSOR = 1;
    private final String newColorLabel = " " + Localization.localized("common", "new", new Object[0]).getString() + " ";
    private final String oldColorLabel = " " + Localization.localized("common", "old", new Object[0]).getString() + " ";
    private final Supplier<Integer> source;
    private final Consumer<Integer> dest;
    private boolean hasClickedOnH = false;
    private boolean hasClickedOnSv = false;
    private int hsvPickerBoxWidth;
    private int svFieldX;
    private int svFieldY;
    private int svFieldWidth;
    private int svFieldHeight;
    private int svCursorX;
    private int svCursorY;
    private int hFieldX;
    private int hFieldY;
    private int hFieldWidth;
    private int hFieldHeight;
    private int hSecSize;
    private int hCursorY;
    private int newCFieldX;
    private int newCFieldY;
    private int newCFieldWidth;
    private int newCFieldHeight;
    private int newCFieldTextX;
    private int newCFieldTextY;
    private int oldCFieldX;
    private int oldCFieldY;
    private int oldCFieldWidth;
    private int oldCFieldHeight;
    private int oldCFieldTextX;
    private int oldCFieldTextY;
    private TextField hexField;
    private Button cancelButton;
    private Button confirmButton;
    private final float[] hsv = new float[3];
    private int oldColor;
    private boolean updateFromCursor;

    public HsvColorPicker(int x, int y, int width, int height, Supplier<Integer> source, Consumer<Integer> dest, Consumer<OverlayWidget> close) {
        super(x, y, width, height, true, (Component)Component.empty(), close);
        this.source = source;
        this.dest = dest;
        this.updateColorFromSource();
        this.init();
    }

    @Override
    protected void init() {
        Minecraft mc = Minecraft.getInstance();
        int hexFieldHeight = 20;
        int minColorBoxWidth = 12;
        int interiorWidth = this.width - 4;
        int interiorHeight = this.height - 4;
        this.hsvPickerBoxWidth = interiorWidth / 2;
        this.hFieldWidth = minColorBoxWidth;
        this.hSecSize = (interiorHeight - 2) / 6;
        this.hFieldHeight = this.hSecSize * 6;
        this.svFieldWidth = this.hsvPickerBoxWidth - this.hFieldWidth - 4 - 4;
        this.svFieldHeight = this.hFieldHeight;
        this.svFieldX = 3;
        this.hFieldX = this.svFieldX + this.svFieldWidth + 2 + 2;
        this.svFieldY = this.hFieldY = 3 + (interiorHeight - (this.hFieldHeight + 2)) / 2;
        Font font = mc.font;
        int hexFieldX = 2 + this.hsvPickerBoxWidth;
        int hexFieldY = 2;
        int hexFieldWidth = interiorWidth - this.hsvPickerBoxWidth;
        this.hexField = new TextField(this.getX() + hexFieldX, this.getY() + hexFieldY, hexFieldWidth, hexFieldHeight);
        this.hexField.strict().hexColorValidator();
        this.hexField.setMaxLength(7);
        this.hexField.setResponder(this::updateColorFromHexField);
        this.hexField.setValue(((TextColorAccessor)TextColor.fromRgb((int)Color.HSBtoRGB(this.hsv[0], this.hsv[1], this.hsv[2]))).chatnotify$formatValue());
        int cancelButtonWidth = interiorWidth - this.hsvPickerBoxWidth - this.hsvPickerBoxWidth / 2;
        int buttonHeight = 20;
        int cancelButtonX = 2 + this.hsvPickerBoxWidth;
        int buttonY = 2 + interiorHeight - buttonHeight;
        this.cancelButton = Button.builder((Component)CommonComponents.GUI_CANCEL, button -> this.onClose()).pos(this.getX() + cancelButtonX, this.getY() + buttonY).size(cancelButtonWidth, buttonHeight).build();
        int confirmButtonWidth = interiorWidth - this.hsvPickerBoxWidth - cancelButtonWidth;
        int confirmButtonX = 2 + this.hsvPickerBoxWidth + cancelButtonWidth;
        this.confirmButton = Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.dest.accept(Mth.hsvToRgb((float)this.hsv[0], (float)this.hsv[1], (float)this.hsv[2]));
            this.onClose();
        }).pos(this.getX() + confirmButtonX, this.getY() + buttonY).size(confirmButtonWidth, buttonHeight).build();
        int cFieldTextWidth = Math.min(Math.max(font.width(this.newColorLabel), font.width(this.oldColorLabel)), interiorWidth - this.hsvPickerBoxWidth - minColorBoxWidth);
        int combinedCFieldHeight = interiorHeight - hexFieldHeight - buttonHeight - 4;
        this.newCFieldWidth = hexFieldWidth - cFieldTextWidth - 2;
        this.newCFieldHeight = combinedCFieldHeight / 2;
        this.newCFieldX = hexFieldX + cFieldTextWidth + 1;
        this.newCFieldY = hexFieldY + hexFieldHeight + 1;
        this.newCFieldTextX = this.getX() + this.newCFieldX - cFieldTextWidth - 1;
        int n = this.getY() + this.newCFieldY;
        Objects.requireNonNull(font);
        this.newCFieldTextY = n + (this.newCFieldHeight - 9) / 2;
        this.oldCFieldWidth = this.newCFieldWidth;
        this.oldCFieldHeight = combinedCFieldHeight - this.newCFieldHeight;
        this.oldCFieldX = this.newCFieldX;
        this.oldCFieldY = this.newCFieldY + this.newCFieldHeight + 2;
        this.oldCFieldTextX = this.newCFieldTextX;
        int n2 = this.getY() + this.oldCFieldY;
        Objects.requireNonNull(font);
        this.oldCFieldTextY = n2 + (this.oldCFieldHeight - 9) / 2;
    }

    @Override
    public int getMinWidth() {
        return 200;
    }

    @Override
    public int getMaxWidth() {
        return 400;
    }

    @Override
    public int getMinHeight() {
        return 80;
    }

    @Override
    public int getMaxHeight() {
        return 300;
    }

    public void updateColorFromSource() {
        int color = this.source.get();
        Color.RGBtoHSB(FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color), this.hsv);
        this.oldColor = color;
        if (this.hexField != null) {
            this.hexField.setValue(((TextColorAccessor)TextColor.fromRgb((int)color)).chatnotify$formatValue());
        }
    }

    private void updateHexField() {
        this.updateFromCursor = true;
        int color = Color.HSBtoRGB(this.hsv[0], this.hsv[1], this.hsv[2]);
        this.hexField.setValue(((TextColorAccessor)TextColor.fromRgb((int)color)).chatnotify$formatValue());
        this.updateFromCursor = false;
    }

    private void updateColorFromHexField(String s) {
        TextColor textColor = ColorUtil.parseColor(s);
        if (textColor != null) {
            int color = textColor.getValue();
            if (!this.updateFromCursor) {
                Color.RGBtoHSB(FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color), this.hsv);
                this.updateHCursor();
                this.updateSvCursor();
            }
            if ((double)this.hsv[2] < 0.1) {
                this.hexField.setTextColor(0xFFFFFF);
            } else {
                this.hexField.setTextColor(color);
            }
        }
    }

    private void updateHCursor() {
        this.hCursorY = this.hFieldY + (int)(this.hsv[0] * (float)this.hFieldHeight);
    }

    private void updateSvCursor() {
        this.svCursorX = this.svFieldX + (int)(this.hsv[1] * (float)this.svFieldWidth);
        this.svCursorY = this.svFieldY + (int)((1.0f - this.hsv[2]) * (float)this.svFieldHeight);
    }

    private void updateHFromCursor(double cursorY) {
        this.hsv[0] = (float)cursorY / (float)this.hFieldHeight;
        this.updateHexField();
    }

    private void updateSvFromCursor(double cursorX, double cursorY) {
        this.hsv[1] = (float)cursorX / (float)this.svFieldWidth;
        this.hsv[2] = 1.0f - (float)cursorY / (float)this.svFieldHeight;
        this.updateHexField();
    }

    private float getHFromCursor() {
        return ((float)this.hCursorY - (float)this.hFieldY) / (float)this.hFieldHeight;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.hexField.isFocused()) {
            return this.hexField.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (this.hexField.isFocused()) {
            return this.hexField.charTyped(chr, modifiers);
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.hasClickedOnH = false;
        this.hasClickedOnSv = false;
        if (this.mouseOnElement(mouseX, mouseY, this.getX(), this.getY(), this.width, this.height).isPresent()) {
            if (this.mouseOnWidget((AbstractWidget)this.hexField, mouseX, mouseY)) {
                if (!this.hexField.isFocused()) {
                    this.hexField.setFocused(true);
                } else {
                    this.hexField.mouseClicked(mouseX, mouseY, button);
                }
                return true;
            }
            this.hexField.setFocused(false);
            if (button == 0) {
                Optional<double[]> hFieldCursor = this.mouseOnElement(mouseX, mouseY, this.getX() + this.hFieldX, this.getY() + this.hFieldY, this.hFieldWidth, this.hFieldHeight);
                if (hFieldCursor.isPresent()) {
                    this.hasClickedOnH = true;
                    this.hCursorY = (int)hFieldCursor.get()[1] + this.hFieldY;
                    this.updateHFromCursor(hFieldCursor.get()[1]);
                    return true;
                }
                Optional<double[]> svFieldCursor = this.mouseOnElement(mouseX, mouseY, this.getX() + this.svFieldX, this.getY() + this.svFieldY, this.svFieldWidth, this.svFieldHeight);
                if (svFieldCursor.isPresent()) {
                    this.hasClickedOnSv = true;
                    this.svCursorX = (int)svFieldCursor.get()[0] + this.svFieldX;
                    this.svCursorY = (int)svFieldCursor.get()[1] + this.svFieldY;
                    this.updateSvFromCursor(svFieldCursor.get()[0], svFieldCursor.get()[1]);
                    return true;
                }
                if (this.mouseOnWidget((AbstractWidget)this.cancelButton, mouseX, mouseY)) {
                    this.cancelButton.mouseClicked(mouseX, mouseY, button);
                    return true;
                }
                if (this.mouseOnWidget((AbstractWidget)this.confirmButton, mouseX, mouseY)) {
                    this.confirmButton.mouseClicked(mouseX, mouseY, button);
                    return true;
                }
            }
        } else {
            this.onClose();
        }
        return true;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.hasClickedOnH) {
            double cursorY = mouseY - (double)this.getY();
            if (cursorY < (double)this.hFieldY) {
                cursorY = this.hFieldY;
            } else if (cursorY > (double)(this.hFieldY + this.hFieldHeight)) {
                cursorY = this.hFieldY + this.hFieldHeight;
            }
            this.updateHFromCursor(cursorY - (double)this.hFieldY);
            this.hCursorY = (int)cursorY;
            return true;
        }
        if (this.hasClickedOnSv) {
            double cursorX = mouseX - (double)this.getX();
            double cursorY = mouseY - (double)this.getY();
            if (cursorX < (double)this.svFieldX) {
                cursorX = this.svFieldX;
            } else if (cursorX > (double)(this.svFieldX + this.svFieldWidth)) {
                cursorX = this.svFieldX + this.svFieldWidth;
            }
            if (cursorY < (double)this.svFieldY) {
                cursorY = this.svFieldY;
            } else if (cursorY > (double)(this.svFieldY + this.svFieldHeight)) {
                cursorY = this.svFieldY + this.svFieldHeight;
            }
            this.updateSvFromCursor(cursorX - (double)this.svFieldX, cursorY - (double)this.svFieldY);
            this.svCursorX = (int)cursorX;
            this.svCursorY = (int)cursorY;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    private boolean mouseOnWidget(AbstractWidget widget, double mouseX, double mouseY) {
        Optional<double[]> mouseOnWidget = this.mouseOnElement(mouseX, mouseY, widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight());
        return mouseOnWidget.isPresent();
    }

    private Optional<double[]> mouseOnElement(double mouseX, double mouseY, int elementX, int elementY, int elementWidth, int elementHeight) {
        if ((double)elementX <= mouseX && mouseX < (double)(elementX + elementWidth) && (double)elementY <= mouseY && mouseY < (double)(elementY + elementHeight)) {
            return Optional.of(new double[]{mouseX - (double)elementX, mouseY - (double)elementY});
        }
        return Optional.empty();
    }

    protected void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.drawColorPicker(graphics);
        graphics.drawString(Minecraft.getInstance().font, this.newColorLabel, this.newCFieldTextX, this.newCFieldTextY, 0xFFFFFF);
        graphics.drawString(Minecraft.getInstance().font, this.oldColorLabel, this.oldCFieldTextX, this.oldCFieldTextY, 0xFFFFFF);
        this.hexField.renderWidget(graphics, mouseX, mouseY, delta);
        this.cancelButton.render(graphics, mouseX, mouseY, delta);
        this.confirmButton.render(graphics, mouseX, mouseY, delta);
    }

    private void drawColorPicker(@NotNull GuiGraphics graphics) {
        int left = this.getX();
        int top = this.getY();
        int right = left + this.width;
        int bottom = top + this.height;
        int insideL = left + 2;
        int insideT = top + 2;
        int insideR = right - 2;
        int insideB = bottom - 2;
        int svL = left + this.svFieldX;
        int svT = top + this.svFieldY;
        int svR = svL + this.svFieldWidth;
        int svB = svT + this.svFieldHeight;
        int hL = left + this.hFieldX;
        int hT = top + this.hFieldY;
        int hR = hL + this.hFieldWidth;
        int hB = hT + this.hFieldHeight;
        int ncL = left + this.newCFieldX;
        int ncT = top + this.newCFieldY;
        int ncR = ncL + this.newCFieldWidth;
        int ncB = ncT + this.newCFieldHeight;
        int ocL = left + this.oldCFieldX;
        int ocT = top + this.oldCFieldY;
        int ocR = ocL + this.oldCFieldWidth;
        int ocB = ocT + this.oldCFieldHeight;
        graphics.fill(0, 0, graphics.guiWidth(), graphics.guiHeight(), -1610612736);
        graphics.fill(left, top, right, bottom, -6250336);
        graphics.fill(insideL, insideT, insideR, insideB, -13882324);
        graphics.fill(insideL, insideT, insideL + this.hsvPickerBoxWidth, insideB, -6250336);
        graphics.fill(svL - 1, svT - 1, svR + 1, svB + 1, -13882324);
        graphics.fill(svL, svT, svR, svB, -1);
        int rgb = Color.HSBtoRGB(this.getHFromCursor(), 1.0f, 1.0f);
        ((IGuiGraphics)graphics).chatnotify$fillGradientHorizontal(svL, svT, svR, svB, rgb & 0xFFFFFF, 0xFF000000 | rgb);
        graphics.fillGradient(svL, svT, svR, svB, 0, -16777216);
        int limitSvCursorY = top + Math.min(this.svCursorY, this.svFieldY + this.svFieldHeight - 1);
        graphics.fill(svL, limitSvCursorY, svR, limitSvCursorY + 1, -6250336);
        int limitSvCursorX = left + Math.min(this.svCursorX, this.svFieldX + this.svFieldWidth - 1);
        graphics.fill(limitSvCursorX, svT, limitSvCursorX + 1, svB, -6250336);
        graphics.fill(hL - 1, hT - 1, hR + 1, hB + 1, -13882324);
        int start = hT;
        int end = start + this.hSecSize;
        for (int i = 0; i < ARGB_GRADIENT.length - 1; ++i) {
            graphics.fillGradient(hL, start, hR, end, ARGB_GRADIENT[i], ARGB_GRADIENT[i + 1]);
            start = end;
            end += this.hSecSize;
        }
        int limitHCursorY = Math.min(this.hCursorY, this.hFieldY + this.hFieldHeight - 1);
        graphics.fill(hL, top + limitHCursorY, hR, top + limitHCursorY + 1, -6250336);
        graphics.fill(ncL - 1, ncT - 1, ncR + 1, ncB + 1, -6250336);
        rgb = Mth.hsvToRgb((float)this.hsv[0], (float)this.hsv[1], (float)this.hsv[2]);
        graphics.fill(ncL, ncT, ncR, ncB, 0xFF000000 | rgb);
        graphics.fill(ocL - 1, ocT - 1, ocR + 1, ocB + 1, -6250336);
        graphics.fill(ocL, ocT, ocR, ocB, 0xFF000000 | this.oldColor);
    }
}

