/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root;

import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.field.DropdownTextField;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.text.ColorUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.options.SoundOptionsScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;

public class DefaultList
extends OptionList {
    public DefaultList(Minecraft mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, entrySpacing);
    }

    @Override
    protected void addEntries() {
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (Component)Localization.localized("option", "default.list", Unicode.INFO.str), Tooltip.create((Component)Localization.localized("option", "default.list.tooltip", new Object[0])), -1));
        this.addEntry((AbstractSelectionList.Entry)new Entry.DefaultColor(this.entryX, this.entryWidth, this.entryHeight, this));
        this.addEntry((AbstractSelectionList.Entry)new Entry.DefaultSound(this.entryX, this.entryWidth, this.entryHeight, this));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.DoubleSlider(this.entryX, this.entryWidth, this.entryHeight, 0.0, 1.0, 2, Localization.localized("option", "notif.sound.volume", new Object[0]).getString(), null, CommonComponents.OPTION_OFF.getString(), null, () -> Config.get().defaultSound.getVolume(), value -> Config.get().defaultSound.setVolume(value.floatValue())));
        this.addEntry((AbstractSelectionList.Entry)new OptionList.Entry.DoubleSlider(this.entryX, this.entryWidth, this.entryHeight, 0.5, 2.0, 2, Localization.localized("option", "notif.sound.pitch", new Object[0]).getString(), null, null, null, () -> Config.get().defaultSound.getPitch(), value -> Config.get().defaultSound.setPitch(value.floatValue())));
        this.addEntry((AbstractSelectionList.Entry)new Entry.SoundSource(this.entryX, this.entryWidth, this.entryHeight, this));
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class SoundSource
        extends Entry {
            SoundSource(int x, int width, int height, DefaultList list) {
                this.elements.add(CycleButton.builder(source -> Component.translatable((String)("soundCategory." + source.getName()))).withValues((Object[])net.minecraft.sounds.SoundSource.values()).withInitialValue((Object)Config.get().soundSource).withTooltip(status -> Tooltip.create((Component)Localization.localized("option", "notif.sound.source.tooltip", new Object[0]))).create(x, 0, width - list.smallWidgetWidth - 4, height, (Component)Localization.localized("option", "notif.sound.source", new Object[0]), (button, status) -> {
                    Config.get().soundSource = status;
                }));
                this.elements.add(Button.builder((Component)Component.literal((String)Unicode.SOUND.str), button -> Minecraft.getInstance().setScreen((Screen)new SoundOptionsScreen((Screen)list.screen, Minecraft.getInstance().options))).tooltip(Tooltip.create((Component)Localization.localized("option", "notif.sound.open.minecraft_volume", new Object[0]))).pos(x + width - list.smallWidgetWidth, 0).size(list.smallWidgetWidth, height).build());
            }
        }

        private static class DefaultSound
        extends Entry {
            DefaultSound(int x, int width, int height, DefaultList list) {
                this.elements.add(Button.builder((Component)Localization.localized("option", "default.sound", Config.get().defaultSound.getId()), button -> {
                    int wHeight = Math.max(40, list.height);
                    int wWidth = Math.max(80, list.dynWideEntryWidth);
                    int wX = x + width / 2 - wWidth / 2;
                    int wY = list.getY();
                    list.screen.setOverlayWidget(new DropdownTextField(wX, wY, wWidth, wHeight, (Component)Component.empty(), Config.get().defaultSound::getId, Config.get().defaultSound::setId, widget -> list.init(), Minecraft.getInstance().getSoundManager().getAvailableSounds().stream().map(ResourceLocation::toString).sorted().toList()).withSoundDropType());
                }).pos(x, 0).size(width, height).build());
            }
        }

        private static class DefaultColor
        extends Entry {
            DefaultColor(int x, int width, int height, DefaultList list) {
                int colorFieldWidth = Minecraft.getInstance().font.width("#FFAAFF+++");
                Button mainButton = Button.builder((Component)Localization.localized("option", "default.color", new Object[0]).setStyle(Style.EMPTY.withColor(Config.get().defaultColor)), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.screen.setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, ((DefaultList)list).screen.height / 2 - cpHeight / 2, cpWidth, cpHeight, () -> Config.get().defaultColor, val -> {
                        Config.get().defaultColor = val;
                    }, widget -> list.init()));
                }).pos(x, 0).size(width - colorFieldWidth - 4, height).build();
                this.elements.add(mainButton);
                TextField colorField = new TextField(x + width - colorFieldWidth, 0, colorFieldWidth, height);
                colorField.hexColorValidator().strict();
                colorField.setMaxLength(7);
                colorField.setResponder(val -> {
                    TextColor textColor = ColorUtil.parseColor(val);
                    if (textColor != null) {
                        int color;
                        Config.get().defaultColor = color = textColor.getValue();
                        mainButton.setMessage((Component)Localization.localized("option", "default.color", new Object[0]).setStyle(Style.EMPTY.withColor(textColor)));
                        float[] hsv = new float[3];
                        Color.RGBtoHSB(FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color), hsv);
                        if ((double)hsv[2] < 0.1) {
                            colorField.setTextColor(0xFFFFFF);
                        } else {
                            colorField.setTextColor(color);
                        }
                    }
                });
                colorField.setValue(((TextColorAccessor)TextColor.fromRgb((int)Config.get().defaultColor)).chatnotify$formatValue());
                this.elements.add(colorField);
            }
        }
    }
}

