/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.slider;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class DoubleSlider
extends AbstractSliderButton {
    protected final double min;
    protected final double max;
    protected final double range;
    protected final int precision;
    protected final String messagePrefix;
    protected final String messageSuffix;
    protected final String valueNameMin;
    protected final String valueNameMax;
    protected final Supplier<Double> source;
    protected final Consumer<Double> dest;

    public DoubleSlider(int x, int y, int width, int height, double min, double max, int precision, @Nullable String messagePrefix, @Nullable String messageSuffix, @Nullable String valueNameMin, @Nullable String valueNameMax, Supplier<Double> source, Consumer<Double> dest) {
        super(x, y, width, height, (Component)Component.empty(), (source.get() - min) / (max - min));
        this.min = min;
        this.max = max;
        this.range = max - min;
        this.precision = precision;
        this.messagePrefix = messagePrefix;
        this.messageSuffix = messageSuffix;
        this.valueNameMin = valueNameMin;
        this.valueNameMax = valueNameMax;
        this.source = source;
        this.dest = dest;
        this.updateMessage();
    }

    public void refresh() {
        this.value = (this.source.get() - this.min) / this.range;
        this.updateMessage();
    }

    protected void updateMessage() {
        double messageValue = this.round(this.value * this.range + this.min, this.precision);
        String valueStr = String.valueOf(messageValue);
        if (this.value == 0.0 && this.valueNameMin != null) {
            valueStr = this.valueNameMin;
        } else if (this.value == 1.0 && this.valueNameMax != null) {
            valueStr = this.valueNameMax;
        }
        StringBuilder messageBuilder = new StringBuilder(valueStr);
        if (this.messagePrefix != null) {
            messageBuilder.insert(0, this.messagePrefix);
        }
        if (this.messageSuffix != null) {
            messageBuilder.append(this.messageSuffix);
        }
        this.setMessage((Component)Component.literal((String)messageBuilder.toString()));
    }

    protected void applyValue() {
        this.dest.accept(this.round(this.value * this.range + this.min, this.precision));
    }

    protected double round(double value, int precision) {
        int scale = (int)Math.pow(10.0, precision);
        return (double)Math.round(value * (double)scale) / (double)scale;
    }
}

