/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.config.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import dev.terminalmc.chatnotify.ChatNotify;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class JsonUtil {
    public static final String LOG_STR = "Unable to deserialize key '{}' with type '{}': {}. Using default value.";
    public static boolean hasChanged = false;

    private JsonUtil() {
    }

    public static void reset() {
        hasChanged = false;
    }

    public static boolean getOrDefault(JsonObject obj, String key, boolean def, boolean silent) {
        JsonPrimitive element = JsonUtil.getAsJsonPrimitiveOrNull(obj, key, Boolean.class.getName(), silent);
        if (element == null) {
            return def;
        }
        if (!element.getAsJsonPrimitive().isBoolean()) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, Boolean.class.getName(), "Value '%s' is not Boolean".formatted(element));
            }
            hasChanged = true;
            return def;
        }
        return element.getAsBoolean();
    }

    public static int getOrDefault(JsonObject obj, String key, int def, boolean silent) {
        Number value = JsonUtil.getAsNumberOrNull(obj, key, Integer.class.getName(), silent);
        if (value == null) {
            return def;
        }
        return value.intValue();
    }

    public static float getOrDefault(JsonObject obj, String key, float def, boolean silent) {
        Number value = JsonUtil.getAsNumberOrNull(obj, key, Float.class.getName(), silent);
        if (value == null) {
            return def;
        }
        return value.floatValue();
    }

    public static long getOrDefault(JsonObject obj, String key, long def, boolean silent) {
        Number value = JsonUtil.getAsNumberOrNull(obj, key, Long.class.getName(), silent);
        if (value == null) {
            return def;
        }
        return value.longValue();
    }

    public static double getOrDefault(JsonObject obj, String key, double def, boolean silent) {
        Number value = JsonUtil.getAsNumberOrNull(obj, key, Double.class.getName(), silent);
        if (value == null) {
            return def;
        }
        return value.doubleValue();
    }

    public static <T extends Enum<T>> T getOrDefault(JsonObject obj, String key, Class<T> cls, T def, boolean silent) {
        String value = JsonUtil.getAsStringOrNull(obj, key, cls.getName(), silent);
        if (value == null) {
            return def;
        }
        for (Enum enumVal : (Enum[])cls.getEnumConstants()) {
            if (!enumVal.name().equals(value)) continue;
            return (T)enumVal;
        }
        if (!silent) {
            ChatNotify.LOG.error(LOG_STR, key, cls.getName(), "Value '%s' is not in Enum Constants".formatted(value));
        }
        hasChanged = true;
        return def;
    }

    public static String getOrDefault(JsonObject obj, String key, String def, boolean silent) {
        String value = JsonUtil.getAsStringOrNull(obj, key, String.class.getName(), silent);
        if (value == null) {
            return def;
        }
        return value;
    }

    public static <T> T getOrDefault(JsonDeserializationContext ctx, JsonObject obj, String key, Class<T> cls, T def, boolean silent) throws JsonParseException {
        JsonObject element = JsonUtil.getAsJsonObjectOrNull(obj, key, cls.getName(), silent);
        if (element == null) {
            return def;
        }
        return (T)ctx.deserialize((JsonElement)element, cls);
    }

    public static List<String> getOrDefault(JsonObject obj, String key, List<String> def, boolean silent) {
        JsonArray array = JsonUtil.getAsJsonArrayOrNull(obj, key, String.class.getName(), silent);
        if (array == null) {
            return def;
        }
        return array.asList().stream().filter(je -> je.isJsonPrimitive() && je.getAsJsonPrimitive().isString()).map(JsonElement::getAsString).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T> List<T> getOrDefault(JsonDeserializationContext ctx, JsonObject obj, String key, Class<T> cls, List<T> def, boolean silent) throws JsonParseException {
        JsonArray array = JsonUtil.getAsJsonArrayOrNull(obj, key, cls.getName(), silent);
        if (array == null) {
            return def;
        }
        return array.asList().stream().filter(JsonElement::isJsonObject).map(je -> ctx.deserialize(je, (Type)cls)).toList().stream().filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    @Nullable
    private static JsonPrimitive getAsJsonPrimitiveOrNull(JsonObject obj, String key, String clsName, boolean silent) {
        if (!obj.has(key)) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, clsName, "Key not found");
            }
            hasChanged = true;
            return null;
        }
        JsonElement element = obj.get(key);
        if (!element.isJsonPrimitive()) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, clsName, "Value '%s' is not JsonPrimitive".formatted(element));
            }
            hasChanged = true;
            return null;
        }
        return element.getAsJsonPrimitive();
    }

    @Nullable
    private static JsonObject getAsJsonObjectOrNull(JsonObject obj, String key, String clsName, boolean silent) {
        if (!obj.has(key)) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, clsName, "Key not found");
            }
            hasChanged = true;
            return null;
        }
        JsonElement element = obj.get(key);
        if (!element.isJsonObject()) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, clsName, "Value '%s' is not JsonObject".formatted(element));
            }
            hasChanged = true;
            return null;
        }
        return element.getAsJsonObject();
    }

    @Nullable
    private static JsonArray getAsJsonArrayOrNull(JsonObject obj, String key, String clsName, boolean silent) {
        if (!obj.has(key)) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, clsName, "Key not found");
            }
            hasChanged = true;
            return null;
        }
        JsonElement element = obj.get(key);
        if (!element.isJsonArray()) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, clsName, "Value '%s' is not JsonArray".formatted(element));
            }
            hasChanged = true;
            return null;
        }
        return element.getAsJsonArray();
    }

    @Nullable
    private static Number getAsNumberOrNull(JsonObject obj, String key, String clsName, boolean silent) {
        JsonPrimitive element = JsonUtil.getAsJsonPrimitiveOrNull(obj, key, clsName, silent);
        if (element == null) {
            return null;
        }
        if (!element.getAsJsonPrimitive().isNumber()) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, clsName, "Value '%s' is not Number".formatted(element));
            }
            hasChanged = true;
            return null;
        }
        return element.getAsNumber();
    }

    @Nullable
    private static String getAsStringOrNull(JsonObject obj, String key, String clsName, boolean silent) {
        JsonPrimitive element = JsonUtil.getAsJsonPrimitiveOrNull(obj, key, clsName, silent);
        if (element == null) {
            return null;
        }
        if (!element.getAsJsonPrimitive().isString()) {
            if (!silent) {
                ChatNotify.LOG.error(LOG_STR, key, clsName, "Value '%s' is not String".formatted(element));
            }
            hasChanged = true;
            return null;
        }
        return element.getAsString();
    }
}

