/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify;

import com.mojang.datafixers.util.Pair;
import dev.terminalmc.chatnotify.compat.commandkeys.CommandKeysWrapper;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.StyleTarget;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.ModLogger;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_634;

public class ChatNotify {
    public static final String MOD_ID = "chatnotify";
    public static final String MOD_NAME = "ChatNotify";
    public static final ModLogger LOG = new ModLogger("ChatNotify");
    public static boolean hasResetConfig = false;
    public static final List<Pair<Long, String>> recentMessages = new ArrayList<Pair<Long, String>>();
    public static final List<Response> RESPONSES = new ArrayList<Response>();
    public static final Queue<class_2561> unmodifiedChat = new LinkedList<class_2561>();

    public static void init() {
        Config.getAndSave();
    }

    public static void onConfigSaved(Config config) {
        for (Notification notif : config.getNotifs()) {
            for (Trigger trig : notif.triggers) {
                if (trig.type == Trigger.Type.REGEX) {
                    trig.tryCompilePattern();
                }
                if (trig.styleTarget.type == StyleTarget.Type.REGEX) {
                    trig.styleTarget.tryCompilePattern();
                    continue;
                }
                if (trig.styleTarget.type != StyleTarget.Type.CAPTURING) continue;
                trig.styleTarget.tryParseIndexes();
            }
            for (Trigger trig : notif.exclusionTriggers) {
                if (trig.type != Trigger.Type.REGEX) continue;
                trig.tryCompilePattern();
            }
        }
    }

    public static void afterClientTick(class_310 mc) {
        ChatNotify.tickResponses(mc);
        if (hasResetConfig && mc.field_1755 instanceof class_442) {
            hasResetConfig = false;
            mc.method_1566().method_1999((class_368)new class_370(class_370.class_371.field_39915, (class_2561)Localization.localized("toast", "reset.title", new Object[0]), (class_2561)Localization.localized("toast", "reset.message", class_2561.method_43470((String)"chatnotify.unreadable.json").method_27692(class_124.field_1065))));
        }
    }

    private static void tickResponses(class_310 mc) {
        if (mc.method_1562() == null || !mc.method_1562().method_48106()) {
            RESPONSES.clear();
            return;
        }
        ArrayList<String> sending = new ArrayList<String>();
        RESPONSES.removeIf(resMsg -> {
            if (--resMsg.countdown <= 0) {
                if (resMsg.sendingString != null && !resMsg.sendingString.isBlank()) {
                    if (resMsg.type.equals((Object)Response.Type.COMMANDKEYS)) {
                        CommandKeysWrapper.trySend(resMsg.sendingString);
                    } else {
                        sending.add(resMsg.sendingString);
                    }
                }
                return true;
            }
            return false;
        });
        ChatNotify.sendMessages(sending, mc.method_1562());
    }

    private static void sendMessages(List<String> messages, class_634 connection) {
        if (messages.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        switch (Config.get().sendMode) {
            case SCREEN: {
                Object object;
                class_437 oldScreen = mc.field_1755;
                if (!(mc.field_1755 instanceof class_408)) {
                    mc.method_1507((class_437)new class_408(""));
                }
                if ((object = mc.field_1755) instanceof class_408) {
                    class_408 cs = (class_408)object;
                    for (String msg : messages) {
                        cs.method_44056(msg, false);
                    }
                }
                mc.method_1507(oldScreen);
                break;
            }
            case PACKET: {
                for (String msg : messages) {
                    if (msg.startsWith("/")) {
                        connection.method_45730(msg.substring(1));
                        continue;
                    }
                    connection.method_45729(msg);
                }
                break;
            }
        }
    }

    public static void updateUsernameNotif(Config config) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null) {
            config.setProfileName(FormatUtil.stripCodes(mc.field_1724.method_5477().getString()));
            config.setDisplayName(FormatUtil.stripCodes(mc.field_1724.method_5476().getString()));
        }
    }
}

