/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list;

import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.SilentButton;
import dev.terminalmc.chatnotify.gui.widget.slider.DoubleSlider;
import dev.terminalmc.chatnotify.mixin.accessor.AbstractWidgetAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_7940;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionList
extends class_4265<Entry> {
    protected final class_310 mc;
    protected final OptionScreen screen;
    protected final int entryWidth;
    protected final int entryHeight;
    protected final int entrySpacing;
    protected int rowWidth;
    protected int dynWideEntryWidth;
    protected int dynEntryWidth;
    protected int entryX;
    protected int dynWideEntryX;
    protected int dynEntryX;
    protected int smallWidgetWidth;
    protected int tinyWidgetWidth;

    public OptionList(class_310 mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, int entrySpacing) {
        super(mc, width, height, top, bottom, entryHeight + entrySpacing);
        this.mc = mc;
        this.screen = screen;
        this.entryWidth = entryWidth;
        this.entryHeight = entryHeight;
        this.entrySpacing = entrySpacing;
        this.updateElementBounds();
    }

    protected void updateElementBounds() {
        this.dynWideEntryWidth = Math.max(this.entryWidth, (int)((float)this.field_22742 / 100.0f * Math.max(50.0f, 70.0f - (float)Math.max(0, this.field_22742 - 600) * 0.05f)));
        this.dynEntryWidth = Math.max(this.entryWidth, (int)((float)this.field_22742 / 100.0f * Math.max(30.0f, 50.0f - (float)Math.max(0, this.field_22742 - 600) * 0.05f)));
        this.entryX = this.field_22742 / 2 - this.entryWidth / 2;
        this.dynWideEntryX = this.field_22742 / 2 - this.dynWideEntryWidth / 2;
        this.dynEntryX = this.field_22742 / 2 - this.dynEntryWidth / 2;
        this.rowWidth = Math.max(this.entryWidth, this.dynWideEntryWidth) + 40 + 48;
        this.smallWidgetWidth = Math.max(16, this.entryHeight);
        this.tinyWidgetWidth = 16;
    }

    protected void init() {
        double scrollAmount = this.method_25341();
        this.method_25339();
        this.method_25395(null);
        this.addEntries();
        this.method_25307(scrollAmount);
    }

    public OptionScreen getScreen() {
        return this.screen;
    }

    public void addEntry(int index, Entry entry) {
        this.method_25396().add(index, entry);
    }

    public void addSpacedEntry(Entry entry) {
        super.method_25321((class_350.class_351)entry);
        super.method_25321((class_350.class_351)new Entry.Space(entry));
    }

    public void addSpacedEntry(int index, Entry entry) {
        this.addEntry(index, entry);
        this.addEntry(index + 1, new Entry.Space(entry));
    }

    protected abstract void addEntries();

    public void method_25323(int width, int height, int top, int bottom) {
        super.method_25323(width, height, top, bottom);
        this.updateElementBounds();
        this.init();
    }

    public int method_25322() {
        return this.rowWidth;
    }

    protected int method_25329() {
        return this.field_22742 / 2 + this.rowWidth / 2;
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        public static final int SPACE = 4;
        public static final int SPACE_SMALL = 2;
        public static final int SPACE_TINY = 1;
        public static final class_2960 OPTIONS_ICON = new class_2960("chatnotify", "textures/gui/sprites/widget/options_button.png");
        public final List<class_339> elements = new ArrayList<class_339>();

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.elements;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.elements;
        }

        public void method_25343(@NotNull class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.elements.forEach(widget -> {
                widget.method_46419(y);
                widget.method_25394(graphics, mouseX, mouseY, delta);
            });
        }

        public static class Space
        extends Entry {
            private final Entry entry;

            public Space(Entry entry) {
                this.entry = entry;
            }

            public boolean method_25397() {
                return this.entry.method_25397();
            }

            public void method_25398(boolean dragging) {
                this.entry.method_25398(dragging);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                return this.entry.method_25402(mouseX, mouseY, button);
            }

            public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
                return this.entry.method_25403(mouseX, mouseY, button, deltaX, deltaY);
            }

            public void method_25395(class_364 listener) {
                this.entry.method_25395(listener);
            }

            public class_364 method_25399() {
                return this.entry.method_25399();
            }

            public class_8016 method_48208(@NotNull class_8023 event, int i) {
                if (this.entry.method_25396().isEmpty()) {
                    return null;
                }
                class_8016 $$2 = this.entry.method_25396().get(Math.min(i, this.entry.method_25396().size() - 1)).method_48205(event);
                return class_8016.method_48192((class_4069)this.entry, (class_8016)$$2);
            }
        }

        public static class DoubleSlider
        extends Entry {
            public DoubleSlider(int x, int width, int height, double min, double max, int precision, @Nullable String messagePrefix, @Nullable String messageSuffix, @Nullable String valueNameMin, @Nullable String valueNameMax, Supplier<Double> source, Consumer<Double> dest) {
                this.elements.add(new dev.terminalmc.chatnotify.gui.widget.slider.DoubleSlider(x, 0, width, height, min, max, precision, messagePrefix, messageSuffix, valueNameMin, valueNameMax, source, dest));
            }
        }

        public static class SilentActionButton
        extends Entry {
            public SilentActionButton(int x, int width, int height, class_2561 message, @Nullable class_7919 tooltip, int tooltipDelay, class_4185.class_4241 onPress) {
                SilentButton silentButton = new SilentButton(x, 0, width, height, message, onPress);
                if (tooltip != null) {
                    silentButton.method_47400(tooltip);
                }
                if (tooltipDelay >= 0) {
                    silentButton.method_47402(tooltipDelay);
                }
                this.elements.add(silentButton);
            }
        }

        public static class ActionButton
        extends Entry {
            private final class_4185 button;

            public ActionButton(int x, int width, int height, class_2561 message, @Nullable class_7919 tooltip, int tooltipDelay, class_4185.class_4241 onPress) {
                this.button = class_4185.method_46430((class_2561)message, (class_4185.class_4241)onPress).method_46433(x, 0).method_46437(width, height).method_46431();
                if (tooltip != null) {
                    this.button.method_47400(tooltip);
                }
                if (tooltipDelay >= 0) {
                    this.button.method_47402(tooltipDelay);
                }
                this.elements.add(this.button);
            }

            public void setBounds(int x, int width, int height) {
                this.button.method_48229(x, 0);
                this.button.method_25358(width);
                ((AbstractWidgetAccessor)this.button).chatnotify$setHeight(height);
            }
        }

        public static class Text
        extends Entry {
            public Text(int x, int width, int height, class_2561 message, @Nullable class_7919 tooltip, int tooltipDelay) {
                Object widget = class_310.method_1551().field_1772.method_1727(message.getString()) <= width ? new class_7842(x, 0, width, height, message, class_310.method_1551().field_1772) : new class_7940(x, 0, message, class_310.method_1551().field_1772).method_48984(width).method_48981(true);
                if (tooltip != null) {
                    widget.method_47400(tooltip);
                }
                if (tooltipDelay >= 0) {
                    widget.method_47402(tooltipDelay);
                }
                this.elements.add(widget);
            }
        }
    }
}

