/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif.trigger;

import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeySelectorList
extends OptionList {
    public static final String[] CHAT_KEYS = new String[]{".", "chat.type", "chat.type.text", "chat.type.announcement", "chat.type.admin", "chat.type.emote", "chat.type.team.sent", "chat.type.team.text"};
    public static final String[] PLAYER_KEYS = new String[]{"multiplayer.player.joined", "multiplayer.player.left", "death."};
    public static final String[] ADVANCEMENT_KEYS = new String[]{"chat.type.advancement", "chat.type.advancement.task", "chat.type.advancement.goal", "chat.type.advancement.challenge"};
    public static final String[] COMMAND_KEYS = new String[]{"commands.", "commands.message.display", "commands.message.display.incoming", "commands.message.display.outgoing"};
    private final Trigger trigger;

    public KeySelectorList(class_310 mc, OptionScreen screen, int width, int height, int top, int bottom, int entryWidth, int entryHeight, Trigger trigger) {
        super(mc, screen, width, height, top, bottom, entryWidth, entryHeight, 1);
        this.trigger = trigger;
    }

    @Override
    protected void addEntries() {
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("option", "notif.trigger.selector.list", Unicode.INFO.str), class_7919.method_47407((class_2561)Localization.localized("option", "notif.trigger.selector.list.tooltip", new Object[0])), -1));
        this.method_25321((class_350.class_351)new Entry.TriggerOption(this.dynWideEntryX, this.dynWideEntryWidth, this.entryHeight, this.trigger));
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("key", "group.chat", new Object[0]), null, -1));
        this.addKeyEntries(CHAT_KEYS);
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("key", "group.player", new Object[0]), null, -1));
        this.addKeyEntries(PLAYER_KEYS);
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("key", "group.advancement", new Object[0]), null, -1));
        this.addKeyEntries(ADVANCEMENT_KEYS);
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("key", "group.command", new Object[0]), null, -1));
        this.addKeyEntries(COMMAND_KEYS);
    }

    private void addKeyEntries(String[] keys) {
        for (int i = 0; i < keys.length; ++i) {
            this.method_25321((class_350.class_351)new Entry.KeyOption(this.entryX, this.entryWidth, this.entryHeight, this, this.trigger, keys[i], i < keys.length - 1 ? keys[++i] : null));
        }
    }

    private static abstract class Entry
    extends OptionList.Entry {
        private Entry() {
        }

        private static class KeyOption
        extends Entry {
            KeyOption(int x, int width, int height, KeySelectorList list, Trigger trigger, @NotNull String key1, @Nullable String key2) {
                int buttonWidth = (width - 1) / 2;
                this.elements.add(class_4185.method_46430((class_2561)Localization.localized("key", "id." + key1, new Object[0]), button -> {
                    trigger.string = key1;
                    list.method_25307(0.0);
                    list.init();
                }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)key1))).method_46433(x, 0).method_46437(buttonWidth, height).method_46431());
                if (key2 != null) {
                    this.elements.add(class_4185.method_46430((class_2561)Localization.localized("key", "id." + key2, new Object[0]), button -> {
                        trigger.string = key2;
                        list.method_25307(0.0);
                        list.init();
                    }).method_46436(class_7919.method_47407((class_2561)class_2561.method_43470((String)key2))).method_46433(x + width - buttonWidth, 0).method_46437(buttonWidth, height).method_46431());
                }
            }
        }

        private static class TriggerOption
        extends Entry {
            TriggerOption(int x, int width, int height, Trigger trigger) {
                TextField triggerField = new TextField(x, 0, width, height);
                if (trigger.type == Trigger.Type.REGEX) {
                    triggerField.regexValidator();
                }
                triggerField.method_1880(240);
                triggerField.method_1852(trigger.string);
                triggerField.method_1863(str -> {
                    trigger.string = str.strip();
                });
                triggerField.method_47404((class_2561)Localization.localized("option", "notif.trigger.field.hint", new Object[0]));
                this.elements.add(triggerField);
            }
        }
    }
}

