/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.util.text;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.compat.chatheads.ChatHeadsWrapper;
import dev.terminalmc.chatnotify.config.Config;
import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.Response;
import dev.terminalmc.chatnotify.config.Trigger;
import dev.terminalmc.chatnotify.gui.toast.NotificationToast;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.text.FormatUtil;
import dev.terminalmc.chatnotify.util.text.StyleUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_640;
import net.minecraft.class_7417;
import org.jetbrains.annotations.Nullable;

public class MessageUtil {
    private static boolean debug = false;
    private static boolean ownMsg = false;

    private MessageUtil() {
    }

    @Nullable
    public static class_2561 processMessage(class_2561 msg) {
        String cleanStr;
        String cleanOwnedStr;
        debug = Config.get().debugMode.equals((Object)Config.DebugMode.ALL);
        ownMsg = false;
        String str = msg.getString();
        if (str.isBlank()) {
            return msg;
        }
        if (ChatNotify.unmodifiedChat.size() > 30) {
            ChatNotify.unmodifiedChat.poll();
        }
        ChatNotify.unmodifiedChat.add(msg);
        if (debug) {
            ChatNotify.LOG.warn("Processing new message", new Object[0]);
            ChatNotify.LOG.warn("Original text:", new Object[0]);
            ChatNotify.LOG.warn(msg.getString(), new Object[0]);
            ChatNotify.LOG.warn("Original tree:", new Object[0]);
            ChatNotify.LOG.warn(msg.toString(), new Object[0]);
        }
        ownMsg = !(cleanOwnedStr = MessageUtil.checkOwner(cleanStr = FormatUtil.stripCodes(str))).equals(cleanStr);
        msg = MessageUtil.tryNotify((class_2561)msg.method_27661(), cleanStr, cleanOwnedStr);
        if (debug) {
            ChatNotify.LOG.warn("Finished processing message", new Object[0]);
            if (msg == null) {
                ChatNotify.LOG.warn("null", new Object[0]);
            } else {
                ChatNotify.LOG.warn("Final text:", new Object[0]);
                ChatNotify.LOG.warn(msg.getString(), new Object[0]);
                ChatNotify.LOG.warn("Final tree:", new Object[0]);
                ChatNotify.LOG.warn(msg.toString(), new Object[0]);
            }
        }
        return msg;
    }

    private static String checkOwner(String cleanStr) {
        class_640 ownerInfo = null;
        Object cleanOwnedStr = cleanStr;
        if (Config.get().senderDetectionMode == Config.SenderDetectionMode.COMBINED) {
            ownerInfo = ChatHeadsWrapper.getPlayerInfo();
        }
        if (ownerInfo != null) {
            UUID id;
            if (debug) {
                ChatNotify.LOG.warn("Owner check using ChatHeads", new Object[0]);
            }
            if (class_310.method_1551().field_1724 != null && (id = ownerInfo.method_2966().getId()).equals(class_310.method_1551().field_1724.method_5667())) {
                if (debug) {
                    ChatNotify.LOG.warn("Matched user's UUID", new Object[0]);
                }
                for (Trigger t : Config.get().getUserNotif().triggers) {
                    Matcher matcher = MessageUtil.normalSearch(cleanStr, t.string);
                    if (!matcher.find()) continue;
                    if (debug) {
                        ChatNotify.LOG.warn("Matched trigger '{}'", t.string);
                    }
                    cleanOwnedStr = cleanStr.substring(0, matcher.start()) + cleanStr.substring(matcher.end());
                    break;
                }
            }
        } else {
            if (debug) {
                ChatNotify.LOG.warn("Owner check using heuristic", new Object[0]);
            }
            block1: for (int i = 0; i < ChatNotify.recentMessages.size(); ++i) {
                Matcher recentMatcher = Pattern.compile("(?iU)" + Pattern.quote((String)ChatNotify.recentMessages.get(i).getSecond())).matcher(cleanStr);
                int recentStart = -1;
                while (recentMatcher.find()) {
                    recentStart = recentMatcher.start();
                }
                if (recentStart == -1) continue;
                if (debug) {
                    ChatNotify.LOG.warn("Matched recent message '{}' at index {}", ChatNotify.recentMessages.get(i).getSecond(), recentStart);
                }
                String prefix = cleanStr.substring(0, recentStart);
                for (Trigger t : Config.get().getUserNotif().triggers) {
                    Matcher triggerMatcher = MessageUtil.normalSearch(prefix, t.string);
                    if (!triggerMatcher.find()) continue;
                    if (debug) {
                        ChatNotify.LOG.warn("Matched trigger '{}' at index {}", t.string, triggerMatcher.start());
                    }
                    ChatNotify.recentMessages.remove(i);
                    cleanOwnedStr = cleanStr.substring(0, triggerMatcher.start() + triggerMatcher.group(1).length()) + cleanStr.substring(triggerMatcher.end() - triggerMatcher.group(2).length());
                    continue block1;
                }
            }
        }
        if (debug) {
            ChatNotify.LOG.warn("Owner-checked string: '{}'", cleanOwnedStr);
        }
        return cleanOwnedStr;
    }

    @Nullable
    private static class_2561 tryNotify(class_2561 msg, String cleanStr, String cleanOwnedStr) {
        boolean restyleAll = Config.get().restyleMode.equals((Object)Config.RestyleMode.ALL_INSTANCES);
        boolean anyTriggered = false;
        boolean anySoundPlayed = false;
        for (Notification notif : Config.get().getNotifs()) {
            if (!notif.canBeTriggered(ownMsg)) continue;
            for (Trigger trig : notif.triggers) {
                boolean inMiss;
                Matcher matcher;
                block24: {
                    boolean hit;
                    if (trig.string.isBlank()) continue;
                    matcher = null;
                    switch (trig.type) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORMAL: {
                            boolean bl;
                            if (MessageUtil.normalSearch(cleanOwnedStr, trig.string).find()) {
                                matcher = MessageUtil.normalSearch(cleanStr, trig.string);
                                bl = matcher.find();
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case REGEX: {
                            boolean bl;
                            if (trig.pattern == null) {
                                bl = false;
                                break;
                            }
                            matcher = trig.pattern.matcher(cleanStr);
                            bl = matcher.find();
                            break;
                        }
                        case KEY: {
                            boolean bl = hit = MessageUtil.keySearch(msg, trig.string);
                        }
                    }
                    if (!hit) continue;
                    inMiss = false;
                    if (!notif.inclusionEnabled) break block24;
                    for (Trigger trigger : notif.inclusionTriggers) {
                        boolean bl;
                        block26: {
                            block25: {
                                if (trig.string.isBlank()) continue;
                                switch (trigger.type) {
                                    default: {
                                        throw new IncompatibleClassChangeError();
                                    }
                                    case NORMAL: {
                                        if (!MessageUtil.normalSearch(cleanOwnedStr, trigger.string).find()) break;
                                        break block25;
                                    }
                                    case REGEX: {
                                        if (trigger.pattern != null && !trigger.pattern.matcher(cleanStr).find()) break;
                                        break block25;
                                    }
                                    case KEY: {
                                        if (MessageUtil.keySearch(msg, trigger.string)) break block25;
                                    }
                                }
                                bl = true;
                                break block26;
                            }
                            bl = false;
                        }
                        if (!(inMiss = bl)) continue;
                        break;
                    }
                }
                if (inMiss) continue;
                boolean exHit = false;
                if (notif.exclusionEnabled) {
                    for (Trigger exTrig : notif.exclusionTriggers) {
                        if (trig.string.isBlank()) continue;
                        if (!(exHit = (switch (exTrig.type) {
                            default -> throw new IncompatibleClassChangeError();
                            case Trigger.Type.NORMAL -> MessageUtil.normalSearch(cleanOwnedStr, exTrig.string).find();
                            case Trigger.Type.REGEX -> {
                                if (exTrig.pattern != null && exTrig.pattern.matcher(cleanStr).find()) {
                                    yield true;
                                }
                                yield false;
                            }
                            case Trigger.Type.KEY -> MessageUtil.keySearch(msg, exTrig.string);
                        }))) continue;
                        break;
                    }
                }
                if (exHit) continue;
                anyTriggered = true;
                if (!anySoundPlayed || Config.get().notifMode.equals((Object)Config.NotifMode.ALL)) {
                    anySoundPlayed = MessageUtil.playSound(notif);
                }
                Matcher matcher2 = trig.type == Trigger.Type.REGEX ? matcher : null;
                MessageUtil.sendResponses(notif, matcher2);
                msg = StyleUtil.restyle(msg, cleanStr, trig, matcher, notif.textStyle, restyleAll);
                MessageUtil.showStatusBarMsg(notif, msg, matcher2);
                MessageUtil.showTitleMsg(notif, msg, matcher2);
                MessageUtil.showToastMsg(notif, msg, matcher2);
                MessageUtil.typeTypedMsg(notif, msg, matcher2);
                MessageUtil.copyClipboardMsg(notif, msg, matcher2);
                if (!notif.replacementMsgEnabled) break;
                msg = MessageUtil.convertMsg(notif.replacementMsg, matcher2, msg);
                String str = msg.getString();
                cleanOwnedStr = cleanStr = FormatUtil.stripCodes(str);
                if (!str.isBlank()) break;
                return null;
            }
            if (!anyTriggered || !Config.get().notifMode.equals((Object)Config.NotifMode.SINGLE)) continue;
            return msg;
        }
        return msg;
    }

    public static boolean keySearch(class_2561 msg, String key) {
        if (key.equals(".")) {
            return true;
        }
        class_7417 class_74172 = msg.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 tc = (class_2588)class_74172;
            return tc.method_11022().contains(key);
        }
        return false;
    }

    public static Matcher normalSearch(String msg, String str) {
        return Pattern.compile("(?iU)(?<!\\w)(\\W?)" + Pattern.quote(str) + "(\\W?)(?!\\w)").matcher(msg);
    }

    private static boolean playSound(Notification notif) {
        class_2960 location;
        if (notif.sound.isEnabled() && notif.sound.getVolume() > 0.0f && (location = notif.sound.getResourceLocation()) != null) {
            class_310.method_1551().method_1483().method_4873((class_1113)new class_1109(notif.sound.getResourceLocation(), Config.get().soundSource, notif.sound.getVolume(), notif.sound.getPitch(), class_1113.method_43221(), false, 0, class_1113.class_1114.field_5478, 0.0, 0.0, 0.0, true));
            return true;
        }
        return false;
    }

    private static class_2561 convertMsg(String msgString, @Nullable Matcher matcher, class_2561 msg) {
        msgString = msgString.replaceAll(Matcher.quoteReplacement("$"), Unicode.SECTION.str);
        if (matcher != null && matcher.find(0)) {
            Object replacement;
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                String replacement2 = matcher.group(i) == null ? "" : matcher.group(i);
                msgString = msgString.replaceAll(Matcher.quoteReplacement(Unicode.SECTION.str + "(" + i + ")"), replacement2);
            }
            msg = FormatUtil.convertToStyledLiteral(msg.method_27661());
            ArrayList<int[]> groupReplacementIndices = new ArrayList<int[]>();
            HashMap<Integer, class_5250> groupReplacementMap = new HashMap<Integer, class_5250>();
            for (int groupNum = 0; groupNum <= matcher.groupCount(); ++groupNum) {
                String targetString = "(" + groupNum + ")";
                if (!msgString.contains(targetString)) continue;
                int index = msgString.indexOf(targetString);
                while (index >= 0) {
                    groupReplacementIndices.add(new int[]{index, groupNum});
                    index = msgString.indexOf(targetString, index + targetString.length());
                }
                if (matcher.group(groupNum) == null) {
                    replacement = class_2561.method_43473();
                } else {
                    int start = matcher.start(groupNum);
                    int end = matcher.end(groupNum);
                    replacement = StyleUtil.styledSubstring(msg, start, end);
                }
                groupReplacementMap.put(groupNum, (class_5250)replacement);
            }
            groupReplacementIndices.sort(Comparator.comparingInt(obj -> obj[0]));
            if (!groupReplacementIndices.isEmpty()) {
                class_5250 newMsg = class_2561.method_43473();
                Object startIndex = 0;
                Iterator iterator = groupReplacementIndices.iterator();
                while (iterator.hasNext()) {
                    replacement = (int[])iterator.next();
                    newMsg.method_10852((class_2561)class_2561.method_43470((String)msgString.substring((int)startIndex, (int)replacement[0])));
                    newMsg.method_10852((class_2561)groupReplacementMap.get((int)replacement[1]));
                    startIndex = replacement[0] + ("(" + (int)replacement[1] + ")").length();
                }
                newMsg.method_10852((class_2561)class_2561.method_43470((String)msgString.substring((int)startIndex)));
                return newMsg;
            }
        }
        return class_2561.method_43470((String)msgString);
    }

    private static void showStatusBarMsg(Notification notif, class_2561 msg, Matcher matcher) {
        if (notif.statusBarMsgEnabled) {
            class_2561 displayMsg = notif.statusBarMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.statusBarMsg, matcher, msg);
            class_310.method_1551().field_1705.method_1758(displayMsg, false);
        }
    }

    private static void showTitleMsg(Notification notif, class_2561 msg, Matcher matcher) {
        if (notif.titleMsgEnabled) {
            class_2561 displayMsg = notif.titleMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.titleMsg, matcher, msg);
            class_310.method_1551().field_1705.method_34004(displayMsg);
        }
    }

    private static void showToastMsg(Notification notif, class_2561 msg, Matcher matcher) {
        if (notif.toastMsgEnabled) {
            class_2561 displayMsg = notif.toastMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.toastMsg, matcher, msg);
            class_310.method_1551().method_1566().method_1999((class_368)new NotificationToast(displayMsg));
        }
    }

    private static void typeTypedMsg(Notification notif, class_2561 msg, Matcher matcher) {
        if (notif.typedMsgEnabled && class_310.method_1551().field_1755 == null) {
            class_2561 displayMsg = notif.typedMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.typedMsg, matcher, msg);
            class_310.method_1551().method_1507((class_437)new class_408(displayMsg.getString()));
        }
    }

    private static void copyClipboardMsg(Notification notif, class_2561 msg, Matcher matcher) {
        if (notif.clipboardMsgEnabled) {
            class_2561 displayMsg = notif.clipboardMsg.isBlank() ? msg : MessageUtil.convertMsg(notif.clipboardMsg, matcher, msg);
            class_310.method_1551().field_1774.method_1455(displayMsg.getString());
        }
    }

    private static void sendResponses(Notification notif, @Nullable Matcher matcher) {
        if (notif.responseEnabled) {
            int totalDelay = 0;
            for (Response msg : notif.responses) {
                msg.sendingString = msg.string;
                if (msg.type.equals((Object)Response.Type.REGEX) && matcher != null && matcher.find(0)) {
                    for (int i = 0; i <= matcher.groupCount(); ++i) {
                        String replacement = matcher.group(i) == null ? "" : matcher.group(i);
                        msg.sendingString = msg.sendingString.replaceAll("\\(" + i + "\\)", replacement);
                    }
                }
                msg.countdown = totalDelay += msg.delayTicks;
                ChatNotify.RESPONSES.add(msg);
            }
        }
    }
}

