/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.screen;

import dev.terminalmc.chatnotify.ChatNotify;
import dev.terminalmc.chatnotify.gui.widget.HorizontalList;
import dev.terminalmc.chatnotify.gui.widget.OverlayWidget;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.ScreenAccessor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OptionScreen
extends class_4667 {
    public static final int HEADER_MARGIN = 32;
    public static final int FOOTER_MARGIN = 32;
    public static final int BASE_ROW_WIDTH = 320;
    public static final int SCROLL_BAR_MARGIN = 20;
    public static final int ELEMENT_SPACING = 4;
    public static final int ELEMENT_SPACING_NARROW = 2;
    public static final int ELEMENT_SPACING_FINE = 1;
    public static final int LIST_ENTRY_HEIGHT = 20;
    public static final int LIST_ENTRY_SPACING = 5;
    public static final int HANGING_WIDGET_MARGIN = 24;
    public static final int BASE_LIST_ENTRY_WIDTH = 232;
    public static final int TAB_LIST_HEIGHT = 28;
    public static final int TAB_LIST_Y = 2;
    public static final int TAB_LIST_MARGIN = 24;
    public static final int MIN_TAB_WIDTH = 40;
    public static final int MAX_TAB_WIDTH = 120;
    public static final int TAB_HEIGHT = 20;
    public static final int TAB_SPACING = 4;
    protected final Map<String, class_4185> tabLookup = new HashMap<String, class_4185>();
    protected final HorizontalList<class_4185> tabs = new HorizontalList(24, 2, this.field_22789 - 48, 28, 4, true);
    @Nullable
    private OptionList list;
    @Nullable
    private OverlayWidget overlay = null;

    public OptionScreen(class_437 lastScreen) {
        super(lastScreen, class_310.method_1551().field_1690, (class_2561)class_2561.method_43473());
    }

    protected void method_25426() {
        this.method_37067();
        this.method_48267();
        this.addHeader();
        this.method_60329();
        this.method_31387();
        this.addOverlay();
        this.method_56131();
    }

    public void method_25410(@NotNull class_310 mc, int width, int height) {
        this.field_22789 = width;
        this.field_22790 = height;
        this.method_25426();
    }

    protected void addHeader() {
        this.tabs.method_25358(this.field_22789 - 48);
        this.method_37063((class_364)this.tabs);
    }

    protected void method_60329() {
        if (this.list != null) {
            this.list.method_57714(this.field_22789, this.field_22790 - 32 - 32, 32);
            this.method_37063((class_364)this.list);
        }
    }

    protected void method_31387() {
        int w = 232;
        int h = 20;
        int x = this.field_22789 / 2 - w / 2;
        int y = Math.min(this.field_22790 - h, this.field_22790 - 16 - h / 2);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46433(x, y).method_46437(w, h).method_46431());
    }

    protected void addOverlay() {
        if (this.overlay != null) {
            this.overlay.updateBounds(this.field_22789, this.field_22790);
            this.setOverlay(this.overlay);
        }
    }

    protected void method_60325() {
    }

    public void method_25419() {
        class_437 class_4372 = this.field_21335;
        if (class_4372 instanceof OptionScreen) {
            OptionScreen screen = (OptionScreen)class_4372;
            screen.method_25410(class_310.method_1551(), this.field_22789, this.field_22790);
        }
        super.method_25419();
    }

    protected void setTabs(List<Tab> tabList, String defaultKey) {
        if (tabList.isEmpty()) {
            throw new IllegalArgumentException("Tab list cannot be empty!");
        }
        int defaultIndex = -1;
        int i = 0;
        for (Tab tab : tabList) {
            if (this.tabLookup.containsKey(tab.key)) {
                ChatNotify.LOG.error("Duplicate tab found with key '{}'!", tab.key);
                continue;
            }
            class_5250 title = class_2561.method_43471((String)tab.key);
            class_4185 button = class_4185.method_46430((class_2561)title, b -> {
                this.tabs.entries().forEach(b2 -> {
                    b2.field_22763 = true;
                });
                b.field_22763 = false;
                this.setList(tab.getList(this));
            }).method_46437(Math.clamp((long)(class_310.method_1551().field_1772.method_27525((class_5348)title) + 8), 40, 120), 20).method_46431();
            this.tabLookup.put(tab.key, button);
            this.tabs.addEntry(button);
            if (defaultIndex == -1 && tab.key.equals(defaultKey)) {
                defaultIndex = i;
                continue;
            }
            ++i;
        }
        if (defaultIndex == -1) {
            defaultIndex = 0;
        }
        this.tabs.getEntry((int)defaultIndex).field_22763 = false;
        this.list = tabList.get(defaultIndex).getList(this);
    }

    private void setList(@NotNull OptionList list) {
        this.list = list;
        this.method_25426();
    }

    public void updateTabTitle(String key, class_2561 title) {
        class_4185 button = this.tabLookup.get(key);
        if (button != null) {
            button.method_25355(title);
            button.method_25358(Math.clamp((long)(class_310.method_1551().field_1772.method_27525((class_5348)title) + 8), 40, 120));
        }
    }

    public void setOverlayWidget(OverlayWidget widget) {
        widget.addOnClose(w -> this.removeOverlay());
        this.setOverlay(widget);
    }

    private void setOverlay(OverlayWidget widget) {
        this.removeOverlay();
        this.overlay = widget;
        this.setChildrenVisible(false);
        ((ScreenAccessor)((Object)this)).chatnotify$getChildren().addFirst((class_364)widget);
        ((ScreenAccessor)((Object)this)).chatnotify$getNarratables().addFirst((class_6379)widget);
        ((ScreenAccessor)((Object)this)).chatnotify$getRenderables().addLast((class_4068)widget);
    }

    public void removeOverlay() {
        if (this.overlay != null) {
            this.method_37066((class_364)this.overlay);
            this.overlay = null;
            this.setChildrenVisible(true);
        }
    }

    private void setChildrenVisible(boolean visible) {
        for (class_364 listener : this.method_25396()) {
            if (!(listener instanceof class_339)) continue;
            class_339 widget = (class_339)listener;
            widget.field_22764 = visible;
        }
    }

    public boolean method_25404(class_11908 event) {
        if (this.overlay != null) {
            if (event.comp_4795() == 256) {
                this.overlay.onClose();
                this.removeOverlay();
            } else {
                this.overlay.method_25404(event);
            }
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_25400(class_11905 event) {
        if (this.overlay != null) {
            this.overlay.method_25400(event);
            return true;
        }
        return super.method_25400(event);
    }

    public static class Tab {
        final String key;
        private final Function<OptionScreen, OptionList> supplier;
        @Nullable
        private OptionList list = null;

        public Tab(String key, Function<OptionScreen, OptionList> supplier) {
            this.key = key;
            this.supplier = supplier;
        }

        @NotNull
        public OptionList getList(OptionScreen screen) {
            if (this.list == null) {
                this.list = this.supplier.apply(screen);
            }
            return this.list;
        }
    }
}

