/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.toast;

import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.NotNull;

public class NotificationToast
implements class_368 {
    private static final class_2960 BACKGROUND_SPRITE = class_2960.method_60656((String)"toast/advancement");
    private static final int WIDTH = 160;
    private static final int HEIGHT = 32;
    private static final int X_MARGIN = 10;
    private static final int Y_MARGIN = 6;
    private static final int LINE_SPACE = 3;
    private final int lineHeight;
    private final List<class_5481> messageLines;
    private class_368.class_369 wantedVisibility;
    private final int displayTime;

    public NotificationToast(class_2561 message, int displayTime) {
        this.messageLines = class_310.method_1551().field_1772.method_1728((class_5348)message, 140);
        Objects.requireNonNull(class_310.method_1551().field_1772);
        this.lineHeight = 9 + 3;
        this.displayTime = displayTime;
    }

    @NotNull
    public class_368.class_369 method_61988() {
        return this.wantedVisibility;
    }

    public void method_61989(@NotNull class_374 manager, long elapsedTime) {
        this.wantedVisibility = (double)elapsedTime < (double)this.displayTime * manager.method_48221() ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    public void method_1986(@NotNull class_332 graphics, @NotNull class_327 font, long elapsedTime) {
        if (this.messageLines.size() <= 1) {
            graphics.method_52706(class_10799.field_56883, BACKGROUND_SPRITE, 0, 0, 160, this.method_29050());
        } else {
            int width = 160;
            int height = 32 + this.lineHeight * Math.max(0, this.messageLines.size() - 2);
            int partialSpriteHeight = 28;
            int bottomSpriteHeight = Math.min(4, height - partialSpriteHeight);
            this.renderBackgroundRow(graphics, width, 0, 0, partialSpriteHeight);
            int offset = 10;
            for (int y = partialSpriteHeight; y < height - bottomSpriteHeight; y += offset) {
                int vOffset = 16;
                int vHeight = Math.min(16, height - y - bottomSpriteHeight);
                this.renderBackgroundRow(graphics, width, vOffset, y, vHeight);
            }
            this.renderBackgroundRow(graphics, width, 32 - bottomSpriteHeight, height - bottomSpriteHeight, bottomSpriteHeight);
        }
        if (this.messageLines.size() == 1) {
            graphics.method_51430(font, this.messageLines.getFirst(), 10, 6 + this.lineHeight / 2, -1, false);
        } else {
            for (int j = 0; j < this.messageLines.size(); ++j) {
                graphics.method_51430(font, this.messageLines.get(j), 10, 6 + this.lineHeight * j, -1, false);
            }
        }
    }

    private void renderBackgroundRow(class_332 graphics, int width, int vOffset, int y, int vHeight) {
        int uWidth = vOffset == 0 ? 20 : 5;
        int uRemainder = Math.min(60, width - uWidth);
        graphics.method_70846(class_10799.field_56883, BACKGROUND_SPRITE, 160, 32, 0, vOffset, 0, y, uWidth, vHeight);
        int offset = 64;
        for (int x = uWidth; x < width - uRemainder; x += offset) {
            graphics.method_70846(class_10799.field_56883, BACKGROUND_SPRITE, 160, 32, 32, vOffset, x, y, Math.min(offset, width - x - uRemainder), vHeight);
        }
        graphics.method_70846(class_10799.field_56883, BACKGROUND_SPRITE, 160, 32, 160 - uRemainder, vOffset, width - uRemainder, y, uRemainder, vHeight);
    }
}

