/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.gui.widget.list.root.notif;

import dev.terminalmc.chatnotify.config.Notification;
import dev.terminalmc.chatnotify.config.TextStyle;
import dev.terminalmc.chatnotify.gui.screen.OptionScreen;
import dev.terminalmc.chatnotify.gui.widget.HsvColorPicker;
import dev.terminalmc.chatnotify.gui.widget.field.TextField;
import dev.terminalmc.chatnotify.gui.widget.list.OptionList;
import dev.terminalmc.chatnotify.mixin.accessor.TextColorAccessor;
import dev.terminalmc.chatnotify.util.Localization;
import dev.terminalmc.chatnotify.util.Unicode;
import dev.terminalmc.chatnotify.util.text.ColorUtil;
import java.awt.Color;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5676;
import net.minecraft.class_7919;
import net.minecraft.class_9848;

public class FormatList
extends OptionList {
    private final Notification notif;

    public FormatList(class_310 mc, OptionScreen screen, int width, int height, int y, int entryWidth, int entryHeight, int entrySpacing, Notification notif) {
        super(mc, screen, width, height, y, entryWidth, entryHeight, entrySpacing);
        this.notif = notif;
    }

    @Override
    protected void addEntries() {
        this.method_25321((class_350.class_351)new OptionList.Entry.Text(this.entryX, this.entryWidth, this.entryHeight, (class_2561)Localization.localized("option", "notif.format.list", Unicode.INFO.str), class_7919.method_47407((class_2561)Localization.localized("option", "notif.format.list.tooltip", new Object[0])), -1));
        this.method_25321((class_350.class_351)new Entry.ColorOptions(this.entryX, this.entryWidth, this.entryHeight, this, () -> this.notif.textStyle.color, val -> {
            this.notif.textStyle.color = val;
        }, () -> this.notif.textStyle.doColor, val -> {
            this.notif.textStyle.doColor = val;
        }, Localization.localized("option", "notif.format.color", new Object[0])));
        this.method_25321((class_350.class_351)new Entry.FormatOptions(this.entryX, this.entryWidth, this.entryHeight, this.notif, true));
        this.method_25321((class_350.class_351)new Entry.FormatOptions(this.entryX, this.entryWidth, this.entryHeight, this.notif, false));
    }

    private void initList() {
        this.init();
    }

    static abstract class Entry
    extends OptionList.Entry {
        Entry() {
        }

        private static class FormatOptions
        extends Entry {
            private FormatOptions(int x, int width, int height, Notification notif, boolean first) {
                if (first) {
                    this.createFirst(x, width, height, notif);
                } else {
                    this.createSecond(x, width, height, notif);
                }
            }

            private void createFirst(int x, int width, int height, Notification notif) {
                int buttonWidth = (width - 8) / 3;
                class_5676 boldButton = class_5676.method_32606(state -> this.getMessage((TextStyle.FormatMode)((Object)state), class_124.field_1067)).method_32624((Object[])TextStyle.FormatMode.values()).method_32619((Object)notif.textStyle.bold).method_32618(this::getTooltip).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "notif.format.bold", new Object[0]), (button, state) -> {
                    notif.textStyle.bold = state;
                });
                boldButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(boldButton);
                class_5676 italicButton = class_5676.method_32606(state -> this.getMessage((TextStyle.FormatMode)((Object)state), class_124.field_1056)).method_32624((Object[])TextStyle.FormatMode.values()).method_32619((Object)notif.textStyle.italic).method_32618(this::getTooltip).method_32617(x + width / 2 - buttonWidth / 2, 0, buttonWidth, height, (class_2561)Localization.localized("option", "notif.format.italic", new Object[0]), (button, state) -> {
                    notif.textStyle.italic = state;
                });
                italicButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(italicButton);
                class_5676 underlineButton = class_5676.method_32606(state -> this.getMessage((TextStyle.FormatMode)((Object)state), class_124.field_1073)).method_32624((Object[])TextStyle.FormatMode.values()).method_32619((Object)notif.textStyle.underlined).method_32618(this::getTooltip).method_32617(x + width - buttonWidth, 0, buttonWidth, height, (class_2561)Localization.localized("option", "notif.format.underline", new Object[0]), (button, state) -> {
                    notif.textStyle.underlined = state;
                });
                underlineButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(underlineButton);
            }

            private void createSecond(int x, int width, int height, Notification notif) {
                int buttonWidth = (width - 4) / 2;
                class_5676 strikethroughButton = class_5676.method_32606(state -> this.getMessage((TextStyle.FormatMode)((Object)state), class_124.field_1055)).method_32624((Object[])TextStyle.FormatMode.values()).method_32619((Object)notif.textStyle.strikethrough).method_32618(this::getTooltip).method_32617(x, 0, buttonWidth, height, (class_2561)Localization.localized("option", "notif.format.strikethrough", new Object[0]), (button, state) -> {
                    notif.textStyle.strikethrough = state;
                });
                strikethroughButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(strikethroughButton);
                class_5676 obfuscateButton = class_5676.method_32606(state -> this.getMessage((TextStyle.FormatMode)((Object)state), class_124.field_1051)).method_32624((Object[])TextStyle.FormatMode.values()).method_32619((Object)notif.textStyle.obfuscated).method_32618(this::getTooltip).method_32617(x + width - buttonWidth, 0, buttonWidth, height, (class_2561)Localization.localized("option", "notif.format.obfuscate", new Object[0]), (button, state) -> {
                    notif.textStyle.obfuscated = state;
                });
                obfuscateButton.method_47402(Duration.ofMillis(500L));
                this.elements.add(obfuscateButton);
            }

            private class_2561 getMessage(TextStyle.FormatMode mode, class_124 format) {
                return switch (mode) {
                    case TextStyle.FormatMode.ON -> class_5244.field_24332.method_27661().method_27692(format).method_27692(class_124.field_1060);
                    case TextStyle.FormatMode.OFF -> class_5244.field_24333.method_27661().method_27692(class_124.field_1061);
                    default -> class_2561.method_43470((String)"/").method_27692(class_124.field_1080);
                };
            }

            private class_7919 getTooltip(TextStyle.FormatMode mode) {
                return mode.equals((Object)TextStyle.FormatMode.DISABLED) ? class_7919.method_47407((class_2561)Localization.localized("option", "notif.format.disabled.tooltip", new Object[0])) : null;
            }
        }

        private static class ColorOptions
        extends Entry {
            ColorOptions(int x, int width, int height, FormatList list, Supplier<Integer> supplier, Consumer<Integer> consumer, Supplier<Boolean> statusSupplier, Consumer<Boolean> statusConsumer, class_5250 text) {
                int statusButtonWidth = Math.max(24, height);
                int colorFieldWidth = class_310.method_1551().field_1772.method_1727("#FFAAFF+++");
                int mainButtonWidth = width - colorFieldWidth - statusButtonWidth - 8;
                class_4185 mainButton = class_4185.method_46430((class_2561)text.method_54663(supplier.get().intValue()), button -> {
                    int cpHeight = 80;
                    int cpWidth = 200;
                    list.getScreen().setOverlayWidget(new HsvColorPicker(x + width / 2 - cpWidth / 2, list.getScreen().field_22790 / 2 - cpHeight / 2, cpWidth, cpHeight, supplier, consumer, widget -> list.initList()));
                }).method_46433(x, 0).method_46437(mainButtonWidth, height).method_46431();
                this.elements.add(mainButton);
                TextField colorField = new TextField(x + mainButtonWidth + 4, 0, colorFieldWidth, height);
                colorField.hexColorValidator().strict();
                colorField.method_1880(7);
                colorField.method_1863(val -> {
                    class_5251 textColor = ColorUtil.parseColor(val);
                    if (textColor != null) {
                        int color = textColor.method_27716();
                        consumer.accept(color);
                        mainButton.method_25355((class_2561)mainButton.method_25369().method_27661().method_54663(color));
                        float[] hsv = new float[3];
                        Color.RGBtoHSB(class_9848.method_61327((int)color), class_9848.method_61329((int)color), class_9848.method_61331((int)color), hsv);
                        if ((double)hsv[2] < 0.1) {
                            colorField.method_1868(-1);
                        } else {
                            colorField.method_1868(0xFF000000 | color);
                        }
                    }
                });
                colorField.method_1852(((TextColorAccessor)class_5251.method_27717((int)supplier.get())).chatnotify$formatValue());
                this.elements.add(colorField);
                this.elements.add(class_5676.method_32607((class_2561)class_5244.field_24332.method_27661().method_27692(class_124.field_1060), (class_2561)class_5244.field_24333.method_27661().method_27692(class_124.field_1061)).method_32616().method_32619((Object)statusSupplier.get()).method_32617(x + width - statusButtonWidth, 0, statusButtonWidth, height, (class_2561)class_2561.method_43473(), (button, status) -> statusConsumer.accept((Boolean)status)));
            }
        }
    }
}

