/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.chatnotify.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.terminalmc.chatnotify.config.util.JsonUtil;
import java.lang.reflect.Type;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class Sound {
    public static final int VERSION = 1;
    public final int version = 1;
    private boolean enabled;
    private static final boolean enabledDefault = true;
    private String id;
    private static final String idDefault = "block.note_block.bell";
    private float volume;
    private static final float volumeDefault = 1.0f;
    private float pitch;
    private static final float pitchDefault = 1.0f;

    public Sound() {
        this.enabled = true;
        this.id = idDefault;
        this.volume = 1.0f;
        this.pitch = 1.0f;
    }

    Sound(boolean enabled, String id, float volume, float pitch) {
        if (!Sound.validId(id)) {
            throw new IllegalArgumentException("Specified id is not a valid sound.");
        }
        this.enabled = enabled;
        this.id = id;
        this.volume = volume;
        this.pitch = pitch;
    }

    public Sound(Sound pSound) {
        this.enabled = pSound.enabled;
        this.id = pSound.id;
        this.volume = pSound.volume;
        this.pitch = pSound.pitch;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled && this.volume == 0.0f) {
            this.volume = 1.0f;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (Sound.validId(id)) {
            this.id = id;
        }
    }

    @Nullable
    public class_2960 getResourceLocation() {
        return class_2960.method_12829((String)this.id);
    }

    public float getVolume() {
        return this.volume;
    }

    public void setVolume(float volume) {
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("Value out of range. Expected 0-1, got " + volume);
        }
        this.volume = volume;
        if (volume == 0.0f) {
            this.enabled = false;
        } else if (!this.enabled) {
            this.enabled = true;
        }
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        if ((double)pitch < 0.5 || pitch > 2.0f) {
            throw new IllegalArgumentException("Value out of range. Expected 0.5-2, got " + pitch);
        }
        this.pitch = pitch;
    }

    Sound validate() {
        if (this.volume < 0.0f || this.volume > 1.0f) {
            this.volume = 1.0f;
        }
        if ((double)this.pitch < 0.5 || this.pitch > 2.0f) {
            this.pitch = 1.0f;
        }
        return this;
    }

    public static boolean validId(String id) {
        return class_2960.method_12829((String)id) != null;
    }

    public static class Deserializer
    implements JsonDeserializer<Sound> {
        public Sound deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            JsonObject obj = json.getAsJsonObject();
            int version = obj.get("version").getAsInt();
            boolean silent = version != 1;
            boolean enabled = JsonUtil.getOrDefault(obj, "enabled", true, silent);
            String id = JsonUtil.getOrDefault(obj, "id", Sound.idDefault, silent);
            float volume = JsonUtil.getOrDefault(obj, "volume", 1.0f, silent);
            float pitch = JsonUtil.getOrDefault(obj, "pitch", 1.0f, silent);
            return new Sound(enabled, id, volume, pitch).validate();
        }
    }
}

